/*
 * Decompiled with CFR 0.152.
 */
package glide.api;

import command_request.CommandRequestOuterClass;
import glide.api.ResponseFlags;
import glide.api.commands.BitmapBaseCommands;
import glide.api.commands.GenericBaseCommands;
import glide.api.commands.GeospatialIndicesBaseCommands;
import glide.api.commands.HashBaseCommands;
import glide.api.commands.HyperLogLogBaseCommands;
import glide.api.commands.ListBaseCommands;
import glide.api.commands.PubSubBaseCommands;
import glide.api.commands.ScriptingAndFunctionsBaseCommands;
import glide.api.commands.SetBaseCommands;
import glide.api.commands.SortedSetBaseCommands;
import glide.api.commands.StreamBaseCommands;
import glide.api.commands.StringBaseCommands;
import glide.api.commands.TransactionsBaseCommands;
import glide.api.models.ClusterValue;
import glide.api.models.GlideString;
import glide.api.models.PubSubMessage;
import glide.api.models.Script;
import glide.api.models.commands.ExpireOptions;
import glide.api.models.commands.GetExOptions;
import glide.api.models.commands.HGetExOptions;
import glide.api.models.commands.HSetExOptions;
import glide.api.models.commands.HashFieldExpirationConditionOptions;
import glide.api.models.commands.LInsertOptions;
import glide.api.models.commands.LPosOptions;
import glide.api.models.commands.ListDirection;
import glide.api.models.commands.RangeOptions;
import glide.api.models.commands.RestoreOptions;
import glide.api.models.commands.ScoreFilter;
import glide.api.models.commands.ScriptOptions;
import glide.api.models.commands.ScriptOptionsGlideString;
import glide.api.models.commands.SetOptions;
import glide.api.models.commands.SortOptions;
import glide.api.models.commands.SortOptionsBinary;
import glide.api.models.commands.WeightAggregateOptions;
import glide.api.models.commands.ZAddOptions;
import glide.api.models.commands.bitmap.BitFieldOptions;
import glide.api.models.commands.bitmap.BitmapIndexType;
import glide.api.models.commands.bitmap.BitwiseOperation;
import glide.api.models.commands.geospatial.GeoAddOptions;
import glide.api.models.commands.geospatial.GeoSearchOptions;
import glide.api.models.commands.geospatial.GeoSearchOrigin;
import glide.api.models.commands.geospatial.GeoSearchResultOptions;
import glide.api.models.commands.geospatial.GeoSearchShape;
import glide.api.models.commands.geospatial.GeoSearchStoreOptions;
import glide.api.models.commands.geospatial.GeoUnit;
import glide.api.models.commands.geospatial.GeospatialData;
import glide.api.models.commands.scan.HScanOptions;
import glide.api.models.commands.scan.HScanOptionsBinary;
import glide.api.models.commands.scan.SScanOptions;
import glide.api.models.commands.scan.SScanOptionsBinary;
import glide.api.models.commands.scan.ZScanOptions;
import glide.api.models.commands.scan.ZScanOptionsBinary;
import glide.api.models.commands.stream.StreamAddOptions;
import glide.api.models.commands.stream.StreamAddOptionsBinary;
import glide.api.models.commands.stream.StreamClaimOptions;
import glide.api.models.commands.stream.StreamGroupOptions;
import glide.api.models.commands.stream.StreamPendingOptions;
import glide.api.models.commands.stream.StreamPendingOptionsBinary;
import glide.api.models.commands.stream.StreamRange;
import glide.api.models.commands.stream.StreamReadGroupOptions;
import glide.api.models.commands.stream.StreamReadOptions;
import glide.api.models.commands.stream.StreamTrimOptions;
import glide.api.models.configuration.BaseClientConfiguration;
import glide.api.models.configuration.BaseSubscriptionConfiguration;
import glide.api.models.exceptions.ConfigurationError;
import glide.api.models.exceptions.GlideException;
import glide.connectors.handlers.CallbackDispatcher;
import glide.connectors.handlers.ChannelHandler;
import glide.connectors.handlers.MessageHandler;
import glide.connectors.resources.Platform;
import glide.connectors.resources.ThreadPoolResource;
import glide.connectors.resources.ThreadPoolResourceAllocator;
import glide.ffi.resolvers.GlideValueResolver;
import glide.ffi.resolvers.SocketListenerResolver;
import glide.ffi.resolvers.StatisticsResolver;
import glide.managers.BaseResponseResolver;
import glide.managers.CommandManager;
import glide.managers.ConnectionManager;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.ArrayUtils;
import response.ResponseOuterClass;

public abstract class BaseClient
implements AutoCloseable,
BitmapBaseCommands,
GenericBaseCommands,
StringBaseCommands,
HashBaseCommands,
ListBaseCommands,
SetBaseCommands,
SortedSetBaseCommands,
StreamBaseCommands,
HyperLogLogBaseCommands,
GeospatialIndicesBaseCommands,
ScriptingAndFunctionsBaseCommands,
TransactionsBaseCommands,
PubSubBaseCommands {
    public static final String OK = ResponseOuterClass.ConstantResponse.OK.toString();
    protected final CommandManager commandManager;
    protected final ConnectionManager connectionManager;
    protected final MessageHandler messageHandler;
    protected final Optional<BaseSubscriptionConfiguration> subscriptionConfiguration;
    private static final BaseResponseResolver responseResolver = new BaseResponseResolver(GlideValueResolver::valueFromPointer);
    private static final BaseResponseResolver binaryResponseResolver = new BaseResponseResolver(GlideValueResolver::valueFromPointerBinary);

    protected BaseClient(ClientBuilder builder) {
        this.connectionManager = builder.connectionManager;
        this.commandManager = builder.commandManager;
        this.messageHandler = builder.messageHandler;
        this.subscriptionConfiguration = builder.subscriptionConfiguration;
    }

    protected static <T extends BaseClient> CompletableFuture<T> createClient(@NonNull BaseClientConfiguration config, Function<ClientBuilder, T> constructor) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        try {
            ThreadPoolResource threadPoolResource = ThreadPoolResourceAllocator.getOrCreate(Platform.getThreadPoolResourceSupplier());
            MessageHandler messageHandler = BaseClient.buildMessageHandler(config);
            ChannelHandler channelHandler = BaseClient.buildChannelHandler(threadPoolResource, messageHandler);
            ConnectionManager connectionManager = BaseClient.buildConnectionManager(channelHandler);
            CommandManager commandManager = BaseClient.buildCommandManager(channelHandler);
            return connectionManager.connectToValkey(config).thenApply(ignored -> (BaseClient)constructor.apply(new ClientBuilder(connectionManager, commandManager, messageHandler, Optional.ofNullable(config.getSubscriptionConfiguration()))));
        }
        catch (InterruptedException e) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(e);
            return future;
        }
    }

    public Map<String, String> getStatistics() {
        return StatisticsResolver.getStatistics();
    }

    public PubSubMessage tryGetPubSubMessage() {
        if (this.subscriptionConfiguration.isEmpty()) {
            throw new ConfigurationError("The operation will never complete since there was no pubsub subscriptions applied to the client.");
        }
        if (this.subscriptionConfiguration.get().getCallback().isPresent()) {
            throw new ConfigurationError("The operation will never complete since messages will be passed to the configured callback.");
        }
        return this.messageHandler.getQueue().popSync();
    }

    public CompletableFuture<PubSubMessage> getPubSubMessage() {
        if (this.subscriptionConfiguration.isEmpty()) {
            throw new ConfigurationError("The operation will never complete since there was no pubsub subscriptions applied to the client.");
        }
        if (this.subscriptionConfiguration.get().getCallback().isPresent()) {
            throw new ConfigurationError("The operation will never complete since messages will be passed to the configured callback.");
        }
        return this.messageHandler.getQueue().popAsync();
    }

    @Override
    public void close() throws ExecutionException {
        try {
            this.connectionManager.closeConnection().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static MessageHandler buildMessageHandler(BaseClientConfiguration config) {
        if (config.getSubscriptionConfiguration() == null) {
            return new MessageHandler(Optional.empty(), Optional.empty(), binaryResponseResolver);
        }
        return new MessageHandler(config.getSubscriptionConfiguration().getCallback(), config.getSubscriptionConfiguration().getContext(), binaryResponseResolver);
    }

    protected static ChannelHandler buildChannelHandler(ThreadPoolResource threadPoolResource, MessageHandler messageHandler) throws InterruptedException {
        CallbackDispatcher callbackDispatcher = new CallbackDispatcher(messageHandler);
        return new ChannelHandler(callbackDispatcher, SocketListenerResolver.getSocket(), threadPoolResource);
    }

    protected static ConnectionManager buildConnectionManager(ChannelHandler channelHandler) {
        return new ConnectionManager(channelHandler);
    }

    protected static CommandManager buildCommandManager(ChannelHandler channelHandler) {
        return new CommandManager(channelHandler);
    }

    protected <T> T handleValkeyResponse(Class<T> classType, EnumSet<ResponseFlags> flags, ResponseOuterClass.Response response) throws GlideException {
        Object value;
        boolean encodingUtf8 = flags.contains((Object)ResponseFlags.ENCODING_UTF8);
        boolean isNullable = flags.contains((Object)ResponseFlags.IS_NULLABLE);
        Object object = value = encodingUtf8 ? responseResolver.apply(response) : binaryResponseResolver.apply(response);
        if (isNullable && value == null) {
            return null;
        }
        if (classType.isInstance(value = this.convertByteArrayToGlideString(value))) {
            return (T)value;
        }
        String className = value == null ? "null" : value.getClass().getSimpleName();
        throw new GlideException("Unexpected return type from Glide: got " + className + " expected " + classType.getSimpleName());
    }

    protected Object handleObjectOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object.class, EnumSet.of(ResponseFlags.IS_NULLABLE, ResponseFlags.ENCODING_UTF8), response);
    }

    protected Object handleBinaryObjectOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected String handleStringResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(String.class, EnumSet.of(ResponseFlags.ENCODING_UTF8), response);
    }

    protected String handleStringOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(String.class, EnumSet.of(ResponseFlags.IS_NULLABLE, ResponseFlags.ENCODING_UTF8), response);
    }

    protected byte[] handleBytesOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        GlideString result = this.handleValkeyResponse(GlideString.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
        if (result == null) {
            return null;
        }
        return result.getBytes();
    }

    protected GlideString handleGlideStringOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(GlideString.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected GlideString handleGlideStringResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(GlideString.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Boolean handleBooleanResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Boolean.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Long handleLongResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Long.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Long handleLongOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Long.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected Double handleDoubleResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Double.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Double handleDoubleOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Double.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected Object[] handleArrayResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object[].class, EnumSet.of(ResponseFlags.ENCODING_UTF8), response);
    }

    protected Object[] handleArrayResponseBinary(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object[].class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Object[] handleArrayOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object[].class, EnumSet.of(ResponseFlags.IS_NULLABLE, ResponseFlags.ENCODING_UTF8), response);
    }

    protected Object[] handleArrayOrNullResponseBinary(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Object[].class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected <V> Map<String, V> handleMapResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Map.class, EnumSet.of(ResponseFlags.ENCODING_UTF8), response);
    }

    protected <V> Map<GlideString, V> handleBinaryStringMapResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Map.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected <V> Map<String, V> handleMapOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Map.class, EnumSet.of(ResponseFlags.IS_NULLABLE, ResponseFlags.ENCODING_UTF8), response);
    }

    protected <V> Map<GlideString, V> handleBinaryStringMapOrNullResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Map.class, EnumSet.of(ResponseFlags.IS_NULLABLE), response);
    }

    protected Map<String, Map<String, String[][]>> handleXReadResponse(ResponseOuterClass.Response response) throws GlideException {
        Map mapResponse = this.handleMapOrNullResponse(response);
        if (mapResponse == null) {
            return null;
        }
        return mapResponse.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ArrayTransformUtils.castMapOf2DArray((Map)e.getValue(), String.class)));
    }

    protected Map<GlideString, Map<GlideString, GlideString[][]>> handleXReadResponseBinary(ResponseOuterClass.Response response) throws GlideException {
        Map mapResponse = this.handleBinaryStringMapOrNullResponse(response);
        if (mapResponse == null) {
            return null;
        }
        return mapResponse.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ArrayTransformUtils.castMapOf2DArray((Map)e.getValue(), GlideString.class)));
    }

    protected Set<String> handleSetResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Set.class, EnumSet.of(ResponseFlags.ENCODING_UTF8), response);
    }

    protected Set<GlideString> handleSetBinaryResponse(ResponseOuterClass.Response response) throws GlideException {
        return this.handleValkeyResponse(Set.class, EnumSet.noneOf(ResponseFlags.class), response);
    }

    protected Map<String, Object>[] handleFunctionListResponse(Object[] response) {
        Map[] data;
        for (Map libraryInfo : data = ArrayTransformUtils.castArray(response, Map.class)) {
            Object[] functions = (Object[])libraryInfo.get("functions");
            Map[] functionInfo = ArrayTransformUtils.castArray(functions, Map.class);
            libraryInfo.put("functions", functionInfo);
        }
        return data;
    }

    protected Map<GlideString, Object>[] handleFunctionListResponseBinary(Object[] response) {
        Map[] data;
        for (Map libraryInfo : data = ArrayTransformUtils.castArray(response, Map.class)) {
            Object[] functions = (Object[])libraryInfo.get(GlideString.gs("functions"));
            Map[] functionInfo = ArrayTransformUtils.castArray(functions, Map.class);
            libraryInfo.put(GlideString.gs("functions"), functionInfo);
        }
        return data;
    }

    protected Map<String, Map<String, Object>> handleFunctionStatsResponse(Map<String, Map<String, Object>> response) {
        Map<String, Object> runningScriptInfo = response.get("running_script");
        if (runningScriptInfo != null) {
            Object[] command = (Object[])runningScriptInfo.get("command");
            runningScriptInfo.put("command", ArrayTransformUtils.castArray(command, String.class));
        }
        return response;
    }

    protected Map<GlideString, Map<GlideString, Object>> handleFunctionStatsBinaryResponse(Map<GlideString, Map<GlideString, Object>> response) {
        Map<GlideString, Object> runningScriptInfo = response.get(GlideString.gs("running_script"));
        if (runningScriptInfo != null) {
            Object[] command = (Object[])runningScriptInfo.get(GlideString.gs("command"));
            runningScriptInfo.put(GlideString.gs("command"), ArrayTransformUtils.castArray(command, GlideString.class));
        }
        return response;
    }

    protected ClusterValue<Map<String, Map<String, Object>>> handleFunctionStatsResponse(ResponseOuterClass.Response response, boolean isSingleValue) {
        if (isSingleValue) {
            return ClusterValue.ofSingleValue(this.handleFunctionStatsResponse(this.handleMapResponse(response)));
        }
        Map data = this.handleMapResponse(response);
        for (Map.Entry<String, Map<String, Map<String, Object>>> entry : data.entrySet()) {
            entry.setValue(this.handleFunctionStatsResponse((Map)entry.getValue()));
        }
        return ClusterValue.ofMultiValue(data);
    }

    protected ClusterValue<Map<GlideString, Map<GlideString, Object>>> handleFunctionStatsBinaryResponse(ResponseOuterClass.Response response, boolean isSingleValue) {
        if (isSingleValue) {
            return ClusterValue.ofSingleValue(this.handleFunctionStatsBinaryResponse(this.handleBinaryStringMapResponse(response)));
        }
        Map data = this.handleBinaryStringMapResponse(response);
        for (Map.Entry<GlideString, Map<GlideString, Map<GlideString, Object>>> entry : data.entrySet()) {
            entry.setValue(this.handleFunctionStatsBinaryResponse((Map)entry.getValue()));
        }
        return ClusterValue.ofMultiValueBinary(data);
    }

    protected Map<String, Object> handleLcsIdxResponse(Map<String, Object> response) throws GlideException {
        Long[][][] convertedMatchesObject = ArrayTransformUtils.cast3DArray((Object[])response.get("matches"), Long.class);
        if (convertedMatchesObject == null) {
            throw new NullPointerException("LCS result does not contain the key \"matches\"");
        }
        response.put("matches", convertedMatchesObject);
        return response;
    }

    public CompletableFuture<String> updateConnectionPassword(@NonNull String password, boolean immediateAuth) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        return this.commandManager.submitPasswordUpdate(Optional.of(password), immediateAuth, this::handleStringResponse);
    }

    public CompletableFuture<String> updateConnectionPassword(boolean immediateAuth) {
        return this.commandManager.submitPasswordUpdate(Optional.empty(), immediateAuth, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> del(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Del, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> del(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Del, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Get, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> get(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Get, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> getdel(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetDel, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> getdel(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetDel, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> getex(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetEx, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> getex(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetEx, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> getex(@NonNull String key, @NonNull GetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(options.toArgs(), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetEx, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> getex(@NonNull GlideString key, @NonNull GetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetEx, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> set(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Set, new String[]{key, value}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> set(@NonNull GlideString key, @NonNull GlideString value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Set, new GlideString[]{key, value}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> set(@NonNull String key, @NonNull String value, @NonNull SetOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{key, value}, options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Set, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> set(@NonNull GlideString key, @NonNull GlideString value, @NonNull SetOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(value).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Set, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> append(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Append, new String[]{key, value}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> append(@NonNull GlideString key, @NonNull GlideString value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Append, new GlideString[]{key, value}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> mget(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MGet, keys, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> mget(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MGet, keys, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String> mset(@NonNull Map<String, String> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.convertMapToKeyValueStringArray(keyValueMap);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MSet, args, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> msetBinary(@NonNull Map<GlideString, GlideString> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.convertMapToKeyValueGlideStringArray(keyValueMap);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MSet, args, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Boolean> move(@NonNull String key, long dbIndex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Move, new String[]{key, Long.toString(dbIndex)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> move(@NonNull GlideString key, long dbIndex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Move, new GlideString[]{key, GlideString.gs(Long.toString(dbIndex))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<String> objectEncoding(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectEncoding, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> objectEncoding(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectEncoding, new GlideString[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectFreq(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectFreq, new String[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectFreq(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectFreq, new GlideString[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectIdletime(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectIdleTime, new String[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectIdletime(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectIdleTime, new GlideString[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectRefcount(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectRefCount, new String[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> objectRefcount(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ObjectRefCount, new GlideString[]{key}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<String> rename(@NonNull String key, @NonNull String newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Rename, new String[]{key, newKey}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> rename(@NonNull GlideString key, @NonNull GlideString newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Rename, new GlideString[]{key, newKey}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Boolean> renamenx(@NonNull String key, @NonNull String newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RenameNX, new String[]{key, newKey}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> renamenx(@NonNull GlideString key, @NonNull GlideString newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RenameNX, new GlideString[]{key, newKey}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> incr(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Incr, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> incr(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Incr, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> incrBy(@NonNull String key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.IncrBy, new String[]{key, Long.toString(amount)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> incrBy(@NonNull GlideString key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.IncrBy, new GlideString[]{key, GlideString.gs(Long.toString(amount))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Double> incrByFloat(@NonNull String key, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.IncrByFloat, new String[]{key, Double.toString(amount)}, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Double> incrByFloat(@NonNull GlideString key, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.IncrByFloat, new GlideString[]{key, GlideString.gs(Double.toString(amount))}, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Long> decr(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Decr, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> decr(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Decr, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> decrBy(@NonNull String key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.DecrBy, new String[]{key, Long.toString(amount)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> decrBy(@NonNull GlideString key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.DecrBy, new GlideString[]{key, GlideString.gs(Long.toString(amount))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> strlen(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Strlen, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> strlen(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Strlen, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> setrange(@NonNull String key, int offset, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Integer.toString(offset), value};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SetRange, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> setrange(@NonNull GlideString key, int offset, @NonNull GlideString value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Integer.toString(offset)), value};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SetRange, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> getrange(@NonNull String key, int start, int end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Integer.toString(start), Integer.toString(end)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetRange, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> getrange(@NonNull GlideString key, int start, int end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Integer.toString(start)), GlideString.gs(Integer.toString(end))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetRange, arguments, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<String> hget(@NonNull String key, @NonNull String field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGet, new String[]{key, field}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> hget(@NonNull GlideString key, @NonNull GlideString field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGet, new GlideString[]{key, field}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> hset(@NonNull String key, @NonNull Map<String, String> fieldValueMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        String[] args = ArrayUtils.addFirst(ArrayTransformUtils.convertMapToKeyValueStringArray(fieldValueMap), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSet, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hset(@NonNull GlideString key, @NonNull Map<GlideString, GlideString> fieldValueMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        GlideString[] args = ArrayUtils.addFirst(ArrayTransformUtils.convertMapToKeyValueGlideStringArray(fieldValueMap), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSet, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Boolean> hsetnx(@NonNull String key, @NonNull String field, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSetNX, new String[]{key, field, value}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> hsetnx(@NonNull GlideString key, @NonNull GlideString field, @NonNull GlideString value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSetNX, new GlideString[]{key, field, value}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> hsetex(@NonNull String key, @NonNull Map<String, String> fieldValueMap, HSetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, optionsArgs, {"FIELDS", String.valueOf(fieldValueMap.size())}, ArrayTransformUtils.convertMapToKeyValueStringArray(fieldValueMap));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSetEx, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hsetex(@NonNull GlideString key, @NonNull Map<GlideString, GlideString> fieldValueMap, HSetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fieldValueMap.size()).add(ArrayTransformUtils.convertMapToKeyValueGlideStringArray(fieldValueMap)).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HSetEx, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> hgetex(@NonNull String key, @NonNull String[] fields, HGetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, optionsArgs, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGetEx, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> hgetex(@NonNull GlideString key, @NonNull GlideString[] fields, HGetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGetEx, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpire(@NonNull String key, long seconds, @NonNull String[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, String.valueOf(seconds)}, optionsArgs, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpire, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpire(@NonNull GlideString key, long seconds, @NonNull GlideString[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key).add(seconds);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpire, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpersist(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPersist, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpersist(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPersist, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpire(@NonNull String key, long milliseconds, @NonNull String[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, String.valueOf(milliseconds)}, optionsArgs, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpire, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpire(@NonNull GlideString key, long milliseconds, @NonNull GlideString[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key).add(milliseconds);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpire, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpireat(@NonNull String key, long unixSeconds, @NonNull String[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, String.valueOf(unixSeconds)}, optionsArgs, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpireAt, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpireat(@NonNull GlideString key, long unixSeconds, @NonNull GlideString[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key).add(unixSeconds);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpireAt, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpireat(@NonNull String key, long unixMilliseconds, @NonNull String[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] optionsArgs = options != null ? options.toArgs() : new String[]{};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, String.valueOf(unixMilliseconds)}, optionsArgs, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpireAt, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpireat(@NonNull GlideString key, long unixMilliseconds, @NonNull GlideString[] fields, HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder argsBuilder = new ArgsBuilder().add(key).add(unixMilliseconds);
        if (options != null) {
            argsBuilder.add(options.toArgs());
        }
        GlideString[] arguments = argsBuilder.add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpireAt, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> httl(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HTtl, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> httl(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HTtl, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpttl(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPTtl, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpttl(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPTtl, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpiretime(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpireTime, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hexpiretime(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExpireTime, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpiretime(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"FIELDS", String.valueOf(fields.length)}, fields);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpireTime, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> hpexpiretime(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HPExpireTime, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long> hdel(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] args = ArrayUtils.addFirst(fields, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HDel, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hdel(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] args = ArrayUtils.addFirst(fields, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HDel, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hlen(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HLen, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hlen(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HLen, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> hvals(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HVals, new String[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> hvals(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HVals, new GlideString[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> hmget(@NonNull String key, @NonNull String[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(fields, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HMGet, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> hmget(@NonNull GlideString key, @NonNull GlideString[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(fields, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HMGet, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Boolean> hexists(@NonNull String key, @NonNull String field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExists, new String[]{key, field}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> hexists(@NonNull GlideString key, @NonNull GlideString field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HExists, new GlideString[]{key, field}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Map<String, String>> hgetall(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGetAll, new String[]{key}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString>> hgetall(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HGetAll, new GlideString[]{key}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Long> hincrBy(@NonNull String key, @NonNull String field, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HIncrBy, new String[]{key, field, Long.toString(amount)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hincrBy(@NonNull GlideString key, @NonNull GlideString field, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HIncrBy, new GlideString[]{key, field, GlideString.gs(Long.toString(amount))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Double> hincrByFloat(@NonNull String key, @NonNull String field, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HIncrByFloat, new String[]{key, field, Double.toString(amount)}, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Double> hincrByFloat(@NonNull GlideString key, @NonNull GlideString field, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HIncrByFloat, new GlideString[]{key, field, GlideString.gs(Double.toString(amount))}, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<String[]> hkeys(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HKeys, new String[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> hkeys(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HKeys, new GlideString[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> hstrlen(@NonNull String key, @NonNull String field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HStrlen, new String[]{key, field}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> hstrlen(@NonNull GlideString key, @NonNull GlideString field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HStrlen, new GlideString[]{key, field}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> hrandfield(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> hrandfield(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> hrandfieldWithCount(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new String[]{key, Long.toString(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> hrandfieldWithCount(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new GlideString[]{key, GlideString.of(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[][]> hrandfieldWithCountWithValues(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new String[]{key, Long.toString(count), "WITHVALUES"}, response -> ArrayTransformUtils.castArrayofArrays(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[][]> hrandfieldWithCountWithValues(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HRandField, new GlideString[]{key, GlideString.of(count), GlideString.of("WITHVALUES")}, response -> ArrayTransformUtils.castArrayofArrays(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> lpush(@NonNull String key, @NonNull String[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPush, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lpush(@NonNull GlideString key, @NonNull GlideString[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPush, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> lpop(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPop, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> lpop(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPop, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> lpopCount(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPop, new String[]{key, Long.toString(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> lpopCount(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPop, new GlideString[]{key, GlideString.gs(Long.toString(count))}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> lpos(@NonNull String key, @NonNull String element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, new String[]{key, element}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> lpos(@NonNull GlideString key, @NonNull GlideString element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, new GlideString[]{key, element}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> lpos(@NonNull String key, @NonNull String element, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, element}, options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, arguments, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> lpos(@NonNull GlideString key, @NonNull GlideString element, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(element).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, arguments, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long[]> lposCount(@NonNull String key, @NonNull String element, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, new String[]{key, element, "COUNT", Long.toString(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> lposCount(@NonNull GlideString key, @NonNull GlideString element, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, new GlideString[]{key, element, GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> lposCount(@NonNull String key, @NonNull String element, long count, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, element, "COUNT", Long.toString(count)}, options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> lposCount(@NonNull GlideString key, @NonNull GlideString element, long count, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(element).add("COUNT").add(count).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPos, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<String[]> lrange(@NonNull String key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LRange, new String[]{key, Long.toString(start), Long.toString(end)}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> lrange(@NonNull GlideString key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LRange, new GlideString[]{key, GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end))}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String> lindex(@NonNull String key, long index) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LIndex, new String[]{key, Long.toString(index)}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> lindex(@NonNull GlideString key, long index) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LIndex, new GlideString[]{key, GlideString.gs(Long.toString(index))}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> ltrim(@NonNull String key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LTrim, new String[]{key, Long.toString(start), Long.toString(end)}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> ltrim(@NonNull GlideString key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LTrim, new GlideString[]{key, GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end))}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> llen(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LLen, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> llen(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LLen, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lrem(@NonNull String key, long count, @NonNull String element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LRem, new String[]{key, Long.toString(count), element}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lrem(@NonNull GlideString key, long count, @NonNull GlideString element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LRem, new GlideString[]{key, GlideString.gs(Long.toString(count)), element}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> rpush(@NonNull String key, @NonNull String[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPush, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> rpush(@NonNull GlideString key, @NonNull GlideString[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPush, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> rpop(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPop, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> rpop(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPop, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> rpopCount(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPop, new String[]{key, Long.toString(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> rpopCount(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPop, new GlideString[]{key, GlideString.gs(Long.toString(count))}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> sadd(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sadd(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Boolean> sismember(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SIsMember, new String[]{key, member}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> sismember(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SIsMember, new GlideString[]{key, member}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> srem(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRem, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> srem(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRem, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Set<String>> smembers(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMembers, new String[]{key}, this::handleSetResponse);
    }

    @Override
    public CompletableFuture<Set<GlideString>> smembers(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMembers, new GlideString[]{key}, this::handleSetBinaryResponse);
    }

    @Override
    public CompletableFuture<Long> scard(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SCard, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> scard(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SCard, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Set<String>> sdiff(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SDiff, keys, this::handleSetResponse);
    }

    @Override
    public CompletableFuture<Set<GlideString>> sdiff(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SDiff, keys, this::handleSetBinaryResponse);
    }

    @Override
    public CompletableFuture<Boolean[]> smismember(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMIsMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Boolean[]> smismember(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMIsMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Boolean.class));
    }

    @Override
    public CompletableFuture<Long> sdiffstore(@NonNull String destination, @NonNull String[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SDiffStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sdiffstore(@NonNull GlideString destination, @NonNull GlideString[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SDiffStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Boolean> smove(@NonNull String source, @NonNull String destination, @NonNull String member) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMove, new String[]{source, destination, member}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> smove(@NonNull GlideString source, @NonNull GlideString destination, @NonNull GlideString member) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SMove, new GlideString[]{source, destination, member}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> sinterstore(@NonNull String destination, @NonNull String[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sinterstore(@NonNull GlideString destination, @NonNull GlideString[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Set<String>> sinter(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInter, keys, this::handleSetResponse);
    }

    @Override
    public CompletableFuture<Set<GlideString>> sinter(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInter, keys, this::handleSetBinaryResponse);
    }

    @Override
    public CompletableFuture<Long> sunionstore(@NonNull String destination, @NonNull String[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sunionstore(@NonNull GlideString destination, @NonNull GlideString[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(keys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> exists(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Exists, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> exists(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Exists, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> unlink(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Unlink, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> unlink(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Unlink, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Boolean> expire(@NonNull String key, long seconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Expire, new String[]{key, Long.toString(seconds)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expire(@NonNull GlideString key, long seconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Expire, new GlideString[]{key, GlideString.gs(Long.toString(seconds))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expire(@NonNull String key, long seconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{key, Long.toString(seconds)}, expireOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Expire, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expire(@NonNull GlideString key, long seconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(seconds).add(expireOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Expire, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expireAt(@NonNull String key, long unixSeconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireAt, new String[]{key, Long.toString(unixSeconds)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expireAt(@NonNull GlideString key, long unixSeconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireAt, new GlideString[]{key, GlideString.gs(Long.toString(unixSeconds))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expireAt(@NonNull String key, long unixSeconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{key, Long.toString(unixSeconds)}, expireOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireAt, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> expireAt(@NonNull GlideString key, long unixSeconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(unixSeconds).add(expireOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireAt, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpire(@NonNull String key, long milliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpire, new String[]{key, Long.toString(milliseconds)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpire(@NonNull GlideString key, long milliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpire, new GlideString[]{key, GlideString.gs(Long.toString(milliseconds))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpire(@NonNull String key, long milliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{key, Long.toString(milliseconds)}, expireOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpire, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpire(@NonNull GlideString key, long milliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(milliseconds).add(expireOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpire, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpireAt(@NonNull String key, long unixMilliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireAt, new String[]{key, Long.toString(unixMilliseconds)}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpireAt(@NonNull GlideString key, long unixMilliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireAt, new GlideString[]{key, GlideString.gs(Long.toString(unixMilliseconds))}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpireAt(@NonNull String key, long unixMilliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{key, Long.toString(unixMilliseconds)}, expireOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireAt, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pexpireAt(@NonNull GlideString key, long unixMilliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(unixMilliseconds).add(expireOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireAt, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> ttl(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.TTL, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> ttl(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.TTL, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> expiretime(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireTime, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> expiretime(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ExpireTime, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> pexpiretime(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireTime, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> pexpiretime(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PExpireTime, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (script.getBinaryOutput().booleanValue()) {
            return this.commandManager.submitScript(script, List.of(), List.of(), this::handleBinaryObjectOrNullResponse);
        }
        return this.commandManager.submitScript(script, List.of(), List.of(), this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script, @NonNull ScriptOptions options) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (script.getBinaryOutput().booleanValue()) {
            return this.commandManager.submitScript(script, options.getKeys().stream().map(GlideString::gs).collect(Collectors.toList()), options.getArgs().stream().map(GlideString::gs).collect(Collectors.toList()), this::handleBinaryObjectOrNullResponse);
        }
        return this.commandManager.submitScript(script, options.getKeys().stream().map(GlideString::gs).collect(Collectors.toList()), options.getArgs().stream().map(GlideString::gs).collect(Collectors.toList()), this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> invokeScript(@NonNull Script script, @NonNull ScriptOptionsGlideString options) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (script.getBinaryOutput().booleanValue()) {
            return this.commandManager.submitScript(script, options.getKeys(), options.getArgs(), this::handleBinaryObjectOrNullResponse);
        }
        return this.commandManager.submitScript(script, options.getKeys(), options.getArgs(), this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<String> scriptShow(@NonNull String sha1) {
        if (sha1 == null) {
            throw new NullPointerException("sha1 is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptShow, new String[]{sha1}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> scriptShow(@NonNull GlideString sha1) {
        if (sha1 == null) {
            throw new NullPointerException("sha1 is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ScriptShow, new GlideString[]{sha1}, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull String key, @NonNull Map<String, Double> membersScoresMap, @NonNull ZAddOptions options, boolean changed) {
        String[] stringArray;
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (changed) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "CH";
        } else {
            stringArray = new String[]{};
        }
        String[] changedArg = stringArray;
        String[] membersScores = ArrayTransformUtils.convertMapToValueKeyStringArray(membersScoresMap);
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, options.toArgs(), changedArg, membersScores);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull GlideString key, @NonNull Map<GlideString, Double> membersScoresMap, @NonNull ZAddOptions options, boolean changed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).addIf("CH", changed).add(ArrayTransformUtils.convertMapToValueKeyStringArrayBinary(membersScoresMap)).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull String key, @NonNull Map<String, Double> membersScoresMap, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, options, false);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull GlideString key, @NonNull Map<GlideString, Double> membersScoresMap, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, options, false);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull String key, @NonNull Map<String, Double> membersScoresMap, boolean changed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), changed);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull GlideString key, @NonNull Map<GlideString, Double> membersScoresMap, boolean changed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), changed);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull String key, @NonNull Map<String, Double> membersScoresMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), false);
    }

    @Override
    public CompletableFuture<Long> zadd(@NonNull GlideString key, @NonNull Map<GlideString, Double> membersScoresMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), false);
    }

    @Override
    public CompletableFuture<Double> zaddIncr(@NonNull String key, @NonNull String member, double increment, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, options.toArgs(), {"INCR", Double.toString(increment), member});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> zaddIncr(@NonNull GlideString key, @NonNull GlideString member, double increment, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key}, options.toArgsBinary(), {GlideString.gs("INCR"), GlideString.gs(Double.toString(increment)), member});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> zaddIncr(@NonNull String key, @NonNull String member, double increment) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, {"INCR", Double.toString(increment), member});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Double> zaddIncr(@NonNull GlideString key, @NonNull GlideString member, double increment) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key}, {GlideString.gs("INCR"), GlideString.gs(Double.toString(increment)), member});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZAdd, arguments, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Long> zrem(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRem, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zrem(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRem, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zcard(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZCard, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zcard(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZCard, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zpopmin(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMin, new String[]{key, Long.toString(count)}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zpopmin(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMin, new GlideString[]{key, GlideString.gs(Long.toString(count))}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zpopmin(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMin, new String[]{key}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zpopmin(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMin, new GlideString[]{key}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Object[]> bzpopmin(@NonNull String[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.add(keys, Double.toString(timeout));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZPopMin, arguments, this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> bzpopmin(@NonNull GlideString[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.add(keys, GlideString.gs(Double.toString(timeout)));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZPopMin, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zpopmax(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMax, new String[]{key, Long.toString(count)}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zpopmax(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMax, new GlideString[]{key, GlideString.gs(Long.toString(count))}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zpopmax(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMax, new String[]{key}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zpopmax(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZPopMax, new GlideString[]{key}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Object[]> bzpopmax(@NonNull String[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.add(keys, Double.toString(timeout));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZPopMax, arguments, this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> bzpopmax(@NonNull GlideString[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.add(keys, GlideString.gs(Double.toString(timeout)));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZPopMax, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Double> zscore(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScore, new String[]{key, member}, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> zscore(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScore, new GlideString[]{key, member}, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> zrank(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRank, new String[]{key, member}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> zrank(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRank, new GlideString[]{key, member}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> zrankWithScore(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRank, new String[]{key, member, "WITHSCORE"}, this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> zrankWithScore(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRank, new GlideString[]{key, member, GlideString.gs("WITHSCORE")}, this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> zrevrank(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRevRank, new String[]{key, member}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Long> zrevrank(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRevRank, new GlideString[]{key, member}, this::handleLongOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> zrevrankWithScore(@NonNull String key, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRevRank, new String[]{key, member, "WITHSCORE"}, this::handleArrayOrNullResponse);
    }

    @Override
    public CompletableFuture<Object[]> zrevrankWithScore(@NonNull GlideString key, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRevRank, new GlideString[]{key, member, GlideString.gs("WITHSCORE")}, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Double[]> zmscore(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMScore, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Double[]> zmscore(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(members, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMScore, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<String[]> zdiff(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, Long.toString(keys.length));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiff, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> zdiff(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keys.length).add(keys).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiff, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, Double>> zdiffWithScores(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, Long.toString(keys.length));
        arguments = ArrayUtils.add(arguments, "WITHSCORES");
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiff, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zdiffWithScores(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keys.length).add(keys).toArray();
        arguments = ArrayUtils.add(arguments, GlideString.gs("WITHSCORES"));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiff, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Long> zdiffstore(@NonNull String destination, @NonNull String[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(new String[]{destination, Long.toString(keys.length)}, keys);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiffStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zdiffstore(@NonNull GlideString destination, @NonNull GlideString[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addAll(new GlideString[]{destination, GlideString.gs(Long.toString(keys.length))}, keys);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZDiffStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zcount(@NonNull String key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZCount, new String[]{key, minScore.toArgs(), maxScore.toArgs()}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zcount(@NonNull GlideString key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZCount, new ArgsBuilder().add(key).add(minScore.toArgs()).add(maxScore.toArgs()).toArray(), this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebyrank(@NonNull String key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByRank, new String[]{key, Long.toString(start), Long.toString(end)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebyrank(@NonNull GlideString key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByRank, new GlideString[]{key, GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebylex(@NonNull String key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByLex, new String[]{key, minLex.toArgs(), maxLex.toArgs()}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebylex(@NonNull GlideString key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByLex, new ArgsBuilder().add(key).add(minLex.toArgs()).add(maxLex.toArgs()).toArray(), this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebyscore(@NonNull String key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByScore, new String[]{key, minScore.toArgs(), maxScore.toArgs()}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zremrangebyscore(@NonNull GlideString key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRemRangeByScore, new ArgsBuilder().add(key).add(minScore.toArgs()).add(maxScore.toArgs()).toArray(), this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zlexcount(@NonNull String key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZLexCount, new String[]{key, minLex.toArgs(), maxLex.toArgs()}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zlexcount(@NonNull GlideString key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZLexCount, new ArgsBuilder().add(key).add(minLex.toArgs()).add(maxLex.toArgs()).toArray(), this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zrangestore(@NonNull String destination, @NonNull String source, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        String[] arguments = RangeOptions.createZRangeStoreArgs(destination, source, rangeQuery, reverse);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRangeStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zrangestore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        GlideString[] arguments = RangeOptions.createZRangeStoreArgsBinary(destination, source, rangeQuery, reverse);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRangeStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zrangestore(@NonNull String destination, @NonNull String source, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrangestore(destination, source, rangeQuery, false);
    }

    @Override
    public CompletableFuture<Long> zrangestore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrangestore(destination, source, rangeQuery, false);
    }

    @Override
    public CompletableFuture<Long> zunionstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination}, keysOrWeightedKeys.toArgs(), aggregate.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zunionstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zunionstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination}, keysOrWeightedKeys.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zunionstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnionStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zinterstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination}, keysOrWeightedKeys.toArgs(), aggregate.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zinterstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zinterstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination}, keysOrWeightedKeys.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zinterstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({destination}, keysOrWeightedKeys.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> zunion(@NonNull WeightAggregateOptions.KeyArray keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, keys.toArgs(), response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> zunion(@NonNull WeightAggregateOptions.KeyArrayBinary keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, keys.toArgs(), response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, Double>> zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays(keysOrWeightedKeys.toArgs(), aggregate.toArgs(), {"WITHSCORES"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays(keysOrWeightedKeys.toArgs(), {"WITHSCORES"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keysOrWeightedKeys.toArgs()).add("WITHSCORES").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZUnion, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<String[]> zinter(@NonNull WeightAggregateOptions.KeyArray keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, keys.toArgs(), response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> zinter(@NonNull WeightAggregateOptions.KeyArrayBinary keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, keys.toArgs(), response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, Double>> zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays(keysOrWeightedKeys.toArgs(), aggregate.toArgs(), {"WITHSCORES"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays(keysOrWeightedKeys.toArgs(), {"WITHSCORES"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays(keysOrWeightedKeys.toArgs(), {GlideString.gs("WITHSCORES")});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInter, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<String> zrandmember(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, new String[]{key}, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> zrandmember(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, new GlideString[]{key}, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> zrandmemberWithCount(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, new String[]{key, Long.toString(count)}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> zrandmemberWithCount(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, new GlideString[]{key, GlideString.gs(Long.toString(count))}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Object[][]> zrandmemberWithCountWithScores(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(count), "WITHSCORES"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Object[].class));
    }

    @Override
    public CompletableFuture<Object[][]> zrandmemberWithCountWithScores(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(count)), GlideString.gs("WITHSCORES")};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRandMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), Object[].class));
    }

    @Override
    public CompletableFuture<Double> zincrby(@NonNull String key, double increment, @NonNull String member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Double.toString(increment), member};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZIncrBy, arguments, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Double> zincrby(@NonNull GlideString key, double increment, @NonNull GlideString member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Double.toString(increment)), member};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZIncrBy, arguments, this::handleDoubleResponse);
    }

    @Override
    public CompletableFuture<Long> zintercard(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, Integer.toString(keys.length));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zintercard(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(keys, GlideString.gs(Integer.toString(keys.length)));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zintercard(@NonNull String[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Integer.toString(keys.length)}, keys, {"LIMIT", Long.toString(limit)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> zintercard(@NonNull GlideString[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Integer.toString(keys.length))}, keys, {GlideString.gs("LIMIT"), GlideString.gs(Long.toString(limit))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> xadd(@NonNull String key, @NonNull Map<String, String> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptions.builder().build());
    }

    @Override
    public CompletableFuture<String> xadd(@NonNull String key, @NonNull String[][] values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptions.builder().build());
    }

    @Override
    public CompletableFuture<GlideString> xadd(@NonNull GlideString key, @NonNull Map<GlideString, GlideString> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptionsBinary.builder().build());
    }

    @Override
    public CompletableFuture<GlideString> xadd(@NonNull GlideString key, @NonNull GlideString[][] values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptionsBinary.builder().build());
    }

    @Override
    public CompletableFuture<String> xadd(@NonNull String key, @NonNull Map<String, String> values, @NonNull StreamAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(ArrayUtils.addFirst(options.toArgs(), key), ArrayTransformUtils.convertMapToKeyValueStringArray(values));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAdd, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> xadd(@NonNull String key, @NonNull String[][] values, @NonNull StreamAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addAll(ArrayUtils.addFirst(options.toArgs(), key), ArrayTransformUtils.convertNestedArrayToKeyValueStringArray(values));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAdd, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> xadd(@NonNull GlideString key, @NonNull Map<GlideString, GlideString> values, @NonNull StreamAddOptionsBinary options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.convertMapToKeyValueGlideStringArray(values)).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAdd, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> xadd(@NonNull GlideString key, @NonNull GlideString[][] values, @NonNull StreamAddOptionsBinary options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.convertNestedArrayToKeyValueGlideStringArray(values)).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAdd, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Map<String, Map<String, String[][]>>> xread(@NonNull Map<String, String> keysAndIds) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        return this.xread(keysAndIds, (StreamReadOptions)StreamReadOptions.builder().build());
    }

    @Override
    public CompletableFuture<Map<GlideString, Map<GlideString, GlideString[][]>>> xreadBinary(@NonNull Map<GlideString, GlideString> keysAndIds) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        return this.xreadBinary(keysAndIds, (StreamReadOptions)StreamReadOptions.builder().build());
    }

    @Override
    public CompletableFuture<Map<String, Map<String, String[][]>>> xread(@NonNull Map<String, String> keysAndIds, @NonNull StreamReadOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = options.toArgs(keysAndIds);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRead, arguments, this::handleXReadResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Map<GlideString, GlideString[][]>>> xreadBinary(@NonNull Map<GlideString, GlideString> keysAndIds, @NonNull StreamReadOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = options.toArgsBinary(keysAndIds);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRead, arguments, this::handleXReadResponseBinary);
    }

    @Override
    public CompletableFuture<Long> xtrim(@NonNull String key, @NonNull StreamTrimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(options.toArgs(), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XTrim, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xtrim(@NonNull GlideString key, @NonNull StreamTrimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XTrim, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xlen(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XLen, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xlen(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XLen, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xdel(@NonNull String key, @NonNull String[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(ids, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XDel, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xdel(@NonNull GlideString key, @NonNull GlideString[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(ids, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XDel, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xrange(@NonNull String key, @NonNull StreamRange start, @NonNull StreamRange end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(StreamRange.toArgs(start, end), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleMapResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xrange(@NonNull GlideString key, @NonNull StreamRange start, @NonNull StreamRange end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        String[] toArgsString = StreamRange.toArgs(start, end);
        GlideString[] toArgsBinary = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] arguments = ArrayUtils.addFirst(toArgsBinary, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xrange(@NonNull String key, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(StreamRange.toArgs(start, end, count), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xrange(@NonNull GlideString key, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        String[] toArgsString = StreamRange.toArgs(start, end, count);
        GlideString[] toArgsBinary = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] arguments = ArrayUtils.addFirst(toArgsBinary, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xrevrange(@NonNull String key, @NonNull StreamRange end, @NonNull StreamRange start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(StreamRange.toArgs(end, start), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRevRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleMapResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xrevrange(@NonNull GlideString key, @NonNull StreamRange end, @NonNull StreamRange start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] toArgsString = StreamRange.toArgs(end, start);
        GlideString[] toArgsBinary = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] arguments = ArrayUtils.addFirst(toArgsBinary, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRevRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xrevrange(@NonNull String key, @NonNull StreamRange end, @NonNull StreamRange start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(StreamRange.toArgs(end, start, count), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRevRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xrevrange(@NonNull GlideString key, @NonNull StreamRange end, @NonNull StreamRange start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] toArgsString = StreamRange.toArgs(end, start, count);
        GlideString[] toArgsBinary = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] arguments = ArrayUtils.addFirst(toArgsBinary, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XRevRange, arguments, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String> xgroupCreate(@NonNull String key, @NonNull String groupName, @NonNull String id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreate, new String[]{key, groupName, id}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupCreate(@NonNull GlideString key, @NonNull GlideString groupName, @NonNull GlideString id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreate, new GlideString[]{key, groupName, id}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupCreate(@NonNull String key, @NonNull String groupName, @NonNull String id, @NonNull StreamGroupOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, groupName, id}, options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreate, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupCreate(@NonNull GlideString key, @NonNull GlideString groupName, @NonNull GlideString id, @NonNull StreamGroupOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(groupName).add(id).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreate, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Boolean> xgroupDestroy(@NonNull String key, @NonNull String groupname) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupname == null) {
            throw new NullPointerException("groupname is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupDestroy, new String[]{key, groupname}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> xgroupDestroy(@NonNull GlideString key, @NonNull GlideString groupname) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupname == null) {
            throw new NullPointerException("groupname is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupDestroy, new GlideString[]{key, groupname}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> xgroupCreateConsumer(@NonNull String key, @NonNull String group, @NonNull String consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreateConsumer, new String[]{key, group, consumer}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> xgroupCreateConsumer(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupCreateConsumer, new GlideString[]{key, group, consumer}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> xgroupDelConsumer(@NonNull String key, @NonNull String group, @NonNull String consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupDelConsumer, new String[]{key, group, consumer}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xgroupDelConsumer(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupDelConsumer, new GlideString[]{key, group, consumer}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> xgroupSetId(@NonNull String key, @NonNull String groupName, @NonNull String id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupSetId, new String[]{key, groupName, id}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupSetId(@NonNull GlideString key, @NonNull GlideString groupName, @NonNull GlideString id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupSetId, new GlideString[]{key, groupName, id}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupSetId(@NonNull String key, @NonNull String groupName, @NonNull String id, long entriesRead) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        String[] arguments = new String[]{key, groupName, id, "ENTRIESREAD", Long.toString(entriesRead)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupSetId, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> xgroupSetId(@NonNull GlideString key, @NonNull GlideString groupName, @NonNull GlideString id, long entriesRead) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(groupName).add(id).add("ENTRIESREAD").add(entriesRead).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XGroupSetId, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Map<String, Map<String, String[][]>>> xreadgroup(@NonNull Map<String, String> keysAndIds, @NonNull String group, @NonNull String consumer) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.xreadgroup(keysAndIds, group, consumer, (StreamReadGroupOptions)StreamReadGroupOptions.builder().build());
    }

    @Override
    public CompletableFuture<Map<GlideString, Map<GlideString, GlideString[][]>>> xreadgroup(@NonNull Map<GlideString, GlideString> keysAndIds, @NonNull GlideString group, @NonNull GlideString consumer) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.xreadgroup(keysAndIds, group, consumer, (StreamReadGroupOptions)StreamReadGroupOptions.builder().build());
    }

    @Override
    public CompletableFuture<Map<String, Map<String, String[][]>>> xreadgroup(@NonNull Map<String, String> keysAndIds, @NonNull String group, @NonNull String consumer, @NonNull StreamReadGroupOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = options.toArgs(group, consumer, keysAndIds);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XReadGroup, arguments, this::handleXReadResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Map<GlideString, GlideString[][]>>> xreadgroup(@NonNull Map<GlideString, GlideString> keysAndIds, @NonNull GlideString group, @NonNull GlideString consumer, @NonNull StreamReadGroupOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = options.toArgsBinary(group, consumer, keysAndIds);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XReadGroup, arguments, this::handleXReadResponseBinary);
    }

    @Override
    public CompletableFuture<Long> xack(@NonNull String key, @NonNull String group, @NonNull String[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group}, ids);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAck, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> xack(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group}, ids);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAck, args, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Object[]> xpending(@NonNull String key, @NonNull String group) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XPending, new String[]{key, group}, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> xpending(@NonNull GlideString key, @NonNull GlideString group) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XPending, new GlideString[]{key, group}, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Object[][]> xpending(@NonNull String key, @NonNull String group, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return this.xpending(key, group, start, end, count, StreamPendingOptions.builder().build());
    }

    @Override
    public CompletableFuture<Object[][]> xpending(@NonNull GlideString key, @NonNull GlideString group, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return this.xpending(key, group, start, end, count, StreamPendingOptionsBinary.builder().build());
    }

    @Override
    public CompletableFuture<Object[][]> xpending(@NonNull String key, @NonNull String group, @NonNull StreamRange start, @NonNull StreamRange end, long count, @NonNull StreamPendingOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group}, options.toArgs(start, end, count));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XPending, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Object[].class));
    }

    @Override
    public CompletableFuture<Object[][]> xpending(@NonNull GlideString key, @NonNull GlideString group, @NonNull StreamRange start, @NonNull StreamRange end, long count, @NonNull StreamPendingOptionsBinary options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group}, options.toArgs(start, end, count));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XPending, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), Object[].class));
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xclaim(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, Long.toString(minIdleTime)}, ids);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xclaim(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, GlideString.gs(Long.toString(minIdleTime))}, ids);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[][]>> xclaim(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, Long.toString(minIdleTime)}, ids, options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[][]>> xclaim(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] toArgsString = options.toArgs();
        GlideString[] toArgs = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, GlideString.gs(Long.toString(minIdleTime))}, ids, toArgs);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castMapOf2DArray(this.handleBinaryStringMapResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> xclaimJustId(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, Long.toString(minIdleTime)}, ids, {"JUSTID"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> xclaimJustId(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, GlideString.gs(Long.toString(minIdleTime))}, ids, {GlideString.gs("JUSTID")});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> xclaimJustId(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, Long.toString(minIdleTime)}, ids, options.toArgs(), {"JUSTID"});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> xclaimJustId(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] toArgsString = options.toArgs();
        GlideString[] toArgs = (GlideString[])Arrays.stream(toArgsString).map(GlideString::gs).toArray(GlideString[]::new);
        GlideString[] args = ArrayTransformUtils.concatenateArrays({key, group, consumer, GlideString.gs(Long.toString(minIdleTime))}, ids, toArgs, {GlideString.gs("JUSTID")});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XClaim, args, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> xinfoGroups(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoGroups, new String[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Map.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> xinfoGroups(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoGroups, new GlideString[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), Map.class));
    }

    @Override
    public CompletableFuture<Map<String, Object>[]> xinfoConsumers(@NonNull String key, @NonNull String groupName) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoConsumers, new String[]{key, groupName}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Map.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>[]> xinfoConsumers(@NonNull GlideString key, @NonNull GlideString groupName) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoConsumers, new GlideString[]{key, groupName}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), Map.class));
    }

    @Override
    public CompletableFuture<Object[]> xautoclaim(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] args = new String[]{key, group, consumer, Long.toString(minIdleTime), start};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaim(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{key, group, consumer, GlideString.gs(Long.toString(minIdleTime)), start};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaim(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] args = new String[]{key, group, consumer, Long.toString(minIdleTime), start, "COUNT", Long.toString(count)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaim(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{key, group, consumer, GlideString.gs(Long.toString(minIdleTime)), start, GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaimJustId(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] args = new String[]{key, group, consumer, Long.toString(minIdleTime), start, "JUSTID"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaimJustId(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{key, group, consumer, GlideString.gs(Long.toString(minIdleTime)), start, GlideString.gs("JUSTID")};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaimJustId(@NonNull String key, @NonNull String group, @NonNull String consumer, long minIdleTime, @NonNull String start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        String[] args = new String[]{key, group, consumer, Long.toString(minIdleTime), start, "COUNT", Long.toString(count), "JUSTID"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> xautoclaimJustId(@NonNull GlideString key, @NonNull GlideString group, @NonNull GlideString consumer, long minIdleTime, @NonNull GlideString start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        GlideString[] args = new GlideString[]{key, group, consumer, GlideString.gs(Long.toString(minIdleTime)), start, GlideString.gs("COUNT"), GlideString.gs(Long.toString(count)), GlideString.gs("JUSTID")};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XAutoClaim, args, this::handleArrayResponseBinary);
    }

    @Override
    public CompletableFuture<Map<String, Object>> xinfoStream(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new String[]{key}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>> xinfoStreamFull(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new String[]{key, "FULL"}, response -> this.handleMapResponse((ResponseOuterClass.Response)response));
    }

    @Override
    public CompletableFuture<Map<String, Object>> xinfoStreamFull(@NonNull String key, int count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new String[]{key, "FULL", "COUNT", Integer.toString(count)}, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> xinfoStream(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new GlideString[]{key}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> xinfoStreamFull(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new GlideString[]{key, GlideString.gs("FULL")}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> xinfoStreamFull(@NonNull GlideString key, int count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.XInfoStream, new GlideString[]{key, GlideString.gs("FULL"), GlideString.gs("COUNT"), GlideString.gs(Integer.toString(count))}, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Long> pttl(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PTTL, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> pttl(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PTTL, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Boolean> persist(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Persist, new String[]{key}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> persist(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Persist, new GlideString[]{key}, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<String> type(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Type, new String[]{key}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> type(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Type, new GlideString[]{key}, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> linsert(@NonNull String key, @NonNull LInsertOptions.InsertPosition position, @NonNull String pivot, @NonNull String element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (pivot == null) {
            throw new NullPointerException("pivot is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LInsert, new String[]{key, position.toString(), pivot, element}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> linsert(@NonNull GlideString key, @NonNull LInsertOptions.InsertPosition position, @NonNull GlideString pivot, @NonNull GlideString element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (pivot == null) {
            throw new NullPointerException("pivot is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LInsert, new GlideString[]{key, GlideString.gs(position.toString()), pivot, element}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> blpop(@NonNull String[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.add(keys, Double.toString(timeout));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLPop, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> blpop(@NonNull GlideString[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.add(keys, GlideString.gs(Double.toString(timeout)));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLPop, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> brpop(@NonNull String[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.add(keys, Double.toString(timeout));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BRPop, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> brpop(@NonNull GlideString[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.add(keys, GlideString.gs(Double.toString(timeout)));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BRPop, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> rpushx(@NonNull String key, @NonNull String[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPushX, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> rpushx(@NonNull GlideString key, @NonNull GlideString[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.RPushX, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lpushx(@NonNull String key, @NonNull String[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPushX, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lpushx(@NonNull GlideString key, @NonNull GlideString[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LPushX, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> zrange(@NonNull String key, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        String[] arguments = RangeOptions.createZRangeArgs(key, rangeQuery, reverse, false);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRange, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> zrange(@NonNull GlideString key, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        GlideString[] arguments = RangeOptions.createZRangeArgsBinary(key, rangeQuery, reverse, false);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRange, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> zrange(@NonNull String key, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrange(key, rangeQuery, false);
    }

    @Override
    public CompletableFuture<GlideString[]> zrange(@NonNull GlideString key, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrange(key, rangeQuery, false);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zrangeWithScores(@NonNull String key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        String[] arguments = RangeOptions.createZRangeArgs(key, rangeQuery, reverse, true);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRange, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zrangeWithScores(@NonNull GlideString key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        GlideString[] arguments = RangeOptions.createZRangeArgsBinary(key, rangeQuery, reverse, true);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZRange, arguments, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Double>> zrangeWithScores(@NonNull String key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrangeWithScores(key, rangeQuery, false);
    }

    @Override
    public CompletableFuture<Map<GlideString, Double>> zrangeWithScores(@NonNull GlideString key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrangeWithScores(key, rangeQuery, false);
    }

    @Override
    public CompletableFuture<Map<String, Object>> zmpop(@NonNull String[] keys, @NonNull ScoreFilter modifier) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Integer.toString(keys.length)}, keys, {modifier.toString()});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMPop, arguments, response -> ArrayTransformUtils.convertKeyValueArrayToMap(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> zmpop(@NonNull GlideString[] keys, @NonNull ScoreFilter modifier) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Integer.toString(keys.length))}, keys, {GlideString.gs(modifier.toString())});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMPop, arguments, response -> ArrayTransformUtils.convertBinaryStringKeyValueArrayToMap(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<String, Object>> zmpop(@NonNull String[] keys, @NonNull ScoreFilter modifier, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Integer.toString(keys.length)}, keys, {modifier.toString(), "COUNT", Long.toString(count)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMPop, arguments, response -> ArrayTransformUtils.convertKeyValueArrayToMap(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> zmpop(@NonNull GlideString[] keys, @NonNull ScoreFilter modifier, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Integer.toString(keys.length))}, keys, {GlideString.gs(modifier.toString()), GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZMPop, arguments, response -> ArrayTransformUtils.convertBinaryStringKeyValueArrayToMap(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<String, Object>> bzmpop(@NonNull String[] keys, @NonNull ScoreFilter modifier, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Double.toString(timeout), Integer.toString(keys.length)}, keys, {modifier.toString()});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZMPop, arguments, response -> ArrayTransformUtils.convertKeyValueArrayToMap(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> bzmpop(@NonNull GlideString[] keys, @NonNull ScoreFilter modifier, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Double.toString(timeout)), GlideString.gs(Integer.toString(keys.length))}, keys, {GlideString.gs(modifier.toString())});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZMPop, arguments, response -> ArrayTransformUtils.convertBinaryStringKeyValueArrayToMap(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<String, Object>> bzmpop(@NonNull String[] keys, @NonNull ScoreFilter modifier, double timeout, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Double.toString(timeout), Integer.toString(keys.length)}, keys, {modifier.toString(), "COUNT", Long.toString(count)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZMPop, arguments, response -> ArrayTransformUtils.convertKeyValueArrayToMap(this.handleArrayOrNullResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, Object>> bzmpop(@NonNull GlideString[] keys, @NonNull ScoreFilter modifier, double timeout, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Double.toString(timeout)), GlideString.gs(Integer.toString(keys.length))}, keys, {GlideString.gs(modifier.toString()), GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BZMPop, arguments, response -> ArrayTransformUtils.convertBinaryStringKeyValueArrayToMap(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Boolean> pfadd(@NonNull String key, @NonNull String[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfAdd, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> pfadd(@NonNull GlideString key, @NonNull GlideString[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(elements, key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfAdd, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Long> pfcount(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfCount, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> pfcount(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfCount, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String> pfmerge(@NonNull String destination, @NonNull String[] sourceKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sourceKeys == null) {
            throw new NullPointerException("sourceKeys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(sourceKeys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfMerge, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> pfmerge(@NonNull GlideString destination, @NonNull GlideString[] sourceKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sourceKeys == null) {
            throw new NullPointerException("sourceKeys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(sourceKeys, destination);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PfMerge, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Long> touch(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Touch, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> touch(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Touch, keys, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geoadd(@NonNull String key, @NonNull Map<String, GeospatialData> membersToGeospatialData, @NonNull GeoAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, options.toArgs(), ArrayTransformUtils.mapGeoDataToArray(membersToGeospatialData));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geoadd(@NonNull GlideString key, @NonNull Map<GlideString, GeospatialData> membersToGeospatialData, @NonNull GeoAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.mapGeoDataToGlideStringArray(membersToGeospatialData)).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoAdd, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geoadd(@NonNull String key, @NonNull Map<String, GeospatialData> membersToGeospatialData) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        return this.geoadd(key, membersToGeospatialData, new GeoAddOptions(false));
    }

    @Override
    public CompletableFuture<Long> geoadd(@NonNull GlideString key, @NonNull Map<GlideString, GeospatialData> membersToGeospatialData) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        return this.geoadd(key, membersToGeospatialData, new GeoAddOptions(false));
    }

    @Override
    public CompletableFuture<Double[][]> geopos(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, members);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoPos, arguments, response -> ArrayTransformUtils.castArrayofArrays(this.handleArrayResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Double[][]> geopos(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key}, members);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoPos, arguments, response -> ArrayTransformUtils.castArrayofArrays(this.handleArrayResponse((ResponseOuterClass.Response)response), Double.class));
    }

    @Override
    public CompletableFuture<Double> geodist(@NonNull String key, @NonNull String member1, @NonNull String member2, @NonNull GeoUnit geoUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        if (geoUnit == null) {
            throw new NullPointerException("geoUnit is marked non-null but is null");
        }
        String[] arguments = new String[]{key, member1, member2, geoUnit.getValkeyAPI()};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoDist, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> geodist(@NonNull GlideString key, @NonNull GlideString member1, @NonNull GlideString member2, @NonNull GeoUnit geoUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        if (geoUnit == null) {
            throw new NullPointerException("geoUnit is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, member1, member2, GlideString.gs(geoUnit.getValkeyAPI())};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoDist, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> geodist(@NonNull String key, @NonNull String member1, @NonNull String member2) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key, member1, member2};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoDist, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<Double> geodist(@NonNull GlideString key, @NonNull GlideString member1, @NonNull GlideString member2) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, member1, member2};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoDist, arguments, this::handleDoubleOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> geohash(@NonNull String key, @NonNull String[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, members);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoHash, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> geohash(@NonNull GlideString key, @NonNull GlideString[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key}, members);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoHash, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new String[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new GlideString[]{key}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull String key, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new String[]{key, Long.toString(start)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull GlideString key, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new GlideString[]{key, GlideString.gs(Long.toString(start))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull String key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new String[]{key, Long.toString(start), Long.toString(end)}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull GlideString key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, new GlideString[]{key, GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end))}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull String key, long start, long end, @NonNull BitmapIndexType options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(start), Long.toString(end), options.toString()};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitcount(@NonNull GlideString key, long start, long end, @NonNull BitmapIndexType options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end)), GlideString.gs(options.toString())};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitCount, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> setbit(@NonNull String key, long offset, long value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(offset), Long.toString(value)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SetBit, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> setbit(@NonNull GlideString key, long offset, long value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(offset)), GlideString.gs(Long.toString(value))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SetBit, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> getbit(@NonNull String key, long offset) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(offset)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetBit, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> getbit(@NonNull GlideString key, long offset) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(offset))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GetBit, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull String key, long bit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(bit)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull GlideString key, long bit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(bit))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull String key, long bit, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(bit), Long.toString(start)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull GlideString key, long bit, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(bit)), GlideString.gs(Long.toString(start))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull String key, long bit, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(bit), Long.toString(start), Long.toString(end)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull GlideString key, long bit, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(bit)), GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull String key, long bit, long start, long end, @NonNull BitmapIndexType options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(bit), Long.toString(start), Long.toString(end), options.toString()};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitpos(@NonNull GlideString key, long bit, long start, long end, @NonNull BitmapIndexType options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(bit)), GlideString.gs(Long.toString(start)), GlideString.gs(Long.toString(end)), GlideString.gs(options.toString())};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitPos, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitop(@NonNull BitwiseOperation bitwiseOperation, @NonNull String destination, @NonNull String[] keys) {
        if (bitwiseOperation == null) {
            throw new NullPointerException("bitwiseOperation is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({bitwiseOperation.toString(), destination}, keys);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitOp, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> bitop(@NonNull BitwiseOperation bitwiseOperation, @NonNull GlideString destination, @NonNull GlideString[] keys) {
        if (bitwiseOperation == null) {
            throw new NullPointerException("bitwiseOperation is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(bitwiseOperation.toString()), destination}, keys);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitOp, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Map<String, String[]>> lmpop(@NonNull String[] keys, @NonNull ListDirection direction, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Long.toString(keys.length)}, keys, {direction.toString(), "COUNT", Long.toString(count)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMPop, arguments, response -> ArrayTransformUtils.castMapOfArrays(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[]>> lmpop(@NonNull GlideString[] keys, @NonNull ListDirection direction, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Long.toString(keys.length))}, keys, {GlideString.gs(direction.toString()), GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMPop, arguments, response -> ArrayTransformUtils.castBinaryStringMapOfArrays(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[]>> lmpop(@NonNull String[] keys, @NonNull ListDirection direction) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Long.toString(keys.length)}, keys, {direction.toString()});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMPop, arguments, response -> ArrayTransformUtils.castMapOfArrays(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[]>> lmpop(@NonNull GlideString[] keys, @NonNull ListDirection direction) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Long.toString(keys.length))}, keys, {GlideString.gs(direction.toString())});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMPop, arguments, response -> ArrayTransformUtils.castBinaryStringMapOfArrays(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[]>> blmpop(@NonNull String[] keys, @NonNull ListDirection direction, long count, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Double.toString(timeout), Long.toString(keys.length)}, keys, {direction.toString(), "COUNT", Long.toString(count)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMPop, arguments, response -> ArrayTransformUtils.castMapOfArrays(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[]>> blmpop(@NonNull GlideString[] keys, @NonNull ListDirection direction, long count, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Double.toString(timeout)), GlideString.gs(Long.toString(keys.length))}, keys, {GlideString.gs(direction.toString()), GlideString.gs("COUNT"), GlideString.gs(Long.toString(count))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMPop, arguments, response -> ArrayTransformUtils.castBinaryStringMapOfArrays(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Map<String, String[]>> blmpop(@NonNull String[] keys, @NonNull ListDirection direction, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Double.toString(timeout), Long.toString(keys.length)}, keys, {direction.toString()});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMPop, arguments, response -> ArrayTransformUtils.castMapOfArrays(this.handleMapOrNullResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<Map<GlideString, GlideString[]>> blmpop(@NonNull GlideString[] keys, @NonNull ListDirection direction, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Double.toString(timeout)), GlideString.gs(Long.toString(keys.length))}, keys, {GlideString.gs(direction.toString())});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMPop, arguments, response -> ArrayTransformUtils.castBinaryStringMapOfArrays(this.handleBinaryStringMapOrNullResponse((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String> lset(@NonNull String key, long index, @NonNull String element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(index), element};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LSet, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lset(@NonNull GlideString key, long index, @NonNull GlideString element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(index)), element};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LSet, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> lmove(@NonNull String source, @NonNull String destination, @NonNull ListDirection wherefrom, @NonNull ListDirection whereto) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (wherefrom == null) {
            throw new NullPointerException("wherefrom is marked non-null but is null");
        }
        if (whereto == null) {
            throw new NullPointerException("whereto is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination, wherefrom.toString(), whereto.toString()};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMove, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> lmove(@NonNull GlideString source, @NonNull GlideString destination, @NonNull ListDirection wherefrom, @NonNull ListDirection whereto) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (wherefrom == null) {
            throw new NullPointerException("wherefrom is marked non-null but is null");
        }
        if (whereto == null) {
            throw new NullPointerException("whereto is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination, GlideString.gs(wherefrom.toString()), GlideString.gs(whereto.toString())};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LMove, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> blmove(@NonNull String source, @NonNull String destination, @NonNull ListDirection wherefrom, @NonNull ListDirection whereto, double timeout) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (wherefrom == null) {
            throw new NullPointerException("wherefrom is marked non-null but is null");
        }
        if (whereto == null) {
            throw new NullPointerException("whereto is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination, wherefrom.toString(), whereto.toString(), Double.toString(timeout)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMove, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> blmove(@NonNull GlideString source, @NonNull GlideString destination, @NonNull ListDirection wherefrom, @NonNull ListDirection whereto, double timeout) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (wherefrom == null) {
            throw new NullPointerException("wherefrom is marked non-null but is null");
        }
        if (whereto == null) {
            throw new NullPointerException("whereto is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination, GlideString.gs(wherefrom.toString()), GlideString.gs(whereto.toString()), GlideString.gs(Double.toString(timeout))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BLMove, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String> srandmember(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRandMember, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> srandmember(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRandMember, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<String[]> srandmember(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(count)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRandMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> srandmember(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(count))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SRandMember, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String> spop(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPop, arguments, this::handleStringOrNullResponse);
    }

    @Override
    public CompletableFuture<GlideString> spop(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPop, arguments, this::handleGlideStringOrNullResponse);
    }

    @Override
    public CompletableFuture<Set<String>> spopCount(@NonNull String key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        String[] arguments = new String[]{key, Long.toString(count)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPop, arguments, this::handleSetResponse);
    }

    @Override
    public CompletableFuture<Set<GlideString>> spopCount(@NonNull GlideString key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(count))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SPop, arguments, this::handleSetBinaryResponse);
    }

    @Override
    public CompletableFuture<Long[]> bitfield(@NonNull String key, @NonNull BitFieldOptions.BitFieldSubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(BitFieldOptions.createBitFieldArgs(subCommands), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitField, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> bitfield(@NonNull GlideString key, @NonNull BitFieldOptions.BitFieldSubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(BitFieldOptions.createBitFieldGlideStringArgs(subCommands), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitField, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> bitfieldReadOnly(@NonNull String key, @NonNull BitFieldOptions.BitFieldReadOnlySubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(BitFieldOptions.createBitFieldArgs(subCommands), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitFieldReadOnly, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long[]> bitfieldReadOnly(@NonNull GlideString key, @NonNull BitFieldOptions.BitFieldReadOnlySubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        GlideString[] arguments = ArrayUtils.addFirst(BitFieldOptions.createBitFieldGlideStringArgs(subCommands), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.BitFieldReadOnly, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), Long.class));
    }

    @Override
    public CompletableFuture<Long> sintercard(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(keys, Long.toString(keys.length));
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sintercard(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(keys.length).add(keys).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sintercard(@NonNull String[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({Long.toString(keys.length)}, keys, {"LIMIT", Long.toString(limit)});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sintercard(@NonNull GlideString[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({GlideString.gs(Long.toString(keys.length))}, keys, {GlideString.gs("LIMIT"), GlideString.gs(Long.toString(limit))});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SInterCard, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull String function, @NonNull String[] keys, @NonNull String[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, Long.toString(keys.length)}, keys, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> fcall(@NonNull GlideString function, @NonNull GlideString[] keys, @NonNull GlideString[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs(Long.toString(keys.length))}, keys, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCall, args, this::handleBinaryObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull String function, @NonNull String[] keys, @NonNull String[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.concatenateArrays({function, Long.toString(keys.length)}, keys, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, this::handleObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Object> fcallReadOnly(@NonNull GlideString function, @NonNull GlideString[] keys, @NonNull GlideString[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.concatenateArrays({function, GlideString.gs(Long.toString(keys.length))}, keys, arguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, args, this::handleBinaryObjectOrNullResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination};
        if (replace) {
            arguments = ArrayUtils.add(arguments, "REPLACE");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination};
        if (replace) {
            arguments = ArrayUtils.add(arguments, GlideString.gs("REPLACE"));
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination, long destinationDB) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination, "DB", Long.toString(destinationDB)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination, long destinationDB) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination, GlideString.gs("DB"), GlideString.gs(Long.toString(destinationDB))};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull String source, @NonNull String destination, long destinationDB, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        String[] arguments = new String[]{source, destination, "DB", Long.toString(destinationDB)};
        if (replace) {
            arguments = ArrayUtils.add(arguments, "REPLACE");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> copy(@NonNull GlideString source, @NonNull GlideString destination, long destinationDB, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{source, destination, GlideString.gs("DB"), GlideString.gs(Long.toString(destinationDB))};
        if (replace) {
            arguments = ArrayUtils.add(arguments, GlideString.gs("REPLACE"));
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Copy, arguments, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> msetnx(@NonNull Map<String, String> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        String[] args = ArrayTransformUtils.convertMapToKeyValueStringArray(keyValueMap);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MSetNX, args, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<Boolean> msetnxBinary(@NonNull Map<GlideString, GlideString> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.convertMapToKeyValueGlideStringArray(keyValueMap);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.MSetNX, args, this::handleBooleanResponse);
    }

    @Override
    public CompletableFuture<String> lcs(@NonNull String key1, @NonNull String key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key1, key2};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<GlideString> lcs(@NonNull GlideString key1, @NonNull GlideString key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key1, key2};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleGlideStringResponse);
    }

    @Override
    public CompletableFuture<Long> lcsLen(@NonNull String key1, @NonNull String key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key1, key2, "LEN"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> lcsLen(@NonNull GlideString key1, @NonNull GlideString key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key1).add(key2).add("LEN").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdx(@NonNull String key1, @NonNull String key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key1, key2, "IDX"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, response -> this.handleLcsIdxResponse(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdx(@NonNull GlideString key1, @NonNull GlideString key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key1).add(key2).add("IDX").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, response -> this.handleLcsIdxResponse(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdx(@NonNull String key1, @NonNull String key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key1, key2, "IDX", "MINMATCHLEN", String.valueOf(minMatchLen)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, response -> this.handleLcsIdxResponse(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdx(@NonNull GlideString key1, @NonNull GlideString key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key1).add(key2).add("IDX").add("MINMATCHLEN").add(minMatchLen).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, response -> this.handleLcsIdxResponse(this.handleMapResponse((ResponseOuterClass.Response)response)));
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdxWithMatchLen(@NonNull String key1, @NonNull String key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = new String[]{key1, key2, "IDX", "WITHMATCHLEN"};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdxWithMatchLen(@NonNull GlideString key1, @NonNull GlideString key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key1).add(key2).add("IDX").add("WITHMATCHLEN").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdxWithMatchLen(@NonNull String key1, @NonNull String key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays(new String[][]{{key1, key2, "IDX", "MINMATCHLEN", String.valueOf(minMatchLen), "WITHMATCHLEN"}});
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<String, Object>> lcsIdxWithMatchLen(@NonNull GlideString key1, @NonNull GlideString key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key1).add(key2).add("IDX").add("MINMATCHLEN").add(minMatchLen).add("WITHMATCHLEN").toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.LCS, arguments, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<String> publish(@NonNull String message, @NonNull String channel) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Publish, new String[]{channel, message}, response -> {
            this.handleLongResponse((ResponseOuterClass.Response)response);
            return OK;
        });
    }

    @Override
    public CompletableFuture<String> publish(@NonNull GlideString message, @NonNull GlideString channel) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Publish, new GlideString[]{channel, message}, response -> {
            this.handleLongResponse((ResponseOuterClass.Response)response);
            return OK;
        });
    }

    @Override
    public CompletableFuture<String[]> pubsubChannels() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubChannels, new String[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> pubsubChannelsBinary() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubChannels, new GlideString[0], response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> pubsubChannels(@NonNull String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubChannels, new String[]{pattern}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> pubsubChannels(@NonNull GlideString pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubChannels, new GlideString[]{pattern}, response -> ArrayTransformUtils.castArray(this.handleArrayResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> pubsubNumPat() {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubNumPat, new String[0], this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Map<String, Long>> pubsubNumSub(@NonNull String[] channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubNumSub, channels, this::handleMapResponse);
    }

    @Override
    public CompletableFuture<Map<GlideString, Long>> pubsubNumSub(@NonNull GlideString[] channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.PubSubNumSub, channels, this::handleBinaryStringMapResponse);
    }

    @Override
    public CompletableFuture<String> watch(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Watch, keys, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> watch(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Watch, keys, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<Set<String>> sunion(@NonNull String[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SUnion, keys, this::handleSetResponse);
    }

    @Override
    public CompletableFuture<Set<GlideString>> sunion(@NonNull GlideString[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SUnion, keys, this::handleSetBinaryResponse);
    }

    private Object convertByteArrayToGlideString(Object o) {
        if (o == null) {
            return o;
        }
        if (o instanceof byte[]) {
            o = GlideString.of((byte[])o);
        } else if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.convertByteArrayToGlideString(array[i]);
            }
        } else if (o instanceof Set) {
            Set set = (Set)o;
            o = set.stream().map(this::convertByteArrayToGlideString).collect(Collectors.toSet());
        } else if (o instanceof Map) {
            Map map = (Map)o;
            o = map.entrySet().stream().collect(LinkedHashMap::new, (m, e) -> m.put(this.convertByteArrayToGlideString(e.getKey()), this.convertByteArrayToGlideString(e.getValue())), HashMap::putAll);
        }
        return o;
    }

    @Override
    public CompletableFuture<byte[]> dump(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Dump, arguments, this::handleBytesOrNullResponse);
    }

    @Override
    public CompletableFuture<String> restore(@NonNull GlideString key, long ttl, @NonNull byte[] value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, GlideString.gs(Long.toString(ttl)), GlideString.gs(value)};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Restore, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String> restore(@NonNull GlideString key, long ttl, @NonNull byte[] value, @NonNull RestoreOptions restoreOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (restoreOptions == null) {
            throw new NullPointerException("restoreOptions is marked non-null but is null");
        }
        GlideString[] arguments = ArrayTransformUtils.concatenateArrays({key, GlideString.gs(Long.toString(ttl)), GlideString.gs(value)}, restoreOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Restore, arguments, this::handleStringResponse);
    }

    @Override
    public CompletableFuture<String[]> sort(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, new String[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> sort(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, new GlideString[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> sort(@NonNull String key, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(sortOptions.toArgs(), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> sort(@NonNull GlideString key, @NonNull SortOptionsBinary sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(sortOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> sortReadOnly(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SortReadOnly, new String[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> sortReadOnly(@NonNull GlideString key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SortReadOnly, new GlideString[]{key}, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> sortReadOnly(@NonNull String key, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        String[] arguments = ArrayUtils.addFirst(sortOptions.toArgs(), key);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SortReadOnly, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> sortReadOnly(@NonNull GlideString key, @NonNull SortOptionsBinary sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(sortOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SortReadOnly, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Long> sortStore(@NonNull String key, @NonNull String destination) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, new String[]{key, "STORE", destination}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sortStore(@NonNull GlideString key, @NonNull GlideString destination) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, new GlideString[]{key, GlideString.gs("STORE"), destination}, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sortStore(@NonNull String key, @NonNull String destination, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        String[] storeArguments = new String[]{"STORE", destination};
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, sortOptions.toArgs(), storeArguments);
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> sortStore(@NonNull GlideString key, @NonNull GlideString destination, @NonNull SortOptionsBinary sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(sortOptions.toArgs()).add("STORE").add(destination).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Sort, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<String[]> geosearch(@NonNull String key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, searchFrom.toArgs(), searchBy.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> geosearch(@NonNull GlideString key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<String[]> geosearch(@NonNull String key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, searchFrom.toArgs(), searchBy.toArgs(), resultOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayResponse((ResponseOuterClass.Response)response), String.class));
    }

    @Override
    public CompletableFuture<GlideString[]> geosearch(@NonNull GlideString key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(resultOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, response -> ArrayTransformUtils.castArray(this.handleArrayOrNullResponseBinary((ResponseOuterClass.Response)response), GlideString.class));
    }

    @Override
    public CompletableFuture<Object[]> geosearch(@NonNull String key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, searchFrom.toArgs(), searchBy.toArgs(), options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> geosearch(@NonNull GlideString key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> geosearch(@NonNull String key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key}, searchFrom.toArgs(), searchBy.toArgs(), options.toArgs(), resultOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> geosearch(@NonNull GlideString key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).add(resultOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearch, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull String destination, @NonNull String source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination, source}, searchFrom.toArgs(), searchBy.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull String destination, @NonNull String source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination, source}, searchFrom.toArgs(), searchBy.toArgs(), resultOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(resultOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull String destination, @NonNull String source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination, source}, searchFrom.toArgs(), searchBy.toArgs(), options.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull String destination, @NonNull String source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({destination, source}, searchFrom.toArgs(), searchBy.toArgs(), options.toArgs(), resultOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Long> geosearchstore(@NonNull GlideString destination, @NonNull GlideString source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).add(resultOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, arguments, this::handleLongResponse);
    }

    @Override
    public CompletableFuture<Object[]> sscan(@NonNull String key, @NonNull String cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        String[] arguments = new String[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> sscan(@NonNull GlideString key, @NonNull GlideString cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> sscan(@NonNull String key, @NonNull String cursor, @NonNull SScanOptions sScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (sScanOptions == null) {
            throw new NullPointerException("sScanOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, cursor}, sScanOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> sscan(@NonNull GlideString key, @NonNull GlideString cursor, @NonNull SScanOptionsBinary sScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (sScanOptions == null) {
            throw new NullPointerException("sScanOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(cursor).add(sScanOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.SScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> zscan(@NonNull String key, @NonNull String cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        String[] arguments = new String[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> zscan(@NonNull GlideString key, @NonNull GlideString cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> zscan(@NonNull String key, @NonNull String cursor, @NonNull ZScanOptions zScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (zScanOptions == null) {
            throw new NullPointerException("zScanOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, cursor}, zScanOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> zscan(@NonNull GlideString key, @NonNull GlideString cursor, @NonNull ZScanOptionsBinary zScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (zScanOptions == null) {
            throw new NullPointerException("zScanOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(cursor).add(zScanOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.ZScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> hscan(@NonNull String key, @NonNull String cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        String[] arguments = new String[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> hscan(@NonNull GlideString key, @NonNull GlideString cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        GlideString[] arguments = new GlideString[]{key, cursor};
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Object[]> hscan(@NonNull String key, @NonNull String cursor, @NonNull HScanOptions hScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (hScanOptions == null) {
            throw new NullPointerException("hScanOptions is marked non-null but is null");
        }
        String[] arguments = ArrayTransformUtils.concatenateArrays({key, cursor}, hScanOptions.toArgs());
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HScan, arguments, this::handleArrayResponse);
    }

    @Override
    public CompletableFuture<Object[]> hscan(@NonNull GlideString key, @NonNull GlideString cursor, @NonNull HScanOptionsBinary hScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (hScanOptions == null) {
            throw new NullPointerException("hScanOptions is marked non-null but is null");
        }
        GlideString[] arguments = new ArgsBuilder().add(key).add(cursor).add(hScanOptions.toArgs()).toArray();
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.HScan, arguments, this::handleArrayOrNullResponseBinary);
    }

    @Override
    public CompletableFuture<Long> wait(long numreplicas, long timeout) {
        return this.commandManager.submitNewCommand(CommandRequestOuterClass.RequestType.Wait, new String[]{Long.toString(numreplicas), Long.toString(timeout)}, this::handleLongResponse);
    }

    protected static class ClientBuilder {
        private final ConnectionManager connectionManager;
        private final CommandManager commandManager;
        private final MessageHandler messageHandler;
        private final Optional<BaseSubscriptionConfiguration> subscriptionConfiguration;

        @Generated
        public ClientBuilder(ConnectionManager connectionManager, CommandManager commandManager, MessageHandler messageHandler, Optional<BaseSubscriptionConfiguration> subscriptionConfiguration) {
            this.connectionManager = connectionManager;
            this.commandManager = commandManager;
            this.messageHandler = messageHandler;
            this.subscriptionConfiguration = subscriptionConfiguration;
        }
    }
}

