/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import glide.api.logging.Logger;
import java.io.Closeable;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public abstract class Pool<T>
implements Closeable {
    protected GenericObjectPool<T> internalPool;

    public void initPool(PooledObjectFactory<T> pooledObjectFactory) {
        this.initPool(new GenericObjectPoolConfig(), pooledObjectFactory);
    }

    public void initPool(GenericObjectPoolConfig<T> poolConfig, PooledObjectFactory<T> pooledObjectFactory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception e) {
                Logger.log(Logger.Level.WARN, "Pool", () -> "Failed to close existing internal pool during initialization: " + e.getMessage(), (Throwable)e);
            }
        }
        this.internalPool = new GenericObjectPool<T>(pooledObjectFactory, poolConfig);
    }

    public T getResource() {
        try {
            return this.internalPool.borrowObject();
        }
        catch (Exception e) {
            throw new JedisException("Could not get a resource from the pool", e);
        }
    }

    protected void returnResourceObject(T resource) {
        if (resource == null) {
            return;
        }
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    public void returnResource(T resource) {
        this.returnResourceObject(resource);
    }

    protected void invalidateObject(T resource) {
        if (resource == null) {
            return;
        }
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not invalidate the resource", e);
        }
    }

    public int getNumActive() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumActive();
    }

    public int getNumIdle() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumIdle();
    }

    public int getNumWaiters() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumWaiters();
    }

    public long getMeanBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMeanBorrowWaitTimeMillis();
    }

    public long getMaxBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMaxBorrowWaitTimeMillis();
    }

    public long getCreatedCount() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getCreatedCount();
    }

    public long getDestroyedCount() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getDestroyedCount();
    }

    public int getMaxTotal() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getMaxTotal();
    }

    public boolean isClosed() {
        return this.internalPool.isClosed();
    }

    public void addObjects(int count) {
        try {
            for (int i = 0; i < count; ++i) {
                this.internalPool.addObject();
            }
        }
        catch (Exception e) {
            throw new JedisException("Error trying to add objects to pool", e);
        }
    }

    protected void closeInternalPool() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new JedisException("Could not destroy the pool", e);
        }
    }

    private boolean poolInactive() {
        return this.internalPool == null || this.internalPool.isClosed();
    }

    @Override
    public void close() {
        this.closeInternalPool();
    }
}

