/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.UnifiedJedis;

public class JedisCluster
extends UnifiedJedis {
    public static final String INIT_NO_ERROR_PROPERTY = "jedis.cluster.initNoError";
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_MAX_ATTEMPTS = 5;
    private final Set<HostAndPort> clusterNodes;

    public JedisCluster(HostAndPort node) {
        this(Collections.singleton(node));
    }

    public JedisCluster(HostAndPort node, int timeout) {
        this(Collections.singleton(node), timeout);
    }

    public JedisCluster(HostAndPort node, int timeout, int maxAttempts) {
        this(Collections.singleton(node), timeout, maxAttempts);
    }

    public JedisCluster(HostAndPort node, GenericObjectPoolConfig<Connection> poolConfig) {
        this(Collections.singleton(node), poolConfig);
    }

    public JedisCluster(HostAndPort node, int timeout, GenericObjectPoolConfig<Connection> poolConfig) {
        this(Collections.singleton(node), timeout, poolConfig);
    }

    public JedisCluster(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig<Connection> poolConfig) {
        this(Collections.singleton(node), timeout, maxAttempts, poolConfig);
    }

    public JedisCluster(HostAndPort node, JedisClientConfig clientConfig, int maxAttempts, GenericObjectPoolConfig<Connection> poolConfig) {
        this(Collections.singleton(node), clientConfig, maxAttempts);
    }

    public JedisCluster(Set<HostAndPort> nodes) {
        this(nodes, 2000);
    }

    public JedisCluster(Set<HostAndPort> nodes, int timeout) {
        super(nodes, (JedisClientConfig)DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).build());
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, int timeout, int maxAttempts) {
        super(nodes, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).build(), maxAttempts);
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, GenericObjectPoolConfig<Connection> poolConfig) {
        super(nodes, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig<Connection> poolConfig) {
        super(nodes, (JedisClientConfig)DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).build());
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, int timeout, int maxAttempts, GenericObjectPoolConfig<Connection> poolConfig) {
        super(nodes, DefaultJedisClientConfig.builder().socketTimeoutMillis(timeout).build(), maxAttempts);
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, JedisClientConfig clientConfig) {
        super(nodes, clientConfig);
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public JedisCluster(Set<HostAndPort> nodes, JedisClientConfig clientConfig, int maxAttempts) {
        super(nodes, clientConfig, maxAttempts);
        this.clusterNodes = new HashSet<HostAndPort>(nodes);
    }

    public Map<String, ConnectionPool> getClusterNodes() {
        HashMap<String, ConnectionPool> nodeMap = new HashMap<String, ConnectionPool>();
        for (HostAndPort node : this.clusterNodes) {
            String nodeKey = node.getHost() + ":" + node.getPort();
            nodeMap.put(nodeKey, null);
        }
        return nodeMap;
    }

    public Connection getConnectionFromSlot(int slot) {
        throw new UnsupportedOperationException("getConnectionFromSlot is not supported in GLIDE compatibility layer");
    }
}

