/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands.scan;

import glide.api.models.GlideString;
import glide.utils.ArgsBuilder;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

public abstract class BaseScanOptions {
    public static final String MATCH_OPTION_STRING = "MATCH";
    public static final String COUNT_OPTION_STRING = "COUNT";
    protected final String matchPattern;
    protected final GlideString matchPatternBinary;
    protected final Long count;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseScanOptions)) {
            return false;
        }
        BaseScanOptions that = (BaseScanOptions)o;
        return Objects.equals(this.matchPattern, that.matchPattern) && Objects.equals(this.count, that.count);
    }

    public String[] toArgs() {
        return (String[])Arrays.stream(this.toGlideStringArgs()).map(e -> e.getString()).toArray(String[]::new);
    }

    public GlideString[] toGlideStringArgs() {
        ArgsBuilder builder = new ArgsBuilder();
        builder.addIf(MATCH_OPTION_STRING, this.matchPattern != null);
        if (this.matchPatternBinary != null) {
            builder.add(this.matchPatternBinary);
        } else if (this.matchPattern != null) {
            builder.add(this.matchPattern);
        }
        builder.addIf(COUNT_OPTION_STRING, this.count != null);
        builder.addIf(this.count, this.count != null);
        return builder.toArray();
    }

    @Generated
    protected BaseScanOptions(BaseScanOptionsBuilder<?, ?> b) {
        this.matchPattern = b.matchPattern;
        this.matchPatternBinary = b.matchPatternBinary;
        this.count = b.count;
    }

    @Generated
    public static abstract class BaseScanOptionsBuilder<C extends BaseScanOptions, B extends BaseScanOptionsBuilder<C, B>> {
        @Generated
        private String matchPattern;
        @Generated
        private GlideString matchPatternBinary;
        @Generated
        private Long count;

        @Generated
        public B matchPattern(String matchPattern) {
            this.matchPattern = matchPattern;
            return this.self();
        }

        @Generated
        public B matchPatternBinary(GlideString matchPatternBinary) {
            this.matchPatternBinary = matchPatternBinary;
            return this.self();
        }

        @Generated
        public B count(Long count) {
            this.count = count;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseScanOptions.BaseScanOptionsBuilder(matchPattern=" + this.matchPattern + ", matchPatternBinary=" + String.valueOf(this.matchPatternBinary) + ", count=" + this.count + ")";
        }
    }
}

