/*
 * Decompiled with CFR 0.152.
 */
package glide.api;

import glide.api.logging.Logger;
import glide.api.models.exceptions.ConfigurationError;
import glide.ffi.resolvers.OpenTelemetryResolver;
import java.util.Random;

public class OpenTelemetry {
    private static OpenTelemetry openTelemetry = null;
    private static OpenTelemetryConfig openTelemetryConfig = null;
    private static final Random random = new Random();

    public static synchronized void init(OpenTelemetryConfig config) {
        if (openTelemetry == null) {
            OpenTelemetry.internalInit(config);
            Logger.log(Logger.Level.INFO, "GlideOpenTelemetry", "OpenTelemetry initialized");
            return;
        }
        Logger.log(Logger.Level.WARN, "GlideOpenTelemetry", "OpenTelemetry already initialized");
    }

    private static void internalInit(OpenTelemetryConfig config) {
        openTelemetryConfig = config;
        String tracesEndpoint = null;
        int tracesSamplePercentage = -1;
        if (config.getTraces() == null && config.getMetrics() == null) {
            Logger.log(Logger.Level.INFO, "GlideOpenTelemetry", "Error: Both traces and metrics are null");
            throw new ConfigurationError("At least one of traces or metrics must be provided");
        }
        if (config.getTraces() != null) {
            tracesEndpoint = config.getTraces().getEndpoint();
            if (config.getTraces().getSamplePercentage() != null) {
                tracesSamplePercentage = config.getTraces().getSamplePercentage();
            }
        }
        String metricsEndpoint = null;
        if (config.getMetrics() != null) {
            metricsEndpoint = config.getMetrics().getEndpoint();
        }
        long flushIntervalMs = config.getFlushIntervalMs() != null ? config.getFlushIntervalMs() : 5000L;
        OpenTelemetryResolver.initOpenTelemetry(tracesEndpoint, tracesSamplePercentage, metricsEndpoint, flushIntervalMs);
        openTelemetry = new OpenTelemetry();
    }

    public static boolean isInitialized() {
        return openTelemetry != null;
    }

    public static Integer getSamplePercentage() {
        if (openTelemetryConfig != null && openTelemetryConfig.getTraces() != null) {
            return openTelemetryConfig.getTraces().getSamplePercentage();
        }
        return null;
    }

    public static boolean shouldSample() {
        Integer percentage = OpenTelemetry.getSamplePercentage();
        return OpenTelemetry.isInitialized() && percentage != null && random.nextDouble() * 100.0 < (double)percentage.intValue();
    }

    public static void setSamplePercentage(int percentage) {
        if (openTelemetryConfig == null || openTelemetryConfig.getTraces() == null) {
            throw new ConfigurationError("OpenTelemetry config traces not initialized");
        }
        openTelemetryConfig.getTraces().setSamplePercentage(percentage);
    }

    public static class MetricsConfig {
        private String endpoint;

        public static Builder builder() {
            return new Builder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public static class Builder {
            private String endpoint;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public MetricsConfig build() {
                MetricsConfig config = new MetricsConfig();
                config.endpoint = this.endpoint;
                return config;
            }
        }
    }

    public static class TracesConfig {
        private String endpoint;
        private Integer samplePercentage;

        public static Builder builder() {
            return new Builder();
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public Integer getSamplePercentage() {
            return this.samplePercentage;
        }

        public void setSamplePercentage(Integer samplePercentage) {
            if (samplePercentage < 0 || samplePercentage > 100) {
                throw new ConfigurationError("Sample percentage must be between 0 and 100");
            }
            this.samplePercentage = samplePercentage;
        }

        public static class Builder {
            private String endpoint;
            private Integer samplePercentage = 1;

            public Builder endpoint(String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            public Builder samplePercentage(Integer samplePercentage) {
                this.samplePercentage = samplePercentage;
                return this;
            }

            public TracesConfig build() {
                TracesConfig config = new TracesConfig();
                config.endpoint = this.endpoint;
                config.samplePercentage = this.samplePercentage;
                return config;
            }
        }
    }

    public static class OpenTelemetryConfig {
        private TracesConfig traces;
        private MetricsConfig metrics;
        private Long flushIntervalMs;

        public static Builder builder() {
            return new Builder();
        }

        public TracesConfig getTraces() {
            return this.traces;
        }

        public MetricsConfig getMetrics() {
            return this.metrics;
        }

        public Long getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        public static class Builder {
            private TracesConfig traces;
            private MetricsConfig metrics;
            private Long flushIntervalMs = 5000L;

            public Builder traces(TracesConfig traces) {
                this.traces = traces;
                return this;
            }

            public Builder metrics(MetricsConfig metrics) {
                this.metrics = metrics;
                return this;
            }

            public Builder flushIntervalMs(Long flushIntervalMs) {
                this.flushIntervalMs = flushIntervalMs;
                return this;
            }

            public OpenTelemetryConfig build() {
                OpenTelemetryConfig config = new OpenTelemetryConfig();
                config.traces = this.traces;
                config.metrics = this.metrics;
                config.flushIntervalMs = this.flushIntervalMs;
                return config;
            }
        }
    }
}

