/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.net.URI;

public class JedisURIHelper {
    private JedisURIHelper() {
    }

    public static boolean isRedisSSLScheme(URI uri) {
        return uri != null && "rediss".equals(uri.getScheme());
    }

    public static boolean isValid(URI uri) {
        if (uri == null) {
            return false;
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            return false;
        }
        return "redis".equals(scheme) || "rediss".equals(scheme);
    }

    public static int getDefaultPort(URI uri) {
        if (JedisURIHelper.isRedisSSLScheme(uri)) {
            return 6380;
        }
        return 6379;
    }
}

