/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.search;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Builder;
import redis.clients.jedis.search.Document;

public class SearchResult {
    private final long totalResults;
    private final List<Document> documents;

    public SearchResult(long totalResults, List<Document> documents) {
        this.totalResults = totalResults;
        this.documents = documents;
    }

    public long getTotalResults() {
        return this.totalResults;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public String toString() {
        return "SearchResult{totalResults=" + this.totalResults + ", documents=" + String.valueOf(this.documents) + "}";
    }

    public static class SearchResultBuilder
    extends Builder<SearchResult> {
        private final boolean hasContent;
        private final boolean hasScores;
        private final boolean hasPayloads;
        private final boolean decode;
        private final Map<String, Boolean> isFieldDecode;

        public SearchResultBuilder() {
            this(false, false, false, false);
        }

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean hasPayloads, boolean decode) {
            this.hasContent = hasContent;
            this.hasScores = hasScores;
            this.hasPayloads = hasPayloads;
            this.decode = decode;
            this.isFieldDecode = null;
        }

        public SearchResultBuilder(boolean hasContent, boolean hasScores, boolean decode, Map<String, Boolean> isFieldDecode) {
            this.hasContent = hasContent;
            this.hasScores = hasScores;
            this.hasPayloads = false;
            this.decode = decode;
            this.isFieldDecode = isFieldDecode;
        }

        @Override
        public SearchResult build(Object data) {
            return new SearchResult(0L, Collections.emptyList());
        }
    }
}

