/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Objects;

public class HostAndPort {
    private final String host;
    private final int port;

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public static HostAndPort from(String hostAndPortStr) {
        if (hostAndPortStr == null || hostAndPortStr.trim().isEmpty()) {
            throw new IllegalArgumentException("Host and port string cannot be null or empty");
        }
        String[] parts = hostAndPortStr.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid host:port format: " + hostAndPortStr);
        }
        try {
            String host = parts[0].trim();
            int port = Integer.parseInt(parts[1].trim());
            return new HostAndPort(host, port);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port number in: " + hostAndPortStr, e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)obj;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public static HostAndPort parseString(String hostPort) {
        String[] parts = hostPort.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid host:port format: " + hostPort);
        }
        try {
            return new HostAndPort(parts[0], Integer.parseInt(parts[1]));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid port number in: " + hostPort, e);
        }
    }
}

