/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.ConnectionProvider;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;

public class ClusterConnectionProvider
implements ConnectionProvider {
    private final Set<HostAndPort> nodes;
    private final JedisClientConfig clientConfig;

    public ClusterConnectionProvider(Set<HostAndPort> nodes, JedisClientConfig clientConfig) {
        this.nodes = nodes;
        this.clientConfig = clientConfig;
    }

    @Override
    public Connection getConnection() {
        HostAndPort firstNode = this.nodes.iterator().next();
        return new Connection(firstNode);
    }

    @Override
    public JedisClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public Set<HostAndPort> getNodes() {
        return this.nodes;
    }

    public Map<String, ConnectionPool> getClusterNodes() {
        return new HashMap<String, ConnectionPool>();
    }

    @Override
    public void close() {
    }
}

