/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import glide.api.models.configuration.AdvancedGlideClusterClientConfiguration;
import glide.api.models.configuration.GlideClusterClientConfiguration;
import glide.api.models.configuration.NodeAddress;
import glide.api.models.configuration.ProtocolVersion;
import glide.api.models.configuration.ServerCredentials;
import glide.api.models.configuration.TlsAdvancedConfiguration;
import java.util.Set;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import redis.clients.jedis.ClusterConnectionProvider;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.DefaultRedisCredentialsProvider;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.SslOptions;
import redis.clients.jedis.SslVerifyMode;
import redis.clients.jedis.exceptions.JedisException;

public class ClusterConfigurationMapper {
    private static final Logger logger = Logger.getLogger(ClusterConfigurationMapper.class.getName());

    public static GlideClusterClientConfiguration mapToGlideClusterConfig(Set<HostAndPort> nodes, JedisClientConfig jedisConfig) {
        if (jedisConfig.getAuthXManager() != null) {
            throw new JedisException("AuthXManager is not supported in GLIDE cluster mode. Please use username/password authentication.");
        }
        if (jedisConfig.getDatabase() != 0) {
            throw new JedisException("Cluster mode only supports database 0, but database " + jedisConfig.getDatabase() + " was specified. Please remove database selection for cluster mode.");
        }
        if (jedisConfig.getCredentialsProvider() != null && !(jedisConfig.getCredentialsProvider() instanceof DefaultRedisCredentialsProvider)) {
            throw new JedisException("Custom credentials provider is not supported in GLIDE cluster mode. Please extract credentials manually and use username/password configuration.");
        }
        if (jedisConfig.getBlockingSocketTimeoutMillis() > 0) {
            logger.warning("Blocking socket timeout specified (" + jedisConfig.getBlockingSocketTimeoutMillis() + "ms). GLIDE uses a unified request timeout for all operations in cluster mode. Blocking commands will use the same timeout as non-blocking commands.");
        }
        GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder<?, ?> builder = GlideClusterClientConfiguration.builder();
        ClusterConfigurationMapper.mapClusterNodes(nodes, builder);
        ClusterConfigurationMapper.mapConnectionSettings(jedisConfig, builder);
        ClusterConfigurationMapper.mapCredentialsAndSsl(jedisConfig, builder);
        ClusterConfigurationMapper.mapAdvancedSettings(jedisConfig, builder);
        return builder.build();
    }

    public static GlideClusterClientConfiguration mapToGlideClusterConfig(Set<HostAndPort> nodes) {
        return ClusterConfigurationMapper.mapToGlideClusterConfig(nodes, DefaultJedisClientConfig.builder().build());
    }

    private static void mapClusterNodes(Set<HostAndPort> nodes, GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder builder) {
        if (nodes == null || nodes.isEmpty()) {
            throw new JedisException("Cluster nodes cannot be null or empty");
        }
        for (HostAndPort node : nodes) {
            if (node.getHost() == null || node.getHost().trim().isEmpty()) {
                throw new JedisException("Cluster node host cannot be null or empty");
            }
            if (node.getPort() <= 0 || node.getPort() > 65535) {
                throw new JedisException("Cluster node port must be between 1 and 65535, got: " + node.getPort());
            }
            builder.address(NodeAddress.builder().host(node.getHost()).port(node.getPort()).build());
        }
        logger.info("Mapped " + nodes.size() + " cluster nodes to GLIDE configuration");
    }

    private static void mapConnectionSettings(JedisClientConfig jedisConfig, GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder builder) {
        int timeout;
        if (jedisConfig.getClientName() != null) {
            builder.clientName(jedisConfig.getClientName());
        }
        if ((timeout = ClusterConfigurationMapper.calculateGlideRequestTimeout(jedisConfig)) > 0) {
            builder.requestTimeout(timeout);
        }
        if (jedisConfig.getRedisProtocol() != null) {
            builder.protocol(jedisConfig.getRedisProtocol().toGlideProtocol());
        } else {
            builder.protocol(ProtocolVersion.RESP2);
        }
    }

    private static void mapCredentialsAndSsl(JedisClientConfig jedisConfig, GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder builder) {
        ServerCredentials.ServerCredentialsBuilder credentialsBuilder = null;
        if (jedisConfig.getUser() != null || jedisConfig.getPassword() != null) {
            credentialsBuilder = ServerCredentials.builder();
            if (jedisConfig.getUser() != null) {
                credentialsBuilder.username(jedisConfig.getUser());
            }
            if (jedisConfig.getPassword() != null) {
                credentialsBuilder.password(jedisConfig.getPassword());
            }
        }
        if (jedisConfig.isSsl()) {
            builder.useTLS(true);
            if (credentialsBuilder == null) {
                credentialsBuilder = ServerCredentials.builder();
            }
            ClusterConfigurationMapper.mapSslConfiguration(jedisConfig, credentialsBuilder, builder);
        }
        if (credentialsBuilder != null) {
            builder.credentials(credentialsBuilder.build());
        }
    }

    private static void mapSslConfiguration(JedisClientConfig jedisConfig, ServerCredentials.ServerCredentialsBuilder credentialsBuilder, GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder glideBuilder) {
        logger.info("Mapping SSL/TLS configuration from Jedis to GLIDE cluster mode");
        AdvancedGlideClusterClientConfiguration.AdvancedGlideClusterClientConfigurationBuilder<?, ?> advancedBuilder = AdvancedGlideClusterClientConfiguration.builder();
        boolean needsAdvancedConfig = false;
        if (jedisConfig.getSslOptions() != null) {
            needsAdvancedConfig = ClusterConfigurationMapper.processSslOptions(jedisConfig.getSslOptions(), advancedBuilder);
        } else {
            if (jedisConfig.getSslSocketFactory() != null) {
                throw new JedisException("Custom SSLSocketFactory is not supported in GLIDE cluster mode. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
            }
            if (jedisConfig.getHostnameVerifier() != null) {
                throw new JedisException("Custom HostnameVerifier is not supported in GLIDE cluster mode. Please use system hostname verification or SslOptions with SslVerifyMode.INSECURE for testing.");
            }
        }
        if (jedisConfig.getSslParameters() != null) {
            boolean sslParamsNeedAdvanced = ClusterConfigurationMapper.processSslParameters(jedisConfig.getSslParameters(), advancedBuilder);
            boolean bl = needsAdvancedConfig = needsAdvancedConfig || sslParamsNeedAdvanced;
        }
        if (needsAdvancedConfig) {
            glideBuilder.advancedConfiguration((AdvancedGlideClusterClientConfiguration)advancedBuilder.build());
            logger.info("Applied advanced TLS configuration to GLIDE cluster client");
        } else {
            logger.info("Using default secure TLS configuration for cluster mode");
        }
    }

    private static boolean processSslOptions(SslOptions sslOptions, AdvancedGlideClusterClientConfiguration.AdvancedGlideClusterClientConfigurationBuilder advancedBuilder) {
        SslVerifyMode verifyMode;
        if (sslOptions.getKeystoreResource() != null) {
            throw new JedisException("Keystore configuration is not supported in GLIDE cluster mode. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
        }
        if (sslOptions.getTruststoreResource() != null) {
            throw new JedisException("Truststore configuration is not supported in GLIDE cluster mode. Please use system certificate store or SslOptions with SslVerifyMode.INSECURE for testing.");
        }
        boolean needsAdvancedConfig = false;
        if (sslOptions.getSslParameters() != null) {
            boolean sslParamsNeedAdvanced = ClusterConfigurationMapper.processSslParameters(sslOptions.getSslParameters(), advancedBuilder);
            boolean bl = needsAdvancedConfig = needsAdvancedConfig || sslParamsNeedAdvanced;
        }
        if ((verifyMode = sslOptions.getSslVerifyMode()) == SslVerifyMode.INSECURE) {
            logger.warning("SSL Configuration: SSL verification disabled via SslVerifyMode.INSECURE - using insecure TLS in cluster mode");
            advancedBuilder.tlsAdvancedConfiguration((TlsAdvancedConfiguration)((TlsAdvancedConfiguration.TlsAdvancedConfigurationBuilder)TlsAdvancedConfiguration.builder().useInsecureTLS(true)).build());
            return true;
        }
        logger.info("SSL Configuration: SSL verification enabled via SslVerifyMode." + String.valueOf((Object)verifyMode) + " - using secure TLS in cluster mode");
        return needsAdvancedConfig;
    }

    private static boolean processSslParameters(SSLParameters sslParameters, AdvancedGlideClusterClientConfiguration.AdvancedGlideClusterClientConfigurationBuilder advancedBuilder) {
        if (sslParameters.getCipherSuites() != null && sslParameters.getCipherSuites().length > 0) {
            throw new JedisException("Custom cipher suites are not supported in GLIDE cluster mode. GLIDE automatically selects secure cipher suites. Please remove custom cipher suite configuration.");
        }
        if (sslParameters.getProtocols() != null && sslParameters.getProtocols().length > 0) {
            throw new JedisException("Custom SSL protocols are not supported in GLIDE cluster mode. GLIDE automatically selects the best available TLS protocol. Please remove custom protocol configuration.");
        }
        if (sslParameters.getNeedClientAuth()) {
            throw new JedisException("Client authentication (needClientAuth) is not supported in GLIDE cluster mode. Please remove client authentication configuration or use server-side authentication.");
        }
        if (sslParameters.getWantClientAuth()) {
            throw new JedisException("Client authentication (wantClientAuth) is not supported in GLIDE cluster mode. Please remove client authentication configuration or use server-side authentication.");
        }
        logger.info("SSL Configuration: Client authentication disabled - compatible with GLIDE cluster mode");
        String endpointAlgorithm = sslParameters.getEndpointIdentificationAlgorithm();
        if (endpointAlgorithm != null && endpointAlgorithm.isEmpty()) {
            throw new JedisException("Disabled endpoint identification is not supported in GLIDE cluster mode. GLIDE enforces hostname verification for security. Use SslOptions with SslVerifyMode.INSECURE if you need to bypass verification.");
        }
        if (endpointAlgorithm != null) {
            logger.info("SSL Configuration: Endpoint identification algorithm: " + endpointAlgorithm + " - compatible with GLIDE cluster mode");
        }
        return false;
    }

    private static void mapAdvancedSettings(JedisClientConfig jedisConfig, GlideClusterClientConfiguration.GlideClusterClientConfigurationBuilder builder) {
        AdvancedGlideClusterClientConfiguration.AdvancedGlideClusterClientConfigurationBuilder<?, ?> advancedBuilder = AdvancedGlideClusterClientConfiguration.builder();
        boolean hasAdvancedConfig = false;
        if (jedisConfig.getConnectionTimeoutMillis() > 0) {
            advancedBuilder.connectionTimeout(jedisConfig.getConnectionTimeoutMillis());
            hasAdvancedConfig = true;
        }
        if (hasAdvancedConfig) {
            builder.advancedConfiguration((AdvancedGlideClusterClientConfiguration)advancedBuilder.build());
        }
    }

    private static int calculateGlideRequestTimeout(JedisClientConfig jedisConfig) {
        return jedisConfig.getSocketTimeoutMillis();
    }

    public static GlideClusterClientConfiguration createDefaultConfig(Set<HostAndPort> nodes, boolean useSsl) {
        if (nodes == null || nodes.isEmpty()) {
            throw new JedisException("Cluster nodes cannot be null or empty");
        }
        DefaultJedisClientConfig config = DefaultJedisClientConfig.builder().ssl(useSsl).socketTimeoutMillis(2000).build();
        return ClusterConfigurationMapper.mapToGlideClusterConfig(nodes, config);
    }

    public static ClusterConnectionProvider createClusterConnectionProvider(Set<HostAndPort> nodes, JedisClientConfig clientConfig, Object poolConfig) {
        return new ClusterConnectionProvider(nodes, clientConfig);
    }

    public static class JedisClusterConfigurationException
    extends JedisException {
        public JedisClusterConfigurationException(String message) {
            super(message);
        }

        public JedisClusterConfigurationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

