/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

public class GetExParams {
    private ExpiryType expirationType;
    private Long expirationValue;

    public static GetExParams getExParams() {
        return new GetExParams();
    }

    public GetExParams ex(long seconds) {
        this.expirationType = ExpiryType.EX;
        this.expirationValue = seconds;
        return this;
    }

    public GetExParams px(long milliseconds) {
        this.expirationType = ExpiryType.PX;
        this.expirationValue = milliseconds;
        return this;
    }

    public GetExParams exAt(long unixTimeSeconds) {
        this.expirationType = ExpiryType.EXAT;
        this.expirationValue = unixTimeSeconds;
        return this;
    }

    public GetExParams pxAt(long unixTimeMilliseconds) {
        this.expirationType = ExpiryType.PXAT;
        this.expirationValue = unixTimeMilliseconds;
        return this;
    }

    public GetExParams persist() {
        this.expirationType = ExpiryType.PERSIST;
        this.expirationValue = null;
        return this;
    }

    public ExpiryType getExpirationType() {
        return this.expirationType;
    }

    public Long getExpirationValue() {
        return this.expirationValue;
    }

    public static enum ExpiryType {
        EX,
        PX,
        EXAT,
        PXAT,
        PERSIST;

    }
}

