/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import glide.utils.ArrayTransformUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public abstract class WeightAggregateOptions {
    public static final String WEIGHTS_VALKEY_API = "WEIGHTS";
    public static final String AGGREGATE_VALKEY_API = "AGGREGATE";

    public static class WeightedKeysBinary
    implements KeysOrWeightedKeysBinary {
        private final List<Pair<GlideString, Double>> keysWeights;

        @Override
        public GlideString[] toArgs() {
            ArrayList<GlideString> keys = new ArrayList<GlideString>();
            ArrayList<Double> weights = new ArrayList<Double>();
            ArrayList<GlideString> argumentsList = new ArrayList<GlideString>();
            for (Pair<GlideString, Double> entry : this.keysWeights) {
                keys.add(entry.getLeft());
                weights.add(entry.getRight());
            }
            argumentsList.add(GlideString.of(keys.size()));
            argumentsList.addAll(keys);
            argumentsList.add(GlideString.of(WeightAggregateOptions.WEIGHTS_VALKEY_API));
            for (Double weight : weights) {
                argumentsList.add(GlideString.of(weight));
            }
            return argumentsList.toArray(new GlideString[0]);
        }

        @Generated
        public WeightedKeysBinary(List<Pair<GlideString, Double>> keysWeights) {
            this.keysWeights = keysWeights;
        }
    }

    public static class KeyArrayBinary
    implements KeysOrWeightedKeysBinary {
        private final GlideString[] keys;

        @Override
        public GlideString[] toArgs() {
            return ArrayTransformUtils.concatenateArrays({GlideString.of(this.keys.length)}, this.keys);
        }

        @Generated
        public KeyArrayBinary(GlideString[] keys) {
            this.keys = keys;
        }
    }

    public static interface KeysOrWeightedKeysBinary {
        public GlideString[] toArgs();
    }

    public static class WeightedKeys
    implements KeysOrWeightedKeys {
        private final List<Pair<String, Double>> keysWeights;

        @Override
        public String[] toArgs() {
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<Double> weights = new ArrayList<Double>();
            ArrayList<String> argumentsList = new ArrayList<String>();
            for (Pair<String, Double> entry : this.keysWeights) {
                keys.add(entry.getLeft());
                weights.add(entry.getRight());
            }
            argumentsList.add(Integer.toString(keys.size()));
            argumentsList.addAll(keys);
            argumentsList.add(WeightAggregateOptions.WEIGHTS_VALKEY_API);
            for (Double weight : weights) {
                argumentsList.add(weight.toString());
            }
            return argumentsList.toArray(new String[0]);
        }

        @Generated
        public WeightedKeys(List<Pair<String, Double>> keysWeights) {
            this.keysWeights = keysWeights;
        }
    }

    public static class KeyArray
    implements KeysOrWeightedKeys {
        private final String[] keys;

        @Override
        public String[] toArgs() {
            return ArrayTransformUtils.concatenateArrays({Integer.toString(this.keys.length)}, this.keys);
        }

        @Generated
        public KeyArray(String[] keys) {
            this.keys = keys;
        }
    }

    public static interface KeysOrWeightedKeys {
        public String[] toArgs();
    }

    public static enum Aggregate {
        SUM,
        MIN,
        MAX;


        public String[] toArgs() {
            return new String[]{WeightAggregateOptions.AGGREGATE_VALKEY_API, this.toString()};
        }
    }
}

