/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models.commands;

import glide.api.models.GlideString;
import java.util.ArrayList;
import lombok.Generated;

public final class RestoreOptions {
    public static final String REPLACE_VALKEY_API = "REPLACE";
    public static final String ABSTTL_VALKEY_API = "ABSTTL";
    public static final String IDLETIME_VALKEY_API = "IDLETIME";
    public static final String FREQ_VALKEY_API = "FREQ";
    private boolean hasReplace;
    private boolean hasAbsttl;
    private Long idletime;
    private Long frequency;

    public GlideString[] toArgs() {
        ArrayList<GlideString> resultList = new ArrayList<GlideString>();
        if (this.hasReplace) {
            resultList.add(GlideString.gs(REPLACE_VALKEY_API));
        }
        if (this.hasAbsttl) {
            resultList.add(GlideString.gs(ABSTTL_VALKEY_API));
        }
        if (this.idletime != null && this.frequency != null) {
            throw new IllegalArgumentException("IDLETIME and FREQ cannot be set at the same time.");
        }
        if (this.idletime != null) {
            resultList.add(GlideString.gs(IDLETIME_VALKEY_API));
            resultList.add(GlideString.gs(Long.toString(this.idletime)));
        }
        if (this.frequency != null) {
            resultList.add(GlideString.gs(FREQ_VALKEY_API));
            resultList.add(GlideString.gs(Long.toString(this.frequency)));
        }
        return resultList.toArray(new GlideString[0]);
    }

    @Generated
    private static boolean $default$hasReplace() {
        return false;
    }

    @Generated
    private static boolean $default$hasAbsttl() {
        return false;
    }

    @Generated
    private static Long $default$idletime() {
        return null;
    }

    @Generated
    private static Long $default$frequency() {
        return null;
    }

    @Generated
    RestoreOptions(boolean hasReplace, boolean hasAbsttl, Long idletime, Long frequency) {
        this.hasReplace = hasReplace;
        this.hasAbsttl = hasAbsttl;
        this.idletime = idletime;
        this.frequency = frequency;
    }

    @Generated
    public static RestoreOptionsBuilder builder() {
        return new RestoreOptionsBuilder();
    }

    @Generated
    public boolean isHasReplace() {
        return this.hasReplace;
    }

    @Generated
    public boolean isHasAbsttl() {
        return this.hasAbsttl;
    }

    @Generated
    public Long getIdletime() {
        return this.idletime;
    }

    @Generated
    public Long getFrequency() {
        return this.frequency;
    }

    public static class RestoreOptionsBuilder {
        @Generated
        private boolean hasReplace$set;
        @Generated
        private boolean hasReplace$value;
        @Generated
        private boolean hasAbsttl$set;
        @Generated
        private boolean hasAbsttl$value;
        @Generated
        private boolean idletime$set;
        @Generated
        private Long idletime$value;
        @Generated
        private boolean frequency$set;
        @Generated
        private Long frequency$value;

        public RestoreOptionsBuilder replace() {
            return this.hasReplace(true);
        }

        public RestoreOptionsBuilder absttl() {
            return this.hasAbsttl(true);
        }

        @Generated
        RestoreOptionsBuilder() {
        }

        @Generated
        public RestoreOptionsBuilder hasReplace(boolean hasReplace) {
            this.hasReplace$value = hasReplace;
            this.hasReplace$set = true;
            return this;
        }

        @Generated
        public RestoreOptionsBuilder hasAbsttl(boolean hasAbsttl) {
            this.hasAbsttl$value = hasAbsttl;
            this.hasAbsttl$set = true;
            return this;
        }

        @Generated
        public RestoreOptionsBuilder idletime(Long idletime) {
            this.idletime$value = idletime;
            this.idletime$set = true;
            return this;
        }

        @Generated
        public RestoreOptionsBuilder frequency(Long frequency) {
            this.frequency$value = frequency;
            this.frequency$set = true;
            return this;
        }

        @Generated
        public RestoreOptions build() {
            boolean hasReplace$value = this.hasReplace$value;
            if (!this.hasReplace$set) {
                hasReplace$value = RestoreOptions.$default$hasReplace();
            }
            boolean hasAbsttl$value = this.hasAbsttl$value;
            if (!this.hasAbsttl$set) {
                hasAbsttl$value = RestoreOptions.$default$hasAbsttl();
            }
            Long idletime$value = this.idletime$value;
            if (!this.idletime$set) {
                idletime$value = RestoreOptions.$default$idletime();
            }
            Long frequency$value = this.frequency$value;
            if (!this.frequency$set) {
                frequency$value = RestoreOptions.$default$frequency();
            }
            return new RestoreOptions(hasReplace$value, hasAbsttl$value, idletime$value, frequency$value);
        }

        @Generated
        public String toString() {
            return "RestoreOptions.RestoreOptionsBuilder(hasReplace$value=" + this.hasReplace$value + ", hasAbsttl$value=" + this.hasAbsttl$value + ", idletime$value=" + this.idletime$value + ", frequency$value=" + this.frequency$value + ")";
        }
    }
}

