/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.util.SafeEncoder;

public class Slowlog {
    private final long id;
    private final long timeStamp;
    private final long executionTime;
    private final List<String> args;
    private HostAndPort clientIpPort;
    private String clientName;
    private static final String COMMA = ",";

    public Slowlog() {
        this.id = 0L;
        this.timeStamp = 0L;
        this.executionTime = 0L;
        this.args = Collections.emptyList();
        this.clientIpPort = new HostAndPort("localhost", 6379);
        this.clientName = "";
    }

    private Slowlog(List<Object> properties) {
        this.id = (Long)properties.get(0);
        this.timeStamp = (Long)properties.get(1);
        this.executionTime = (Long)properties.get(2);
        this.args = BuilderFactory.STRING_LIST.build(properties.get(3));
        if (properties.size() == 4) {
            return;
        }
        this.clientIpPort = HostAndPort.from(SafeEncoder.encode((byte[])properties.get(4)));
        this.clientName = SafeEncoder.encode((byte[])properties.get(5));
    }

    public static List<Slowlog> from(List<Object> nestedMultiBulkReply) {
        ArrayList<Slowlog> logs = new ArrayList<Slowlog>(nestedMultiBulkReply.size());
        for (Object obj : nestedMultiBulkReply) {
            List properties = (List)obj;
            logs.add(new Slowlog(properties));
        }
        return logs;
    }

    public long getId() {
        return this.id;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public HostAndPort getClientIpPort() {
        return this.clientIpPort;
    }

    public String getClientName() {
        return this.clientName;
    }

    public String toString() {
        return this.id + COMMA + this.timeStamp + COMMA + this.executionTime + COMMA + this.args;
    }
}

