/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CommandDocument {
    private static final String SUMMARY_STR = "summary";
    private static final String SINCE_STR = "since";
    private static final String GROUP_STR = "group";
    private static final String COMPLEXITY_STR = "complexity";
    private static final String HISTORY_STR = "history";
    private final String summary;
    private final String since;
    private final String group;
    private final String complexity;
    private final List<String> history;
    private final Map<String, Object> document;

    public CommandDocument(Map<String, Object> map) {
        this.document = map;
        this.summary = (String)map.get(SUMMARY_STR);
        this.since = (String)map.get(SINCE_STR);
        this.group = (String)map.get(GROUP_STR);
        this.complexity = (String)map.get(COMPLEXITY_STR);
        List historyObject = (List)map.get(HISTORY_STR);
        this.history = historyObject == null ? null : (historyObject.isEmpty() ? Collections.emptyList() : historyObject.stream().map(o -> {
            if (o instanceof List) {
                List l = (List)o;
                return String.valueOf(l.get(0)) + ": " + String.valueOf(l.get(1));
            }
            return o.toString();
        }).collect(Collectors.toList()));
    }

    public Map<String, Object> getDocument() {
        return this.document;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getSince() {
        return this.since;
    }

    public String getGroup() {
        return this.group;
    }

    public String getComplexity() {
        return this.complexity;
    }

    public List<String> getHistory() {
        return this.history;
    }
}

