/*
 * Decompiled with CFR 0.152.
 */
package glide.managers;

import command_request.CommandRequestOuterClass;
import glide.api.OpenTelemetry;
import glide.api.models.Batch;
import glide.api.models.ClusterBatch;
import glide.api.models.GlideString;
import glide.api.models.Script;
import glide.api.models.commands.batch.BaseBatchOptions;
import glide.api.models.commands.batch.BatchOptions;
import glide.api.models.commands.batch.ClusterBatchOptions;
import glide.api.models.commands.scan.ClusterScanCursor;
import glide.api.models.commands.scan.ScanOptions;
import glide.api.models.configuration.RequestRoutingConfiguration;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.RequestException;
import glide.com.google.protobuf.ByteString;
import glide.connectors.handlers.ChannelHandler;
import glide.ffi.resolvers.GlideValueResolver;
import glide.ffi.resolvers.OpenTelemetryResolver;
import glide.managers.GlideExceptionCheckedFunction;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import response.ResponseOuterClass;

public class CommandManager {
    private final ChannelHandler channel;

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, String[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, String[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments, route);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitNewCommand(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(requestType, arguments, route);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitNewBatch(Batch batch, boolean raiseOnError, Optional<BatchOptions> options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(batch, raiseOnError, options);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitScript(Script script, List<GlideString> keys, List<GlideString> args, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareScript(script, keys, args);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitScript(Script script, List<GlideString> args, RequestRoutingConfiguration.Route route, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareScript(script, args, route);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitNewBatch(ClusterBatch batch, boolean raiseOnError, Optional<ClusterBatchOptions> options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCommandRequest(batch, raiseOnError, options);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitClusterScan(ClusterScanCursor cursor, @NonNull ScanOptions options, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        CommandRequestOuterClass.CommandRequest.Builder command = this.prepareCursorRequest(cursor, options);
        return this.submitCommandToChannel(command, responseHandler);
    }

    public <T> CompletableFuture<T> submitPasswordUpdate(Optional<String> password, boolean immediateAuth, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        CommandRequestOuterClass.UpdateConnectionPassword.Builder builder = CommandRequestOuterClass.UpdateConnectionPassword.newBuilder().setImmediateAuth(immediateAuth);
        password.ifPresent(builder::setPassword);
        CommandRequestOuterClass.CommandRequest.Builder command = CommandRequestOuterClass.CommandRequest.newBuilder().setUpdateConnectionPassword(builder.build());
        return this.submitCommandToChannel(command, responseHandler);
    }

    protected <T> CompletableFuture<T> submitCommandToChannel(CommandRequestOuterClass.CommandRequest.Builder command, GlideExceptionCheckedFunction<ResponseOuterClass.Response, T> responseHandler) {
        if (this.channel.isClosed()) {
            CompletableFuture errorFuture = new CompletableFuture();
            errorFuture.completeExceptionally(new ClosingException("Channel closed: Unable to submit command."));
            return errorFuture;
        }
        long rootSpanPtr = command.hasRootSpanPtr() ? command.getRootSpanPtr() : 0L;
        return ((CompletableFuture)this.channel.write(command, true).exceptionally(this::exceptionHandler)).thenApplyAsync(responseHandler::apply);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, String[] arguments, RequestRoutingConfiguration.Route route) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return this.prepareCommandRequestRoute(builder, route);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments, RequestRoutingConfiguration.Route route) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return this.prepareCommandRequestRoute(builder, route);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(Batch batch, boolean raiseOnError, Optional<BatchOptions> options) {
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder();
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("Batch");
        }
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        if (options.isPresent()) {
            BatchOptions opts = options.get();
            CommandRequestOuterClass.Batch.Builder batchBuilder = this.prepareCommandRequestBatchOptions(batch.getProtobufBatch(), opts);
            builder.setBatch(batchBuilder.setRaiseOnError(raiseOnError).build());
        } else {
            builder.setBatch(batch.getProtobufBatch().setRaiseOnError(raiseOnError).build());
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareScript(Script script, List<GlideString> keys, List<GlideString> args) {
        CommandRequestOuterClass.CommandRequest.Builder builder = keys.stream().mapToLong(key -> key.getBytes().length).sum() + args.stream().mapToLong(key -> key.getBytes().length).sum() > GlideValueResolver.MAX_REQUEST_ARGS_LENGTH_IN_BYTES ? CommandRequestOuterClass.CommandRequest.newBuilder().setScriptInvocationPointers(CommandRequestOuterClass.ScriptInvocationPointers.newBuilder().setHash(script.getHash()).setArgsPointer(GlideValueResolver.createLeakedBytesVec((byte[][])args.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]))).setKeysPointer(GlideValueResolver.createLeakedBytesVec((byte[][])keys.stream().map(GlideString::getBytes).toArray(x$0 -> new byte[x$0][]))).build()) : CommandRequestOuterClass.CommandRequest.newBuilder().setScriptInvocation(CommandRequestOuterClass.ScriptInvocation.newBuilder().setHash(script.getHash()).addAllKeys(keys.stream().map(GlideString::getBytes).map(ByteString::copyFrom).collect(Collectors.toList())).addAllArgs(args.stream().map(GlideString::getBytes).map(ByteString::copyFrom).collect(Collectors.toList())).build());
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareScript(Script script, List<GlideString> args, RequestRoutingConfiguration.Route route) {
        CommandRequestOuterClass.CommandRequest.Builder builder = this.prepareScript(script, List.of(), args);
        return this.prepareCommandRequestRoute(builder, route);
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(ClusterBatch batch, boolean raiseOnError, Optional<ClusterBatchOptions> options) {
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder();
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("Batch");
        }
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        if (options.isPresent()) {
            ClusterBatchOptions opts = options.get();
            CommandRequestOuterClass.Batch.Builder batchBuilder = this.prepareCommandRequestBatchOptions(batch.getProtobufBatch(), opts);
            if (opts.getRetryStrategy() != null) {
                if (batchBuilder.getIsAtomic()) {
                    throw new RequestException("Retry strategy is not supported for atomic batches.");
                }
                batchBuilder.setRetryServerError(opts.getRetryStrategy().isRetryServerError());
                batchBuilder.setRetryConnectionError(opts.getRetryStrategy().isRetryConnectionError());
            }
            builder.setBatch(batchBuilder.setRaiseOnError(raiseOnError).build());
            if (opts.getRoute() != null) {
                return this.prepareCommandRequestRoute(builder, opts.getRoute());
            }
        } else {
            builder.setBatch(batch.getProtobufBatch().setRaiseOnError(raiseOnError).build());
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCursorRequest(@NonNull ClusterScanCursor cursor, @NonNull ScanOptions options) {
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan("ClusterScan");
        }
        CommandRequestOuterClass.ClusterScan.Builder clusterScanBuilder = CommandRequestOuterClass.ClusterScan.newBuilder();
        if (cursor != ClusterScanCursor.INITIAL_CURSOR_INSTANCE) {
            if (cursor instanceof ClusterScanCursorDetail) {
                clusterScanBuilder.setCursor(((ClusterScanCursorDetail)cursor).getCursorHandle());
            } else {
                throw new IllegalArgumentException("Illegal cursor submitted.");
            }
        }
        if (options.getMatchPattern() != null) {
            clusterScanBuilder.setMatchPattern(ByteString.copyFrom(options.getMatchPattern().getBytes()));
        }
        if (options.getCount() != null) {
            clusterScanBuilder.setCount(options.getCount());
        }
        if (options.getType() != null) {
            clusterScanBuilder.setObjectType(options.getType().getNativeName());
        }
        if (options.getAllowNonCoveredSlots() != null) {
            clusterScanBuilder.setAllowNonCoveredSlots(options.getAllowNonCoveredSlots());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setClusterScan(clusterScanBuilder.build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, String[] arguments) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    protected CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequest(CommandRequestOuterClass.RequestType requestType, GlideString[] arguments) {
        CommandRequestOuterClass.Command.Builder commandBuilder = CommandRequestOuterClass.Command.newBuilder();
        CommandManager.populateCommandWithArgs(arguments, commandBuilder);
        long spanPtr = 0L;
        if (OpenTelemetry.isInitialized() && OpenTelemetry.shouldSample()) {
            spanPtr = OpenTelemetryResolver.createLeakedOtelSpan(requestType.name());
        }
        CommandRequestOuterClass.CommandRequest.Builder builder = CommandRequestOuterClass.CommandRequest.newBuilder().setSingleCommand(commandBuilder.setRequestType(requestType).build());
        if (spanPtr != 0L) {
            builder.setRootSpanPtr(spanPtr);
        }
        return builder;
    }

    private CommandRequestOuterClass.Batch.Builder prepareCommandRequestBatchOptions(CommandRequestOuterClass.Batch.Builder batchBuilder, BaseBatchOptions options) {
        if (options.getTimeout() != null) {
            batchBuilder.setTimeout(options.getTimeout());
        }
        return batchBuilder;
    }

    private CommandRequestOuterClass.CommandRequest.Builder prepareCommandRequestRoute(CommandRequestOuterClass.CommandRequest.Builder builder, RequestRoutingConfiguration.Route route) {
        if (route instanceof RequestRoutingConfiguration.SimpleMultiNodeRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSimpleRoutes(CommandRequestOuterClass.SimpleRoutes.forNumber(((RequestRoutingConfiguration.SimpleMultiNodeRoute)route).getOrdinal())).build());
        } else if (route instanceof RequestRoutingConfiguration.SimpleSingleNodeRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSimpleRoutes(CommandRequestOuterClass.SimpleRoutes.forNumber(((RequestRoutingConfiguration.SimpleSingleNodeRoute)route).getOrdinal())).build());
        } else if (route instanceof RequestRoutingConfiguration.SlotIdRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSlotIdRoute(CommandRequestOuterClass.SlotIdRoute.newBuilder().setSlotId(((RequestRoutingConfiguration.SlotIdRoute)route).getSlotId()).setSlotType(CommandRequestOuterClass.SlotTypes.forNumber(((RequestRoutingConfiguration.SlotIdRoute)route).getSlotType().ordinal()))));
        } else if (route instanceof RequestRoutingConfiguration.SlotKeyRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setSlotKeyRoute(CommandRequestOuterClass.SlotKeyRoute.newBuilder().setSlotKey(((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotKey()).setSlotType(CommandRequestOuterClass.SlotTypes.forNumber(((RequestRoutingConfiguration.SlotKeyRoute)route).getSlotType().ordinal()))));
        } else if (route instanceof RequestRoutingConfiguration.ByAddressRoute) {
            builder.setRoute(CommandRequestOuterClass.Routes.newBuilder().setByAddressRoute(CommandRequestOuterClass.ByAddressRoute.newBuilder().setHost(((RequestRoutingConfiguration.ByAddressRoute)route).getHost()).setPort(((RequestRoutingConfiguration.ByAddressRoute)route).getPort())));
        } else {
            throw new RequestException(String.format("Unknown type of route: %s", route.getClass().getSimpleName()));
        }
        return builder;
    }

    private ResponseOuterClass.Response exceptionHandler(Throwable e) {
        if (e instanceof ClosingException) {
            this.channel.close();
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static <ArgType> void populateCommandWithArgs(ArgType[] arguments, CommandRequestOuterClass.Command.Builder outputBuilder) {
        CommandManager.populateCommandWithArgs(Arrays.stream(arguments).map(value -> GlideString.of(value).getBytes()).collect(Collectors.toList()), outputBuilder);
    }

    private static void populateCommandWithArgs(GlideString[] arguments, CommandRequestOuterClass.Command.Builder outputBuilder) {
        CommandManager.populateCommandWithArgs(Arrays.stream(arguments).map(GlideString::getBytes).collect(Collectors.toList()), outputBuilder);
    }

    private static void populateCommandWithArgs(List<byte[]> arguments, CommandRequestOuterClass.Command.Builder outputBuilder) {
        long totalArgSize = arguments.stream().mapToLong(arg -> ((byte[])arg).length).sum();
        if (totalArgSize < GlideValueResolver.MAX_REQUEST_ARGS_LENGTH_IN_BYTES) {
            CommandRequestOuterClass.Command.ArgsArray.Builder commandArgs = CommandRequestOuterClass.Command.ArgsArray.newBuilder();
            arguments.forEach(arg -> commandArgs.addArgs(ByteString.copyFrom(arg)));
            outputBuilder.setArgsArray(commandArgs);
        } else {
            outputBuilder.setArgsVecPointer(GlideValueResolver.createLeakedBytesVec((byte[][])arguments.toArray((T[])new byte[0][])));
        }
    }

    @Generated
    public CommandManager(ChannelHandler channel) {
        this.channel = channel;
    }

    public static interface ClusterScanCursorDetail
    extends ClusterScanCursor {
        public String getCursorHandle();
    }
}

