/*
 * Decompiled with CFR 0.152.
 */
package glide.api.commands.servermodules;

import glide.api.BaseClient;
import glide.api.GlideClient;
import glide.api.GlideClusterClient;
import glide.api.models.ClusterValue;
import glide.api.models.GlideString;
import glide.api.models.commands.ConditionalChange;
import glide.api.models.commands.json.JsonArrindexOptions;
import glide.api.models.commands.json.JsonGetOptions;
import glide.api.models.commands.json.JsonGetOptionsBinary;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class Json {
    private static final String JSON_PREFIX = "JSON.";
    private static final String JSON_SET = "JSON.SET";
    private static final String JSON_GET = "JSON.GET";
    private static final String JSON_MGET = "JSON.MGET";
    private static final String JSON_NUMINCRBY = "JSON.NUMINCRBY";
    private static final String JSON_NUMMULTBY = "JSON.NUMMULTBY";
    private static final String JSON_ARRAPPEND = "JSON.ARRAPPEND";
    private static final String JSON_ARRINSERT = "JSON.ARRINSERT";
    private static final String JSON_ARRINDEX = "JSON.ARRINDEX";
    private static final String JSON_ARRLEN = "JSON.ARRLEN";
    private static final String[] JSON_DEBUG_MEMORY = new String[]{"JSON.DEBUG", "MEMORY"};
    private static final String[] JSON_DEBUG_FIELDS = new String[]{"JSON.DEBUG", "FIELDS"};
    private static final String JSON_ARRPOP = "JSON.ARRPOP";
    private static final String JSON_ARRTRIM = "JSON.ARRTRIM";
    private static final String JSON_OBJLEN = "JSON.OBJLEN";
    private static final String JSON_OBJKEYS = "JSON.OBJKEYS";
    private static final String JSON_DEL = "JSON.DEL";
    private static final String JSON_FORGET = "JSON.FORGET";
    private static final String JSON_TOGGLE = "JSON.TOGGLE";
    private static final String JSON_STRAPPEND = "JSON.STRAPPEND";
    private static final String JSON_STRLEN = "JSON.STRLEN";
    private static final String JSON_CLEAR = "JSON.CLEAR";
    private static final String JSON_RESP = "JSON.RESP";
    private static final String JSON_TYPE = "JSON.TYPE";

    private Json() {
    }

    public static CompletableFuture<String> set(@NonNull BaseClient client, @NonNull String key, @NonNull String path, @NonNull String value) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_SET, key, path, value});
    }

    public static CompletableFuture<String> set(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, @NonNull GlideString value) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_SET), key, path, value});
    }

    public static CompletableFuture<String> set(@NonNull BaseClient client, @NonNull String key, @NonNull String path, @NonNull String value, @NonNull ConditionalChange setCondition) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (setCondition == null) {
            throw new NullPointerException("setCondition is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_SET, key, path, value, setCondition.getValkeyApi()});
    }

    public static CompletableFuture<String> set(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, @NonNull GlideString value, @NonNull ConditionalChange setCondition) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (setCondition == null) {
            throw new NullPointerException("setCondition is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_SET), key, path, value, GlideString.gs(setCondition.getValkeyApi())});
    }

    public static CompletableFuture<String> get(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_GET, key});
    }

    public static CompletableFuture<GlideString> get(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_GET), key});
    }

    public static CompletableFuture<String> get(@NonNull BaseClient client, @NonNull String key, @NonNull String[] paths) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_GET, key}, paths));
    }

    public static CompletableFuture<GlideString> get(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString[] paths) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({GlideString.gs(JSON_GET), key}, paths));
    }

    public static CompletableFuture<String> get(@NonNull BaseClient client, @NonNull String key, @NonNull JsonGetOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_GET, key}, options.toArgs()));
    }

    public static CompletableFuture<GlideString> get(@NonNull BaseClient client, @NonNull GlideString key, @NonNull JsonGetOptionsBinary options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_GET)).add(key).add(options.toArgs()).toArray());
    }

    public static CompletableFuture<String> get(@NonNull BaseClient client, @NonNull String key, @NonNull String[] paths, @NonNull JsonGetOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_GET, key}, options.toArgs(), paths));
    }

    public static CompletableFuture<GlideString> get(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString[] paths, @NonNull JsonGetOptionsBinary options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (paths == null) {
            throw new NullPointerException("paths is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_GET)).add(key).add(options.toArgs()).add(paths).toArray());
    }

    public static CompletableFuture<String[]> mget(@NonNull BaseClient client, @NonNull String[] keys, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_MGET}, keys, {path})).thenApply(res -> ArrayTransformUtils.castArray(res, String.class));
    }

    public static CompletableFuture<GlideString[]> mget(@NonNull BaseClient client, @NonNull GlideString[] keys, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({GlideString.gs(JSON_MGET)}, keys, {path})).thenApply(res -> ArrayTransformUtils.castArray(res, GlideString.class));
    }

    public static CompletableFuture<Object> arrappend(@NonNull BaseClient client, @NonNull String key, @NonNull String path, @NonNull String[] values) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_ARRAPPEND, key, path}, values));
    }

    public static CompletableFuture<Object> arrappend(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, @NonNull GlideString[] values) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_ARRAPPEND)).add(key).add(path).add(values).toArray());
    }

    public static CompletableFuture<Object> arrinsert(@NonNull BaseClient client, @NonNull String key, @NonNull String path, int index, @NonNull String[] values) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays({JSON_ARRINSERT, key, path, Integer.toString(index)}, values));
    }

    public static CompletableFuture<Object> arrinsert(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, int index, @NonNull GlideString[] values) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_ARRINSERT)).add(key).add(path).add(Integer.toString(index)).add(values).toArray());
    }

    public static CompletableFuture<Object> arrindex(@NonNull BaseClient client, @NonNull String key, @NonNull String path, @NonNull String scalar) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        return Json.arrindex(client, GlideString.gs(key), GlideString.gs(path), GlideString.gs(scalar));
    }

    public static CompletableFuture<Object> arrindex(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, @NonNull GlideString scalar) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRINDEX), key, path, scalar});
    }

    public static CompletableFuture<Object> arrindex(@NonNull BaseClient client, @NonNull String key, @NonNull String path, @NonNull String scalar, @NonNull JsonArrindexOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_ARRINDEX).add(key).add(path).add(scalar).add(options.toArgs()).toArray());
    }

    public static CompletableFuture<Object> arrindex(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, @NonNull GlideString scalar, @NonNull JsonArrindexOptions options) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (scalar == null) {
            throw new NullPointerException("scalar is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_ARRINDEX).add(key).add(path).add(scalar).add(options.toArgs()).toArray());
    }

    public static CompletableFuture<Object> arrlen(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRLEN, key, path});
    }

    public static CompletableFuture<Object> arrlen(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRLEN), key, path});
    }

    public static CompletableFuture<Long> arrlen(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRLEN, key});
    }

    public static CompletableFuture<Long> arrlen(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRLEN), key});
    }

    public static CompletableFuture<Object> debugMemory(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays(JSON_DEBUG_MEMORY, {key, path}));
    }

    public static CompletableFuture<Object> debugFields(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays(JSON_DEBUG_FIELDS, {key, path}));
    }

    public static CompletableFuture<Object> debugMemory(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_DEBUG_MEMORY).add(key).add(path).toArray());
    }

    public static CompletableFuture<Object> debugFields(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_DEBUG_FIELDS).add(key).add(path).toArray());
    }

    public static CompletableFuture<Long> debugMemory(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays(JSON_DEBUG_MEMORY, {key}));
    }

    public static CompletableFuture<Long> debugFields(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, ArrayTransformUtils.concatenateArrays(JSON_DEBUG_FIELDS, {key}));
    }

    public static CompletableFuture<Long> debugMemory(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_DEBUG_MEMORY).add(key).toArray());
    }

    public static CompletableFuture<Long> debugFields(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_DEBUG_FIELDS).add(key).toArray());
    }

    public static CompletableFuture<String> arrpop(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRPOP, key});
    }

    public static CompletableFuture<GlideString> arrpop(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRPOP), key});
    }

    public static CompletableFuture<Object> arrpop(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRPOP, key, path});
    }

    public static CompletableFuture<Object> arrpop(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRPOP), key, path});
    }

    public static CompletableFuture<Object> arrpop(@NonNull BaseClient client, @NonNull String key, @NonNull String path, long index) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRPOP, key, path, Long.toString(index)});
    }

    public static CompletableFuture<Object> arrpop(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, long index) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_ARRPOP), key, path, GlideString.gs(Long.toString(index))});
    }

    public static CompletableFuture<Object> arrtrim(@NonNull BaseClient client, @NonNull String key, @NonNull String path, int start, int end) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_ARRTRIM, key, path, Integer.toString(start), Integer.toString(end)});
    }

    public static CompletableFuture<Object> arrtrim(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, int start, int end) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_ARRTRIM)).add(key).add(path).add(Integer.toString(start)).add(Integer.toString(end)).toArray());
    }

    public static CompletableFuture<String> numincrby(@NonNull BaseClient client, @NonNull String key, @NonNull String path, Number number) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_NUMINCRBY, key, path, number.toString()});
    }

    public static CompletableFuture<GlideString> numincrby(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, Number number) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_NUMINCRBY), key, path, GlideString.gs(number.toString())});
    }

    public static CompletableFuture<String> nummultby(@NonNull BaseClient client, @NonNull String key, @NonNull String path, Number number) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_NUMMULTBY, key, path, number.toString()});
    }

    public static CompletableFuture<GlideString> nummultby(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path, Number number) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_NUMMULTBY), key, path, GlideString.gs(number.toString())});
    }

    public static CompletableFuture<Long> objlen(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_OBJLEN, key});
    }

    public static CompletableFuture<Long> objlen(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_OBJLEN), key});
    }

    public static CompletableFuture<Object> objlen(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_OBJLEN, key, path});
    }

    public static CompletableFuture<Object> objlen(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_OBJLEN), key, path});
    }

    public static CompletableFuture<Object[]> objkeys(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_OBJKEYS, key});
    }

    public static CompletableFuture<Object[]> objkeys(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_OBJKEYS), key});
    }

    public static CompletableFuture<Object[]> objkeys(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_OBJKEYS, key, path});
    }

    public static CompletableFuture<Object[]> objkeys(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_OBJKEYS), key, path});
    }

    public static CompletableFuture<Long> del(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_DEL, key});
    }

    public static CompletableFuture<Long> del(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_DEL), key});
    }

    public static CompletableFuture<Long> del(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_DEL, key, path});
    }

    public static CompletableFuture<Long> del(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_DEL), key, path});
    }

    public static CompletableFuture<Long> forget(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_FORGET, key});
    }

    public static CompletableFuture<Long> forget(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_FORGET), key});
    }

    public static CompletableFuture<Long> forget(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_FORGET, key, path});
    }

    public static CompletableFuture<Long> forget(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_FORGET), key, path});
    }

    public static CompletableFuture<Boolean> toggle(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_TOGGLE, key});
    }

    public static CompletableFuture<Boolean> toggle(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_TOGGLE)).add(key).toArray());
    }

    public static CompletableFuture<Object> toggle(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_TOGGLE, key, path});
    }

    public static CompletableFuture<Object> toggle(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_TOGGLE)).add(key).add(path).toArray());
    }

    public static CompletableFuture<Object> strappend(@NonNull BaseClient client, @NonNull String key, @NonNull String value, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_STRAPPEND).add(key).add(path).add(value).toArray());
    }

    public static CompletableFuture<Object> strappend(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString value, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_STRAPPEND)).add(key).add(path).add(value).toArray());
    }

    public static CompletableFuture<Long> strappend(@NonNull BaseClient client, @NonNull String key, @NonNull String value) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_STRAPPEND).add(key).add(value).toArray());
    }

    public static CompletableFuture<Long> strappend(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString value) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_STRAPPEND)).add(key).add(value).toArray());
    }

    public static CompletableFuture<Object> strlen(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_STRLEN).add(key).add(path).toArray());
    }

    public static CompletableFuture<Object> strlen(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_STRLEN)).add(key).add(path).toArray());
    }

    public static CompletableFuture<Long> strlen(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(JSON_STRLEN).add(key).toArray());
    }

    public static CompletableFuture<Long> strlen(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new ArgsBuilder().add(GlideString.gs(JSON_STRLEN)).add(key).toArray());
    }

    public static CompletableFuture<Long> clear(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_CLEAR, key});
    }

    public static CompletableFuture<Long> clear(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_CLEAR), key});
    }

    public static CompletableFuture<Long> clear(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_CLEAR, key, path});
    }

    public static CompletableFuture<Long> clear(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_CLEAR), key, path});
    }

    public static CompletableFuture<Object> resp(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_RESP, key});
    }

    public static CompletableFuture<Object> resp(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_RESP), key});
    }

    public static CompletableFuture<Object> resp(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_RESP, key, path});
    }

    public static CompletableFuture<Object> resp(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_RESP), key, path});
    }

    public static CompletableFuture<Object> type(@NonNull BaseClient client, @NonNull String key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_TYPE, key});
    }

    public static CompletableFuture<Object> type(@NonNull BaseClient client, @NonNull GlideString key) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_TYPE), key});
    }

    public static CompletableFuture<Object> type(@NonNull BaseClient client, @NonNull String key, @NonNull String path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new String[]{JSON_TYPE, key, path});
    }

    public static CompletableFuture<Object> type(@NonNull BaseClient client, @NonNull GlideString key, @NonNull GlideString path) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Json.executeCommand(client, new GlideString[]{GlideString.gs(JSON_TYPE), key, path});
    }

    private static <T> CompletableFuture<T> executeCommand(BaseClient client, String[] args) {
        return Json.executeCommand(client, args, false);
    }

    private static <T> CompletableFuture<T> executeCommand(BaseClient client, String[] args, boolean returnsMap) {
        if (client instanceof GlideClient) {
            return ((GlideClient)client).customCommand(args).thenApply(r -> r);
        }
        if (client instanceof GlideClusterClient) {
            return ((CompletableFuture)((GlideClusterClient)client).customCommand(args).thenApply(returnsMap ? ClusterValue::getMultiValue : ClusterValue::getSingleValue)).thenApply(r -> r);
        }
        throw new IllegalArgumentException("Unknown type of client, should be either `GlideClient` or `GlideClusterClient`");
    }

    private static <T> CompletableFuture<T> executeCommand(BaseClient client, GlideString[] args) {
        return Json.executeCommand(client, args, false);
    }

    private static <T> CompletableFuture<T> executeCommand(BaseClient client, GlideString[] args, boolean returnsMap) {
        if (client instanceof GlideClient) {
            return ((GlideClient)client).customCommand(args).thenApply(r -> r);
        }
        if (client instanceof GlideClusterClient) {
            return ((CompletableFuture)((GlideClusterClient)client).customCommand(args).thenApply(returnsMap ? ClusterValue::getMultiValue : ClusterValue::getSingleValue)).thenApply(r -> r);
        }
        throw new IllegalArgumentException("Unknown type of client, should be either `GlideClient` or `GlideClusterClient`");
    }
}

