/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScanResult<T> {
    private final String cursor;
    private final List<T> result;

    public ScanResult(String cursor, List<T> result) {
        this.cursor = cursor;
        this.result = result != null ? new ArrayList<T>(result) : new ArrayList();
    }

    public ScanResult(byte[] cursor, List<T> result) {
        this.cursor = cursor != null ? new String(cursor, StandardCharsets.UTF_8) : "0";
        this.result = result != null ? new ArrayList<T>(result) : new ArrayList();
    }

    public String getCursor() {
        return this.cursor;
    }

    public byte[] getCursorAsBytes() {
        return this.cursor.getBytes(StandardCharsets.UTF_8);
    }

    public List<T> getResult() {
        return Collections.unmodifiableList(this.result);
    }

    public boolean isCompleteIteration() {
        return "0".equals(this.cursor);
    }

    public String toString() {
        return "ScanResult{cursor='" + this.cursor + "', result=" + String.valueOf(this.result) + "}";
    }
}

