/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import redis.clients.jedis.GeoCoordinate;

public class GeoRadiusResponse {
    private byte[] member;
    private double distance;
    private GeoCoordinate coordinate;
    private long rawScore;

    public GeoRadiusResponse(byte[] member) {
        this.member = member;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public void setCoordinate(GeoCoordinate coordinate) {
        this.coordinate = coordinate;
    }

    public void setRawScore(long rawScore) {
        this.rawScore = rawScore;
    }

    public byte[] getMember() {
        return this.member;
    }

    public String getMemberByString() {
        return new String(this.member, StandardCharsets.UTF_8);
    }

    public double getDistance() {
        return this.distance;
    }

    public GeoCoordinate getCoordinate() {
        return this.coordinate;
    }

    public long getRawScore() {
        return this.rawScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoRadiusResponse that = (GeoRadiusResponse)o;
        return Double.compare(that.distance, this.distance) == 0 && this.rawScore == that.rawScore && Arrays.equals(this.member, that.member) && Objects.equals(this.coordinate, that.coordinate);
    }

    public int hashCode() {
        int result = Objects.hash(this.distance, this.coordinate, this.rawScore);
        result = 31 * result + Arrays.hashCode(this.member);
        return result;
    }

    public String toString() {
        return "GeoRadiusResponse{member=" + Arrays.toString(this.member) + ", distance=" + this.distance + ", coordinate=" + String.valueOf(this.coordinate) + ", rawScore=" + this.rawScore + "}";
    }
}

