/*
 * Decompiled with CFR 0.152.
 */
package glide.connectors.handlers;

import glide.api.logging.Logger;
import glide.api.models.exceptions.ClosingException;
import glide.api.models.exceptions.ConnectionException;
import glide.api.models.exceptions.ExecAbortException;
import glide.api.models.exceptions.RequestException;
import glide.api.models.exceptions.TimeoutException;
import glide.connectors.handlers.MessageHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import response.ResponseOuterClass;

public class CallbackDispatcher {
    protected final MessageHandler messageHandler;
    protected final AtomicInteger nextAvailableRequestId = new AtomicInteger(0);
    protected final ConcurrentHashMap<Integer, CompletableFuture<ResponseOuterClass.Response>> responses = new ConcurrentHashMap();
    protected final ConcurrentLinkedQueue<Integer> freeRequestIds = new ConcurrentLinkedQueue();

    public Pair<Integer, CompletableFuture<ResponseOuterClass.Response>> registerRequest() {
        CompletableFuture future = new CompletableFuture();
        Integer callbackId = this.freeRequestIds.poll();
        if (callbackId == null) {
            callbackId = this.nextAvailableRequestId.getAndIncrement();
        }
        this.responses.put(callbackId, future);
        return Pair.of(callbackId, future);
    }

    public CompletableFuture<ResponseOuterClass.Response> registerConnection() {
        return this.registerRequest().getValue();
    }

    public void completeRequest(ResponseOuterClass.Response response) throws MessageHandler.MessageCallbackException {
        if (response.hasClosingError()) {
            this.distributeClosingException(response.getClosingError());
            return;
        }
        if (response.getIsPush()) {
            this.messageHandler.handle(response);
            return;
        }
        int callbackId = response.getCallbackIdx();
        CompletableFuture<ResponseOuterClass.Response> future = this.responses.remove(callbackId);
        if (future != null) {
            this.freeRequestIds.add(callbackId);
            if (response.hasRequestError()) {
                ResponseOuterClass.RequestError error = response.getRequestError();
                String msg = error.getMessage();
                switch (error.getType()) {
                    case Unspecified: {
                        future.completeExceptionally(new RequestException(msg));
                        break;
                    }
                    case ExecAbort: {
                        future.completeExceptionally(new ExecAbortException(msg));
                        break;
                    }
                    case Timeout: {
                        future.completeExceptionally(new TimeoutException(msg));
                        break;
                    }
                    case Disconnect: {
                        future.completeExceptionally(new ConnectionException(msg));
                        break;
                    }
                    default: {
                        future.completeExceptionally(new RequestException(msg));
                    }
                }
            }
            future.completeAsync(() -> response);
        } else {
            Logger.log(Logger.Level.ERROR, "callback dispatcher", () -> "Received a response for not registered callback id " + callbackId + ", request error = " + String.valueOf(response.getRequestError()));
            this.distributeClosingException("Client is in an erroneous state and should close");
        }
    }

    public void distributeClosingException(String message) {
        this.responses.values().forEach(f -> f.completeExceptionally(new ClosingException(message)));
        this.responses.clear();
    }

    public void shutdownGracefully() {
        String msg = "Operation terminated: The closing process has been initiated for the resource.";
        this.responses.values().forEach(future -> future.completeExceptionally(new ClosingException(msg)));
        this.responses.clear();
    }

    @Generated
    public CallbackDispatcher(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

