/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import command_request.CommandRequestOuterClass;
import glide.api.models.GlideString;
import glide.api.models.commands.ExpireOptions;
import glide.api.models.commands.FlushMode;
import glide.api.models.commands.GetExOptions;
import glide.api.models.commands.HGetExOptions;
import glide.api.models.commands.HSetExOptions;
import glide.api.models.commands.HashFieldExpirationConditionOptions;
import glide.api.models.commands.InfoOptions;
import glide.api.models.commands.LInsertOptions;
import glide.api.models.commands.LPosOptions;
import glide.api.models.commands.ListDirection;
import glide.api.models.commands.RangeOptions;
import glide.api.models.commands.RestoreOptions;
import glide.api.models.commands.ScoreFilter;
import glide.api.models.commands.SetOptions;
import glide.api.models.commands.SortOptions;
import glide.api.models.commands.WeightAggregateOptions;
import glide.api.models.commands.ZAddOptions;
import glide.api.models.commands.bitmap.BitFieldOptions;
import glide.api.models.commands.bitmap.BitmapIndexType;
import glide.api.models.commands.bitmap.BitwiseOperation;
import glide.api.models.commands.function.FunctionLoadOptions;
import glide.api.models.commands.function.FunctionRestorePolicy;
import glide.api.models.commands.geospatial.GeoAddOptions;
import glide.api.models.commands.geospatial.GeoSearchOptions;
import glide.api.models.commands.geospatial.GeoSearchOrigin;
import glide.api.models.commands.geospatial.GeoSearchResultOptions;
import glide.api.models.commands.geospatial.GeoSearchShape;
import glide.api.models.commands.geospatial.GeoSearchStoreOptions;
import glide.api.models.commands.geospatial.GeoUnit;
import glide.api.models.commands.geospatial.GeospatialData;
import glide.api.models.commands.scan.HScanOptions;
import glide.api.models.commands.scan.SScanOptions;
import glide.api.models.commands.scan.ZScanOptions;
import glide.api.models.commands.stream.StreamAddOptions;
import glide.api.models.commands.stream.StreamClaimOptions;
import glide.api.models.commands.stream.StreamGroupOptions;
import glide.api.models.commands.stream.StreamPendingOptions;
import glide.api.models.commands.stream.StreamRange;
import glide.api.models.commands.stream.StreamReadGroupOptions;
import glide.api.models.commands.stream.StreamReadOptions;
import glide.api.models.commands.stream.StreamTrimOptions;
import glide.managers.CommandManager;
import glide.utils.ArgsBuilder;
import glide.utils.ArrayTransformUtils;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public abstract class BaseBatch<T extends BaseBatch<T>> {
    protected final CommandRequestOuterClass.Batch.Builder protobufBatch;
    protected boolean binaryOutput = false;

    public T withBinaryOutput() {
        this.binaryOutput = true;
        return this.getThis();
    }

    protected BaseBatch(boolean isAtomic) {
        this.protobufBatch = CommandRequestOuterClass.Batch.newBuilder().setIsAtomic(isAtomic);
    }

    protected abstract T getThis();

    public <ArgType> T customCommand(ArgType[] args) {
        ArgsBuilder.checkTypeOrThrow(args);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.CustomCommand, ArgsBuilder.newArgsBuilder().add(args)));
        return this.getThis();
    }

    public <ArgType> T echo(@NonNull ArgType message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(message);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Echo, ArgsBuilder.newArgsBuilder().add(message)));
        return this.getThis();
    }

    public T ping() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Ping));
        return this.getThis();
    }

    public <ArgType> T ping(@NonNull ArgType msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(msg);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Ping, ArgsBuilder.newArgsBuilder().add(msg)));
        return this.getThis();
    }

    public T info() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Info));
        return this.getThis();
    }

    public T info(@NonNull InfoOptions.Section[] sections) {
        if (sections == null) {
            throw new NullPointerException("sections is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Info, ArgsBuilder.newArgsBuilder().add(sections)));
        return this.getThis();
    }

    public <ArgType> T del(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Del, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T get(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Get, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T getdel(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GetDel, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T getex(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GetEx, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T getex(@NonNull ArgType key, @NonNull GetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GetEx, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T set(@NonNull ArgType key, @NonNull ArgType value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Set, ArgsBuilder.newArgsBuilder().add(key).add(value)));
        return this.getThis();
    }

    public <ArgType> T set(@NonNull ArgType key, @NonNull ArgType value, @NonNull SetOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Set, ArgsBuilder.newArgsBuilder().add(key).add(value).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T append(@NonNull ArgType key, @NonNull ArgType value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Append, ArgsBuilder.newArgsBuilder().add(key).add(value)));
        return this.getThis();
    }

    public <ArgType> T mget(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.MGet, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public T mset(@NonNull Map<?, ?> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.flattenMapToGlideStringArray(keyValueMap);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.MSet, ArgsBuilder.newArgsBuilder().add(args)));
        return this.getThis();
    }

    public T msetnx(@NonNull Map<?, ?> keyValueMap) {
        if (keyValueMap == null) {
            throw new NullPointerException("keyValueMap is marked non-null but is null");
        }
        GlideString[] args = ArrayTransformUtils.flattenMapToGlideStringArray(keyValueMap);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.MSetNX, ArgsBuilder.newArgsBuilder().add(args)));
        return this.getThis();
    }

    public <ArgType> T incr(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Incr, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T incrBy(@NonNull ArgType key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.IncrBy, ArgsBuilder.newArgsBuilder().add(key).add(amount)));
        return this.getThis();
    }

    public <ArgType> T incrByFloat(@NonNull ArgType key, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.IncrByFloat, ArgsBuilder.newArgsBuilder().add(key).add(amount)));
        return this.getThis();
    }

    public <ArgType> T decr(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Decr, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T decrBy(@NonNull ArgType key, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.DecrBy, ArgsBuilder.newArgsBuilder().add(key).add(amount)));
        return this.getThis();
    }

    public <ArgType> T strlen(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Strlen, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T setrange(@NonNull ArgType key, int offset, @NonNull ArgType value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SetRange, ArgsBuilder.newArgsBuilder().add(key).add(offset).add(value)));
        return this.getThis();
    }

    public <ArgType> T getrange(@NonNull ArgType key, int start, int end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GetRange, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T hget(@NonNull ArgType key, @NonNull ArgType field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HGet, ArgsBuilder.newArgsBuilder().add(key).add(field)));
        return this.getThis();
    }

    public <ArgType> T hset(@NonNull ArgType key, @NonNull Map<ArgType, ArgType> fieldValueMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HSet, ArgsBuilder.newArgsBuilder().add(key).add(ArrayTransformUtils.flattenMapToGlideStringArray(fieldValueMap))));
        return this.getThis();
    }

    public <ArgType> T hsetex(@NonNull ArgType key, @NonNull Map<ArgType, ArgType> fieldValueMap, @NonNull HSetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fieldValueMap == null) {
            throw new NullPointerException("fieldValueMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HSetEx, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add("FIELDS").add(fieldValueMap.size()).add(ArrayTransformUtils.flattenMapToGlideStringArray(fieldValueMap))));
        return this.getThis();
    }

    public <ArgType> T hgetex(@NonNull ArgType key, @NonNull ArgType[] fields, @NonNull HGetExOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HGetEx, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hexpire(@NonNull ArgType key, long seconds, @NonNull ArgType[] fields, @NonNull HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HExpire, ArgsBuilder.newArgsBuilder().add(key).add(seconds).add(options.toArgs()).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hpersist(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HPersist, ArgsBuilder.newArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hpexpire(@NonNull ArgType key, long milliseconds, @NonNull ArgType[] fields, @NonNull HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HPExpire, ArgsBuilder.newArgsBuilder().add(key).add(milliseconds).add(options.toArgs()).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hexpireat(@NonNull ArgType key, long unixSeconds, @NonNull ArgType[] fields, @NonNull HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixSeconds).add(options.toArgs()).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hpexpireat(@NonNull ArgType key, long unixMilliseconds, @NonNull ArgType[] fields, @NonNull HashFieldExpirationConditionOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HPExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixMilliseconds).add(options.toArgs()).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T httl(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HTtl, ArgsBuilder.newArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hpttl(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HPTtl, ArgsBuilder.newArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hexpiretime(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HExpireTime, ArgsBuilder.newArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hpexpiretime(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HPExpireTime, ArgsBuilder.newArgsBuilder().add(key).add("FIELDS").add(fields.length).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hsetnx(@NonNull ArgType key, @NonNull ArgType field, @NonNull ArgType value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HSetNX, ArgsBuilder.newArgsBuilder().add(key).add(field).add(value)));
        return this.getThis();
    }

    public <ArgType> T hdel(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HDel, ArgsBuilder.newArgsBuilder().add(key).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hlen(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HLen, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T hvals(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HVals, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T hmget(@NonNull ArgType key, @NonNull ArgType[] fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HMGet, ArgsBuilder.newArgsBuilder().add(key).add(fields)));
        return this.getThis();
    }

    public <ArgType> T hexists(@NonNull ArgType key, @NonNull ArgType field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HExists, ArgsBuilder.newArgsBuilder().add(key).add(field)));
        return this.getThis();
    }

    public <ArgType> T hgetall(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HGetAll, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T hincrBy(@NonNull ArgType key, @NonNull ArgType field, long amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HIncrBy, ArgsBuilder.newArgsBuilder().add(key).add(field).add(amount)));
        return this.getThis();
    }

    public <ArgType> T hincrByFloat(@NonNull ArgType key, @NonNull ArgType field, double amount) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HIncrByFloat, ArgsBuilder.newArgsBuilder().add(key).add(field).add(amount)));
        return this.getThis();
    }

    public <ArgType> T hkeys(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HKeys, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T hstrlen(@NonNull ArgType key, @NonNull ArgType field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HStrlen, ArgsBuilder.newArgsBuilder().add(key).add(field)));
        return this.getThis();
    }

    public <ArgType> T hrandfield(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HRandField, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T hrandfieldWithCount(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HRandField, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T hrandfieldWithCountWithValues(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HRandField, ArgsBuilder.newArgsBuilder().add(key).add(count).add("WITHVALUES")));
        return this.getThis();
    }

    public <ArgType> T lpush(@NonNull ArgType key, @NonNull ArgType[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPush, ArgsBuilder.newArgsBuilder().add(key).add(elements)));
        return this.getThis();
    }

    public <ArgType> T lpop(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPop, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T lpos(@NonNull ArgType key, @NonNull ArgType element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPos, ArgsBuilder.newArgsBuilder().add(key).add(element)));
        return this.getThis();
    }

    public <ArgType> T lpos(@NonNull ArgType key, @NonNull ArgType element, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPos, ArgsBuilder.newArgsBuilder().add(key).add(element).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T lposCount(@NonNull ArgType key, @NonNull ArgType element, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPos, ArgsBuilder.newArgsBuilder().add(key).add(element).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T lposCount(@NonNull ArgType key, @NonNull ArgType element, long count, @NonNull LPosOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPos, ArgsBuilder.newArgsBuilder().add(key).add(element).add("COUNT").add(count).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T lpopCount(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPop, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T lrange(@NonNull ArgType key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LRange, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T lindex(@NonNull ArgType key, long index) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LIndex, ArgsBuilder.newArgsBuilder().add(key).add(index)));
        return this.getThis();
    }

    public <ArgType> T ltrim(@NonNull ArgType key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LTrim, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T llen(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LLen, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T lrem(@NonNull ArgType key, long count, @NonNull ArgType element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LRem, ArgsBuilder.newArgsBuilder().add(key).add(count).add(element)));
        return this.getThis();
    }

    public <ArgType> T rpush(@NonNull ArgType key, @NonNull ArgType[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RPush, ArgsBuilder.newArgsBuilder().add(key).add(elements)));
        return this.getThis();
    }

    public <ArgType> T rpop(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RPop, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T rpopCount(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RPop, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T sadd(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SAdd, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T sismember(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SIsMember, ArgsBuilder.newArgsBuilder().add(key).add(member)));
        return this.getThis();
    }

    public <ArgType> T srem(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SRem, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T smembers(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SMembers, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T scard(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SCard, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T sdiff(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SDiff, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T smismember(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SMIsMember, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T sdiffstore(@NonNull ArgType destination, @NonNull ArgType[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SDiffStore, ArgsBuilder.newArgsBuilder().add(destination).add(keys)));
        return this.getThis();
    }

    public <ArgType> T smove(@NonNull ArgType source, @NonNull ArgType destination, @NonNull ArgType member) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(source);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SMove, ArgsBuilder.newArgsBuilder().add(source).add(destination).add(member)));
        return this.getThis();
    }

    public <ArgType> T sinter(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SInter, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T sinterstore(@NonNull ArgType destination, @NonNull ArgType[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SInterStore, ArgsBuilder.newArgsBuilder().add(destination).add(keys)));
        return this.getThis();
    }

    public <ArgType> T sintercard(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SInterCard, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys)));
        return this.getThis();
    }

    public <ArgType> T sintercard(@NonNull ArgType[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SInterCard, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add("LIMIT").add(limit)));
        return this.getThis();
    }

    public <ArgType> T sunionstore(@NonNull ArgType destination, @NonNull ArgType[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SUnionStore, ArgsBuilder.newArgsBuilder().add(destination).add(keys)));
        return this.getThis();
    }

    public <ArgType> T configGet(@NonNull ArgType[] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(parameters);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ConfigGet, ArgsBuilder.newArgsBuilder().add(parameters)));
        return this.getThis();
    }

    public <ArgType> T configSet(@NonNull Map<ArgType, ArgType> parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ConfigSet, ArgsBuilder.newArgsBuilder().add(ArrayTransformUtils.flattenMapToGlideStringArray(parameters))));
        return this.getThis();
    }

    public <ArgType> T exists(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Exists, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T unlink(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Unlink, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T expire(@NonNull ArgType key, long seconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Expire, ArgsBuilder.newArgsBuilder().add(key).add(seconds)));
        return this.getThis();
    }

    public <ArgType> T expire(@NonNull ArgType key, long seconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Expire, ArgsBuilder.newArgsBuilder().add(key).add(seconds).add(expireOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T expireAt(@NonNull ArgType key, long unixSeconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixSeconds)));
        return this.getThis();
    }

    public <ArgType> T expireAt(@NonNull ArgType key, long unixSeconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixSeconds).add(expireOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T pexpire(@NonNull ArgType key, long milliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PExpire, ArgsBuilder.newArgsBuilder().add(key).add(milliseconds)));
        return this.getThis();
    }

    public <ArgType> T pexpire(@NonNull ArgType key, long milliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PExpire, ArgsBuilder.newArgsBuilder().add(key).add(milliseconds).add(expireOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T pexpireAt(@NonNull ArgType key, long unixMilliseconds) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixMilliseconds)));
        return this.getThis();
    }

    public <ArgType> T pexpireAt(@NonNull ArgType key, long unixMilliseconds, @NonNull ExpireOptions expireOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (expireOptions == null) {
            throw new NullPointerException("expireOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PExpireAt, ArgsBuilder.newArgsBuilder().add(key).add(unixMilliseconds).add(expireOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T ttl(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.TTL, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T expiretime(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ExpireTime, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T pexpiretime(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PExpireTime, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public T clientId() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ClientId));
        return this.getThis();
    }

    public T clientGetName() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ClientGetName));
        return this.getThis();
    }

    public T configRewrite() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ConfigRewrite));
        return this.getThis();
    }

    public T configResetStat() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ConfigResetStat));
        return this.getThis();
    }

    public <ArgType> T zadd(@NonNull ArgType key, @NonNull Map<ArgType, Double> membersScoresMap, @NonNull ZAddOptions options, boolean changed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        ArgsBuilder args = new ArgsBuilder();
        args.add(key).add(options.toArgs());
        if (changed) {
            args.add("CH");
        }
        args.add(ArrayTransformUtils.flattenMapToGlideStringArrayValueFirst(membersScoresMap));
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZAdd, args));
        return this.getThis();
    }

    public <ArgType> T zadd(@NonNull ArgType key, @NonNull Map<ArgType, Double> membersScoresMap, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, options, false);
    }

    public <ArgType> T zadd(@NonNull ArgType key, @NonNull Map<ArgType, Double> membersScoresMap, boolean changed) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), changed);
    }

    public <ArgType> T zadd(@NonNull ArgType key, @NonNull Map<ArgType, Double> membersScoresMap) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersScoresMap == null) {
            throw new NullPointerException("membersScoresMap is marked non-null but is null");
        }
        return this.zadd(key, membersScoresMap, ZAddOptions.builder().build(), false);
    }

    public <ArgType> T zaddIncr(@NonNull ArgType key, @NonNull ArgType member, double increment, @NonNull ZAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZAdd, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add("INCR").add(increment).add(member)));
        return this.getThis();
    }

    public <ArgType> T zaddIncr(@NonNull ArgType key, @NonNull ArgType member, double increment) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        return this.zaddIncr(key, member, increment, ZAddOptions.builder().build());
    }

    public <ArgType> T zrem(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRem, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T zcard(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZCard, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T zpopmin(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZPopMin, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T zpopmin(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZPopMin, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T zrandmember(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRandMember, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T zrandmemberWithCount(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRandMember, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T zrandmemberWithCountWithScores(ArgType key, long count) {
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRandMember, ArgsBuilder.newArgsBuilder().add(key).add(count).add("WITHSCORES")));
        return this.getThis();
    }

    public <ArgType> T zincrby(@NonNull ArgType key, double increment, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZIncrBy, ArgsBuilder.newArgsBuilder().add(key).add(increment).add(member)));
        return this.getThis();
    }

    public <ArgType> T bzpopmin(@NonNull ArgType[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BZPopMin, ArgsBuilder.newArgsBuilder().add(keys).add(timeout)));
        return this.getThis();
    }

    public <ArgType> T zpopmax(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZPopMax, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T zpopmax(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZPopMax, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T bzpopmax(@NonNull ArgType[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BZPopMax, ArgsBuilder.newArgsBuilder().add(keys).add(timeout)));
        return this.getThis();
    }

    public <ArgType> T zscore(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZScore, ArgsBuilder.newArgsBuilder().add(key).add(member)));
        return this.getThis();
    }

    public <ArgType> T zrank(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRank, ArgsBuilder.newArgsBuilder().add(key).add(member)));
        return this.getThis();
    }

    public <ArgType> T zrankWithScore(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRank, ArgsBuilder.newArgsBuilder().add(key).add(member).add("WITHSCORE")));
        return this.getThis();
    }

    public <ArgType> T zrevrank(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRevRank, ArgsBuilder.newArgsBuilder().add(key).add(member)));
        return this.getThis();
    }

    public <ArgType> T zrevrankWithScore(@NonNull ArgType key, @NonNull ArgType member) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member == null) {
            throw new NullPointerException("member is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRevRank, ArgsBuilder.newArgsBuilder().add(key).add(member).add("WITHSCORE")));
        return this.getThis();
    }

    public <ArgType> T zmscore(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZMScore, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T zdiff(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZDiff, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys)));
        return this.getThis();
    }

    public <ArgType> T zdiffWithScores(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZDiff, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add("WITHSCORES")));
        return this.getThis();
    }

    public <ArgType> T zdiffstore(@NonNull ArgType destination, @NonNull ArgType[] keys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZDiffStore, ArgsBuilder.newArgsBuilder().add(destination).add(keys.length).add(keys)));
        return this.getThis();
    }

    public <ArgType> T zcount(@NonNull ArgType key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZCount, ArgsBuilder.newArgsBuilder().add(key).add(minScore.toArgs()).add(maxScore.toArgs())));
        return this.getThis();
    }

    public <ArgType> T zremrangebyrank(@NonNull ArgType key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRemRangeByRank, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T zrangestore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRangeStore, ArgsBuilder.newArgsBuilder().add(destination).add(source).add(RangeOptions.createZRangeBaseArgs(rangeQuery, reverse, false))));
        return this.getThis();
    }

    public <ArgType> T zrangestore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        return ((BaseBatch)this.getThis()).zrangestore(destination, source, rangeQuery, false);
    }

    public <ArgType> T zremrangebylex(@NonNull ArgType key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRemRangeByLex, ArgsBuilder.newArgsBuilder().add(key).add(minLex.toArgs()).add(maxLex.toArgs())));
        return this.getThis();
    }

    public <ArgType> T zremrangebyscore(@NonNull ArgType key, @NonNull RangeOptions.ScoreRange minScore, @NonNull RangeOptions.ScoreRange maxScore) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minScore == null) {
            throw new NullPointerException("minScore is marked non-null but is null");
        }
        if (maxScore == null) {
            throw new NullPointerException("maxScore is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRemRangeByScore, ArgsBuilder.newArgsBuilder().add(key).add(minScore.toArgs()).add(maxScore.toArgs())));
        return this.getThis();
    }

    public <ArgType> T zlexcount(@NonNull ArgType key, @NonNull RangeOptions.LexRange minLex, @NonNull RangeOptions.LexRange maxLex) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (minLex == null) {
            throw new NullPointerException("minLex is marked non-null but is null");
        }
        if (maxLex == null) {
            throw new NullPointerException("maxLex is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZLexCount, ArgsBuilder.newArgsBuilder().add(key).add(minLex.toArgs()).add(maxLex.toArgs())));
        return this.getThis();
    }

    public T zunionstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnionStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs())));
        return this.getThis();
    }

    public T zunionstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnionStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs())));
        return this.getThis();
    }

    public T zunionstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnionStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs())));
        return this.getThis();
    }

    public T zunionstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnionStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs())));
        return this.getThis();
    }

    public T zinterstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs())));
        return this.getThis();
    }

    public T zinterstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs())));
        return this.getThis();
    }

    public <ArgType> T zintercard(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterCard, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys)));
        return this.getThis();
    }

    public <ArgType> T zintercard(@NonNull ArgType[] keys, long limit) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterCard, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add("LIMIT").add(limit)));
        return this.getThis();
    }

    public T zinterstore(@NonNull String destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs())));
        return this.getThis();
    }

    public T zinterstore(@NonNull GlideString destination, @NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInterStore, ArgsBuilder.newArgsBuilder().add(destination).add(keysOrWeightedKeys.toArgs())));
        return this.getThis();
    }

    public T zunion(@NonNull WeightAggregateOptions.KeyArray keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keys.toArgs())));
        return this.getThis();
    }

    public T zunion(@NonNull WeightAggregateOptions.KeyArrayBinary keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keys.toArgs())));
        return this.getThis();
    }

    public T zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zunionWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZUnion, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zinter(@NonNull WeightAggregateOptions.KeyArray keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keys.toArgs())));
        return this.getThis();
    }

    public T zinter(@NonNull WeightAggregateOptions.KeyArrayBinary keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keys.toArgs())));
        return this.getThis();
    }

    public T zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeys keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public T zinterWithScores(@NonNull WeightAggregateOptions.KeysOrWeightedKeysBinary keysOrWeightedKeys, @NonNull WeightAggregateOptions.Aggregate aggregate) {
        if (keysOrWeightedKeys == null) {
            throw new NullPointerException("keysOrWeightedKeys is marked non-null but is null");
        }
        if (aggregate == null) {
            throw new NullPointerException("aggregate is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZInter, ArgsBuilder.newArgsBuilder().add(keysOrWeightedKeys.toArgs()).add(aggregate.toArgs()).add("WITHSCORES")));
        return this.getThis();
    }

    public <ArgType> T xadd(@NonNull ArgType key, @NonNull Map<ArgType, ArgType> values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptions.builder().build());
    }

    public <ArgType> T xadd(@NonNull ArgType key, @NonNull ArgType[][] values) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        return this.xadd(key, values, StreamAddOptions.builder().build());
    }

    public <ArgType> T xadd(@NonNull ArgType key, @NonNull Map<ArgType, ArgType> values, @NonNull StreamAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAdd, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.flattenMapToGlideStringArray(values))));
        return this.getThis();
    }

    public <ArgType> T xadd(@NonNull ArgType key, @NonNull ArgType[][] values, @NonNull StreamAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAdd, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.flattenNestedArrayToGlideStringArray(values))));
        return this.getThis();
    }

    public <ArgType> T xread(@NonNull Map<ArgType, ArgType> keysAndIds) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        return this.xread(keysAndIds, (StreamReadOptions)StreamReadOptions.builder().build());
    }

    public <ArgType> T xread(@NonNull Map<ArgType, ArgType> keysAndIds, @NonNull StreamReadOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keysAndIds);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XRead, ArgsBuilder.newArgsBuilder().add(options.toArgs()).add(ArrayTransformUtils.flattenAllKeysFollowedByAllValues(keysAndIds))));
        return this.getThis();
    }

    public <ArgType> T xtrim(@NonNull ArgType key, @NonNull StreamTrimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XTrim, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T xlen(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XLen, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T xdel(@NonNull ArgType key, @NonNull ArgType[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XDel, ArgsBuilder.newArgsBuilder().add(key).add(ids)));
        return this.getThis();
    }

    public <ArgType> T xrange(@NonNull ArgType key, @NonNull StreamRange start, @NonNull StreamRange end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XRange, ArgsBuilder.newArgsBuilder().add(key).add(StreamRange.toArgs(start, end))));
        return this.getThis();
    }

    public <ArgType> T xrange(@NonNull ArgType key, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XRange, ArgsBuilder.newArgsBuilder().add(key).add(StreamRange.toArgs(start, end, count))));
        return this.getThis();
    }

    public <ArgType> T xrevrange(@NonNull ArgType key, @NonNull StreamRange end, @NonNull StreamRange start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XRevRange, ArgsBuilder.newArgsBuilder().add(key).add(StreamRange.toArgs(end, start))));
        return this.getThis();
    }

    public <ArgType> T xrevrange(@NonNull ArgType key, @NonNull StreamRange end, @NonNull StreamRange start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XRevRange, ArgsBuilder.newArgsBuilder().add(key).add(StreamRange.toArgs(end, start, count))));
        return this.getThis();
    }

    public <ArgType> T xgroupCreate(@NonNull ArgType key, @NonNull ArgType groupName, @NonNull ArgType id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupCreate, ArgsBuilder.newArgsBuilder().add(key).add(groupName).add(id)));
        return this.getThis();
    }

    public <ArgType> T xgroupCreate(@NonNull ArgType key, @NonNull ArgType groupName, @NonNull ArgType id, @NonNull StreamGroupOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupCreate, ArgsBuilder.newArgsBuilder().add(key).add(groupName).add(id).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T xgroupDestroy(@NonNull ArgType key, @NonNull ArgType groupName) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupDestroy, ArgsBuilder.newArgsBuilder().add(key).add(groupName)));
        return this.getThis();
    }

    public <ArgType> T xgroupCreateConsumer(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupCreateConsumer, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer)));
        return this.getThis();
    }

    public <ArgType> T xgroupDelConsumer(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupDelConsumer, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer)));
        return this.getThis();
    }

    public <ArgType> T xgroupSetId(@NonNull ArgType key, @NonNull ArgType groupName, @NonNull ArgType id) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupSetId, ArgsBuilder.newArgsBuilder().add(key).add(groupName).add(id)));
        return this.getThis();
    }

    public <ArgType> T xgroupSetId(@NonNull ArgType key, @NonNull ArgType groupName, @NonNull ArgType id, long entriesRead) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XGroupSetId, ArgsBuilder.newArgsBuilder().add(key).add(groupName).add(id).add("ENTRIESREAD").add(entriesRead)));
        return this.getThis();
    }

    public <ArgType> T xreadgroup(@NonNull Map<ArgType, ArgType> keysAndIds, @NonNull ArgType group, @NonNull ArgType consumer) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(group);
        return this.xreadgroup(keysAndIds, group, consumer, (StreamReadGroupOptions)StreamReadGroupOptions.builder().build());
    }

    public <ArgType> T xreadgroup(@NonNull Map<ArgType, ArgType> keysAndIds, @NonNull ArgType group, @NonNull ArgType consumer, @NonNull StreamReadGroupOptions options) {
        if (keysAndIds == null) {
            throw new NullPointerException("keysAndIds is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(group);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XReadGroup, ArgsBuilder.newArgsBuilder().add(options.toArgs(group, consumer)).add(ArrayTransformUtils.flattenAllKeysFollowedByAllValues(keysAndIds))));
        return this.getThis();
    }

    public <ArgType> T xack(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAck, ArgsBuilder.newArgsBuilder().add(key).add(group).add(ids)));
        return this.getThis();
    }

    public <ArgType> T xpending(@NonNull ArgType key, @NonNull ArgType group) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XPending, ArgsBuilder.newArgsBuilder().add(key).add(group)));
        return this.getThis();
    }

    public <ArgType> T xpending(@NonNull ArgType key, @NonNull ArgType group, @NonNull StreamRange start, @NonNull StreamRange end, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        return this.xpending(key, group, start, end, count, StreamPendingOptions.builder().build());
    }

    public <ArgType> T xpending(@NonNull ArgType key, @NonNull ArgType group, @NonNull StreamRange start, @NonNull StreamRange end, long count, @NonNull StreamPendingOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XPending, ArgsBuilder.newArgsBuilder().add(key).add(group).add(options.toArgs(start, end, count))));
        return this.getThis();
    }

    public <ArgType> T xinfoStream(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XInfoStream, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T xinfoStreamFull(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XInfoStream, ArgsBuilder.newArgsBuilder().add(key).add("FULL")));
        return this.getThis();
    }

    public <ArgType> T xinfoStreamFull(@NonNull ArgType key, int count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XInfoStream, ArgsBuilder.newArgsBuilder().add(key).add("FULL").add("COUNT").add(Integer.toString(count))));
        return this.getThis();
    }

    public <ArgType> T xclaim(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(ids)));
        return this.getThis();
    }

    public <ArgType> T xclaim(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(ids).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T xclaimJustId(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType[] ids) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(ids).add("JUSTID")));
        return this.getThis();
    }

    public <ArgType> T xclaimJustId(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType[] ids, @NonNull StreamClaimOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (ids == null) {
            throw new NullPointerException("ids is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(ids).add(options.toArgs()).add("JUSTID")));
        return this.getThis();
    }

    public <ArgType> T xinfoGroups(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XInfoGroups, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T xinfoConsumers(@NonNull ArgType key, @NonNull ArgType groupName) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (groupName == null) {
            throw new NullPointerException("groupName is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XInfoConsumers, ArgsBuilder.newArgsBuilder().add(key).add(groupName)));
        return this.getThis();
    }

    public <ArgType> T xautoclaim(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAutoClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(start)));
        return this.getThis();
    }

    public <ArgType> T xautoclaim(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAutoClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(start).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T xautoclaimJustId(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAutoClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(start).add("JUSTID")));
        return this.getThis();
    }

    public <ArgType> T xautoclaimJustId(@NonNull ArgType key, @NonNull ArgType group, @NonNull ArgType consumer, long minIdleTime, @NonNull ArgType start, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.XAutoClaim, ArgsBuilder.newArgsBuilder().add(key).add(group).add(consumer).add(minIdleTime).add(start).add("COUNT").add(count).add("JUSTID")));
        return this.getThis();
    }

    public <ArgType> T pttl(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PTTL, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T persist(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Persist, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public T time() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Time));
        return this.getThis();
    }

    public T lastsave() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LastSave));
        return this.getThis();
    }

    public T flushall() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FlushAll));
        return this.getThis();
    }

    public T flushall(FlushMode mode) {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FlushAll, ArgsBuilder.newArgsBuilder().add(mode)));
        return this.getThis();
    }

    public T flushdb() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FlushDB));
        return this.getThis();
    }

    public T flushdb(FlushMode mode) {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FlushDB, ArgsBuilder.newArgsBuilder().add(mode)));
        return this.getThis();
    }

    public T lolwut() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Lolwut));
        return this.getThis();
    }

    public T lolwut(int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Lolwut, ArgsBuilder.newArgsBuilder().add(parameters)));
        return this.getThis();
    }

    public T lolwut(int version) {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Lolwut, ArgsBuilder.newArgsBuilder().add("VERSION").add(version)));
        return this.getThis();
    }

    public T lolwut(int version, int @NonNull [] parameters) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Lolwut, ArgsBuilder.newArgsBuilder().add("VERSION").add(version).add(parameters)));
        return this.getThis();
    }

    public T dbsize() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.DBSize));
        return this.getThis();
    }

    public <ArgType> T type(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Type, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public T randomKey() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RandomKey));
        return this.getThis();
    }

    public <ArgType> T rename(@NonNull ArgType key, @NonNull ArgType newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Rename, ArgsBuilder.newArgsBuilder().add(key).add(newKey)));
        return this.getThis();
    }

    public <ArgType> T renamenx(@NonNull ArgType key, @NonNull ArgType newKey) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (newKey == null) {
            throw new NullPointerException("newKey is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RenameNX, ArgsBuilder.newArgsBuilder().add(key).add(newKey)));
        return this.getThis();
    }

    public <ArgType> T linsert(@NonNull ArgType key, @NonNull LInsertOptions.InsertPosition position, @NonNull ArgType pivot, @NonNull ArgType element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        if (pivot == null) {
            throw new NullPointerException("pivot is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LInsert, ArgsBuilder.newArgsBuilder().add(key).add(position).add(pivot).add(element)));
        return this.getThis();
    }

    public <ArgType> T brpop(@NonNull ArgType[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BRPop, ArgsBuilder.newArgsBuilder().add(keys).add(timeout)));
        return this.getThis();
    }

    public <ArgType> T lpushx(@NonNull ArgType key, @NonNull ArgType[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LPushX, ArgsBuilder.newArgsBuilder().add(key).add(elements)));
        return this.getThis();
    }

    public <ArgType> T rpushx(@NonNull ArgType key, @NonNull ArgType[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.RPushX, ArgsBuilder.newArgsBuilder().add(key).add(elements)));
        return this.getThis();
    }

    public <ArgType> T blpop(@NonNull ArgType[] keys, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BLPop, ArgsBuilder.newArgsBuilder().add(keys).add(timeout)));
        return this.getThis();
    }

    public <ArgType> T zrange(@NonNull ArgType key, @NonNull RangeOptions.RangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRange, ArgsBuilder.newArgsBuilder().add(key).add(RangeOptions.createZRangeBaseArgs(rangeQuery, reverse, false))));
        return this.getThis();
    }

    public <ArgType> T zrange(@NonNull ArgType key, @NonNull RangeOptions.RangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return ((BaseBatch)this.getThis()).zrange(key, rangeQuery, false);
    }

    public <ArgType> T zrangeWithScores(@NonNull ArgType key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery, boolean reverse) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZRange, ArgsBuilder.newArgsBuilder().add(key).add(RangeOptions.createZRangeBaseArgs(rangeQuery, reverse, true))));
        return this.getThis();
    }

    public <ArgType> T zrangeWithScores(@NonNull ArgType key, @NonNull RangeOptions.ScoredRangeQuery rangeQuery) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (rangeQuery == null) {
            throw new NullPointerException("rangeQuery is marked non-null but is null");
        }
        return this.zrangeWithScores(key, rangeQuery, false);
    }

    public <ArgType> T zmpop(@NonNull ArgType[] keys, @NonNull ScoreFilter modifier) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZMPop, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add(modifier)));
        return this.getThis();
    }

    public <ArgType> T zmpop(@NonNull ArgType[] keys, @NonNull ScoreFilter modifier, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZMPop, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add(modifier).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T bzmpop(@NonNull ArgType[] keys, @NonNull ScoreFilter modifier, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BZMPop, ArgsBuilder.newArgsBuilder().add(timeout).add(keys.length).add(keys).add(modifier)));
        return this.getThis();
    }

    public <ArgType> T bzmpop(@NonNull ArgType[] keys, @NonNull ScoreFilter modifier, double timeout, long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (modifier == null) {
            throw new NullPointerException("modifier is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BZMPop, ArgsBuilder.newArgsBuilder().add(timeout).add(keys.length).add(keys).add(modifier).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T pfadd(@NonNull ArgType key, @NonNull ArgType[] elements) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (elements == null) {
            throw new NullPointerException("elements is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PfAdd, ArgsBuilder.newArgsBuilder().add(key).add(elements)));
        return this.getThis();
    }

    public <ArgType> T pfcount(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PfCount, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T pfmerge(@NonNull ArgType destination, @NonNull ArgType[] sourceKeys) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sourceKeys == null) {
            throw new NullPointerException("sourceKeys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PfMerge, ArgsBuilder.newArgsBuilder().add(destination).add(sourceKeys)));
        return this.getThis();
    }

    public <ArgType> T objectEncoding(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ObjectEncoding, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T objectFreq(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ObjectFreq, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T objectIdletime(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ObjectIdleTime, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T objectRefcount(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ObjectRefCount, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T touch(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Touch, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T copy(@NonNull ArgType source, @NonNull ArgType destination, boolean replace) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(source);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Copy, ArgsBuilder.newArgsBuilder().add(source).add(destination).addIf("REPLACE", replace)));
        return this.getThis();
    }

    public <ArgType> T copy(@NonNull ArgType source, @NonNull ArgType destination) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        return this.copy(source, destination, false);
    }

    public <ArgType> T dump(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Dump, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T restore(@NonNull ArgType key, long ttl, @NonNull byte[] value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Restore, ArgsBuilder.newArgsBuilder().add(key).add(ttl).add(value)));
        return this.getThis();
    }

    public <ArgType> T restore(@NonNull ArgType key, long ttl, @NonNull byte[] value, @NonNull RestoreOptions restoreOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (restoreOptions == null) {
            throw new NullPointerException("restoreOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Restore, ArgsBuilder.newArgsBuilder().add(key).add(ttl).add(value).add(restoreOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T bitcount(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitCount, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T bitcount(@NonNull ArgType key, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitCount, ArgsBuilder.newArgsBuilder().add(key).add(start)));
        return this.getThis();
    }

    public <ArgType> T bitcount(@NonNull ArgType key, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitCount, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T bitcount(@NonNull ArgType key, long start, long end, @NonNull BitmapIndexType options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitCount, ArgsBuilder.newArgsBuilder().add(key).add(start).add(end).add(options)));
        return this.getThis();
    }

    public <ArgType> T geoadd(@NonNull ArgType key, @NonNull Map<ArgType, GeospatialData> membersToGeospatialData, @NonNull GeoAddOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoAdd, ArgsBuilder.newArgsBuilder().add(key).add(options.toArgs()).add(ArrayTransformUtils.mapGeoDataToGlideStringArray(membersToGeospatialData))));
        return this.getThis();
    }

    public <ArgType> T geoadd(@NonNull ArgType key, @NonNull Map<ArgType, GeospatialData> membersToGeospatialData) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (membersToGeospatialData == null) {
            throw new NullPointerException("membersToGeospatialData is marked non-null but is null");
        }
        return this.geoadd(key, membersToGeospatialData, new GeoAddOptions(false));
    }

    public <ArgType> T geopos(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoPos, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T geodist(@NonNull ArgType key, @NonNull ArgType member1, @NonNull ArgType member2, @NonNull GeoUnit geoUnit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        if (geoUnit == null) {
            throw new NullPointerException("geoUnit is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoDist, ArgsBuilder.newArgsBuilder().add(key).add(member1).add(member2).add(geoUnit.getValkeyAPI())));
        return this.getThis();
    }

    public <ArgType> T geodist(@NonNull ArgType key, @NonNull ArgType member1, @NonNull ArgType member2) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (member1 == null) {
            throw new NullPointerException("member1 is marked non-null but is null");
        }
        if (member2 == null) {
            throw new NullPointerException("member2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoDist, ArgsBuilder.newArgsBuilder().add(key).add(member1).add(member2)));
        return this.getThis();
    }

    public <ArgType> T geohash(@NonNull ArgType key, @NonNull ArgType[] members) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (members == null) {
            throw new NullPointerException("members is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoHash, ArgsBuilder.newArgsBuilder().add(key).add(members)));
        return this.getThis();
    }

    public <ArgType> T functionLoad(@NonNull ArgType libraryCode, boolean replace) {
        if (libraryCode == null) {
            throw new NullPointerException("libraryCode is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(libraryCode);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionLoad, ArgsBuilder.newArgsBuilder().addIf(FunctionLoadOptions.REPLACE, replace).add(libraryCode)));
        return this.getThis();
    }

    public T functionList(boolean withCode) {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionList, ArgsBuilder.newArgsBuilder().addIf("WITHCODE", withCode)));
        return this.getThis();
    }

    public <ArgType> T functionList(@NonNull ArgType libNamePattern, boolean withCode) {
        if (libNamePattern == null) {
            throw new NullPointerException("libNamePattern is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(libNamePattern);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionList, ArgsBuilder.newArgsBuilder().add("LIBRARYNAME").add(libNamePattern).addIf("WITHCODE", withCode)));
        return this.getThis();
    }

    public <ArgType> T fcall(@NonNull ArgType function, @NonNull ArgType[] keys, @NonNull ArgType[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(function);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FCall, ArgsBuilder.newArgsBuilder().add(function).add(keys.length).add(keys).add(arguments)));
        return this.getThis();
    }

    public <ArgType> T fcall(@NonNull ArgType function, @NonNull ArgType[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return this.fcall(function, this.createArray(new Object[0]), arguments);
    }

    public <ArgType> T fcallReadOnly(@NonNull ArgType function, @NonNull ArgType[] keys, @NonNull ArgType[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(function);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FCallReadOnly, ArgsBuilder.newArgsBuilder().add(function).add(keys.length).add(keys).add(arguments)));
        return this.getThis();
    }

    public <ArgType> T fcallReadOnly(@NonNull ArgType function, @NonNull ArgType[] arguments) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments is marked non-null but is null");
        }
        return this.fcallReadOnly(function, this.createArray(new Object[0]), arguments);
    }

    public T functionStats() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionStats));
        return this.getThis();
    }

    public T functionDump() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionDump));
        return this.getThis();
    }

    public T functionRestore(@NonNull byte[] payload) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionRestore, ArgsBuilder.newArgsBuilder().add(payload)));
        return this.getThis();
    }

    public T functionRestore(@NonNull byte[] payload, @NonNull FunctionRestorePolicy policy) {
        if (payload == null) {
            throw new NullPointerException("payload is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionRestore, ArgsBuilder.newArgsBuilder().add(payload).add(policy)));
        return this.getThis();
    }

    public <ArgType> T setbit(@NonNull ArgType key, long offset, long value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SetBit, ArgsBuilder.newArgsBuilder().add(key).add(offset).add(value)));
        return this.getThis();
    }

    public <ArgType> T getbit(@NonNull ArgType key, long offset) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GetBit, ArgsBuilder.newArgsBuilder().add(key).add(offset)));
        return this.getThis();
    }

    public <ArgType> T blmpop(@NonNull ArgType[] keys, @NonNull ListDirection direction, @NonNull Long count, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        if (count == null) {
            throw new NullPointerException("count is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BLMPop, ArgsBuilder.newArgsBuilder().add(timeout).add(keys.length).add(keys).add(direction).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T blmpop(@NonNull ArgType[] keys, @NonNull ListDirection direction, double timeout) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BLMPop, ArgsBuilder.newArgsBuilder().add(timeout).add(keys.length).add(keys).add(direction)));
        return this.getThis();
    }

    public <ArgType> T bitpos(@NonNull ArgType key, long bit) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitPos, ArgsBuilder.newArgsBuilder().add(key).add(bit)));
        return this.getThis();
    }

    public <ArgType> T bitpos(@NonNull ArgType key, long bit, long start) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitPos, ArgsBuilder.newArgsBuilder().add(key).add(bit).add(start)));
        return this.getThis();
    }

    public <ArgType> T bitpos(@NonNull ArgType key, long bit, long start, long end) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitPos, ArgsBuilder.newArgsBuilder().add(key).add(bit).add(start).add(end)));
        return this.getThis();
    }

    public <ArgType> T bitpos(@NonNull ArgType key, long bit, long start, long end, @NonNull BitmapIndexType offsetType) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (offsetType == null) {
            throw new NullPointerException("offsetType is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitPos, ArgsBuilder.newArgsBuilder().add(key).add(bit).add(start).add(end).add(offsetType)));
        return this.getThis();
    }

    public <ArgType> T bitop(@NonNull BitwiseOperation bitwiseOperation, @NonNull ArgType destination, @NonNull ArgType[] keys) {
        if (bitwiseOperation == null) {
            throw new NullPointerException("bitwiseOperation is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitOp, ArgsBuilder.newArgsBuilder().add(bitwiseOperation).add(destination).add(keys)));
        return this.getThis();
    }

    public <ArgType> T lmpop(@NonNull ArgType[] keys, @NonNull ListDirection direction, @NonNull Long count) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        if (count == null) {
            throw new NullPointerException("count is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LMPop, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add(direction).add("COUNT").add(count)));
        return this.getThis();
    }

    public <ArgType> T lmpop(@NonNull ArgType[] keys, @NonNull ListDirection direction) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LMPop, ArgsBuilder.newArgsBuilder().add(keys.length).add(keys).add(direction)));
        return this.getThis();
    }

    public <ArgType> T lset(@NonNull ArgType key, long index, @NonNull ArgType element) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LSet, ArgsBuilder.newArgsBuilder().add(key).add(index).add(element)));
        return this.getThis();
    }

    public <ArgType> T lmove(@NonNull ArgType source, @NonNull ArgType destination, @NonNull ListDirection whereFrom, @NonNull ListDirection whereTo) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (whereFrom == null) {
            throw new NullPointerException("whereFrom is marked non-null but is null");
        }
        if (whereTo == null) {
            throw new NullPointerException("whereTo is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(source);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LMove, ArgsBuilder.newArgsBuilder().add(source).add(destination).add(whereFrom).add(whereTo)));
        return this.getThis();
    }

    public <ArgType> T blmove(@NonNull ArgType source, @NonNull ArgType destination, @NonNull ListDirection whereFrom, @NonNull ListDirection whereTo, double timeout) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (whereFrom == null) {
            throw new NullPointerException("whereFrom is marked non-null but is null");
        }
        if (whereTo == null) {
            throw new NullPointerException("whereTo is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(source);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BLMove, ArgsBuilder.newArgsBuilder().add(source).add(destination).add(whereFrom).add(whereTo).add(timeout)));
        return this.getThis();
    }

    public <ArgType> T srandmember(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SRandMember, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T srandmember(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SRandMember, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T spop(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SPop, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T spopCount(@NonNull ArgType key, long count) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SPop, ArgsBuilder.newArgsBuilder().add(key).add(count)));
        return this.getThis();
    }

    public <ArgType> T bitfield(@NonNull ArgType key, @NonNull BitFieldOptions.BitFieldSubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitField, ArgsBuilder.newArgsBuilder().add(key).add(BitFieldOptions.createBitFieldArgs(subCommands))));
        return this.getThis();
    }

    public <ArgType> T bitfieldReadOnly(@NonNull ArgType key, @NonNull BitFieldOptions.BitFieldReadOnlySubCommands[] subCommands) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (subCommands == null) {
            throw new NullPointerException("subCommands is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.BitFieldReadOnly, ArgsBuilder.newArgsBuilder().add(key).add(BitFieldOptions.createBitFieldArgs(subCommands))));
        return this.getThis();
    }

    public T functionFlush() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionFlush));
        return this.getThis();
    }

    public T functionFlush(@NonNull FlushMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode is marked non-null but is null");
        }
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionFlush, ArgsBuilder.newArgsBuilder().add(mode)));
        return this.getThis();
    }

    public <ArgType> T functionDelete(@NonNull ArgType libName) {
        if (libName == null) {
            throw new NullPointerException("libName is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(libName);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.FunctionDelete, ArgsBuilder.newArgsBuilder().add(libName)));
        return this.getThis();
    }

    public <ArgType> T lcs(@NonNull ArgType key1, @NonNull ArgType key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2)));
        return this.getThis();
    }

    public <ArgType> T lcsLen(@NonNull ArgType key1, @NonNull ArgType key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2).add("LEN")));
        return this.getThis();
    }

    public <ArgType> T publish(@NonNull ArgType message, @NonNull ArgType channel) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(channel);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Publish, ArgsBuilder.newArgsBuilder().add(channel).add(message)));
        return this.getThis();
    }

    public T pubsubChannels() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PubSubChannels));
        return this.getThis();
    }

    public <ArgType> T pubsubChannels(@NonNull ArgType pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(pattern);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PubSubChannels, ArgsBuilder.newArgsBuilder().add(pattern)));
        return this.getThis();
    }

    public T pubsubNumPat() {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PubSubNumPat));
        return this.getThis();
    }

    public <ArgType> T pubsubNumSub(@NonNull ArgType[] channels) {
        if (channels == null) {
            throw new NullPointerException("channels is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(channels);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.PubSubNumSub, ArgsBuilder.newArgsBuilder().add(channels)));
        return this.getThis();
    }

    public <ArgType> T sunion(@NonNull ArgType[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(keys);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SUnion, ArgsBuilder.newArgsBuilder().add(keys)));
        return this.getThis();
    }

    public <ArgType> T lcsIdx(@NonNull ArgType key1, @NonNull ArgType key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2).add("IDX")));
        return this.getThis();
    }

    public <ArgType> T lcsIdx(@NonNull ArgType key1, @NonNull ArgType key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2).add("IDX").add("MINMATCHLEN").add(minMatchLen)));
        return this.getThis();
    }

    public <ArgType> T lcsIdxWithMatchLen(@NonNull ArgType key1, @NonNull ArgType key2) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2).add("IDX").add("WITHMATCHLEN")));
        return this.getThis();
    }

    public <ArgType> T lcsIdxWithMatchLen(@NonNull ArgType key1, @NonNull ArgType key2, long minMatchLen) {
        if (key1 == null) {
            throw new NullPointerException("key1 is marked non-null but is null");
        }
        if (key2 == null) {
            throw new NullPointerException("key2 is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key1);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.LCS, ArgsBuilder.newArgsBuilder().add(key1).add(key2).add("IDX").add("MINMATCHLEN").add(minMatchLen).add("WITHMATCHLEN")));
        return this.getThis();
    }

    public <ArgType> T sort(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Sort, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T sort(@NonNull ArgType key, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Sort, ArgsBuilder.newArgsBuilder().add(key).add(sortOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T sortReadOnly(@NonNull ArgType key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SortReadOnly, ArgsBuilder.newArgsBuilder().add(key)));
        return this.getThis();
    }

    public <ArgType> T sortReadOnly(@NonNull ArgType key, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SortReadOnly, ArgsBuilder.newArgsBuilder().add(key).add(sortOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T sortStore(@NonNull ArgType key, @NonNull ArgType destination) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Sort, ArgsBuilder.newArgsBuilder().add(key).add("STORE").add(destination)));
        return this.getThis();
    }

    public <ArgType> T sortStore(@NonNull ArgType key, @NonNull ArgType destination, @NonNull SortOptions sortOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (sortOptions == null) {
            throw new NullPointerException("sortOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Sort, ArgsBuilder.newArgsBuilder().add(key).add(sortOptions.toArgs()).add("STORE").add(destination)));
        return this.getThis();
    }

    public <ArgType> T geosearch(@NonNull ArgType key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearch, ArgsBuilder.newArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearch(@NonNull ArgType key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearch, ArgsBuilder.newArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(resultOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearch(@NonNull ArgType key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearch, ArgsBuilder.newArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearch(@NonNull ArgType key, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearch, ArgsBuilder.newArgsBuilder().add(key).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).add(resultOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearchstore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, ArgsBuilder.newArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearchstore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, ArgsBuilder.newArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(resultOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearchstore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, ArgsBuilder.newArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs())));
        return this.getThis();
    }

    public <ArgType> T geosearchstore(@NonNull ArgType destination, @NonNull ArgType source, @NonNull GeoSearchOrigin.SearchOrigin searchFrom, @NonNull GeoSearchShape searchBy, @NonNull GeoSearchStoreOptions options, @NonNull GeoSearchResultOptions resultOptions) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (searchFrom == null) {
            throw new NullPointerException("searchFrom is marked non-null but is null");
        }
        if (searchBy == null) {
            throw new NullPointerException("searchBy is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (resultOptions == null) {
            throw new NullPointerException("resultOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(destination);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.GeoSearchStore, ArgsBuilder.newArgsBuilder().add(destination).add(source).add(searchFrom.toArgs()).add(searchBy.toArgs()).add(options.toArgs()).add(resultOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T sscan(@NonNull ArgType key, @NonNull ArgType cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor)));
        return this.getThis();
    }

    public <ArgType> T sscan(@NonNull ArgType key, @NonNull ArgType cursor, @NonNull SScanOptions sScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (sScanOptions == null) {
            throw new NullPointerException("sScanOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.SScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor).add(sScanOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T zscan(@NonNull ArgType key, @NonNull ArgType cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor)));
        return this.getThis();
    }

    public <ArgType> T zscan(@NonNull ArgType key, @NonNull ArgType cursor, @NonNull ZScanOptions zScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (zScanOptions == null) {
            throw new NullPointerException("zScanOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.ZScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor).add(zScanOptions.toArgs())));
        return this.getThis();
    }

    public <ArgType> T hscan(@NonNull ArgType key, @NonNull ArgType cursor) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor)));
        return this.getThis();
    }

    public <ArgType> T hscan(@NonNull ArgType key, @NonNull ArgType cursor, @NonNull HScanOptions hScanOptions) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (cursor == null) {
            throw new NullPointerException("cursor is marked non-null but is null");
        }
        if (hScanOptions == null) {
            throw new NullPointerException("hScanOptions is marked non-null but is null");
        }
        ArgsBuilder.checkTypeOrThrow(key);
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.HScan, ArgsBuilder.newArgsBuilder().add(key).add(cursor).add(hScanOptions.toArgs())));
        return this.getThis();
    }

    public T wait(long numReplicas, long timeout) {
        this.protobufBatch.addCommands(this.buildCommand(CommandRequestOuterClass.RequestType.Wait, ArgsBuilder.newArgsBuilder().add(numReplicas).add(timeout)));
        return this.getThis();
    }

    protected CommandRequestOuterClass.Command buildCommand(CommandRequestOuterClass.RequestType requestType) {
        return this.buildCommand(requestType, this.emptyArgs());
    }

    protected CommandRequestOuterClass.Command buildCommand(CommandRequestOuterClass.RequestType requestType, CommandRequestOuterClass.Command.ArgsArray args) {
        return CommandRequestOuterClass.Command.newBuilder().setRequestType(requestType).setArgsArray(args).build();
    }

    protected CommandRequestOuterClass.Command buildCommand(CommandRequestOuterClass.RequestType requestType, ArgsBuilder argsBuilder) {
        CommandRequestOuterClass.Command.Builder builder = CommandRequestOuterClass.Command.newBuilder();
        builder.setRequestType(requestType);
        CommandManager.populateCommandWithArgs(argsBuilder.toArray(), builder);
        return builder.build();
    }

    protected CommandRequestOuterClass.Command.ArgsArray emptyArgs() {
        CommandRequestOuterClass.Command.ArgsArray.Builder commandArgs = CommandRequestOuterClass.Command.ArgsArray.newBuilder();
        return commandArgs.build();
    }

    @SafeVarargs
    protected final <ArgType> ArgType[] createArray(ArgType ... args) {
        return args;
    }

    @Generated
    public CommandRequestOuterClass.Batch.Builder getProtobufBatch() {
        return this.protobufBatch;
    }

    @Generated
    public boolean isBinaryOutput() {
        return this.binaryOutput;
    }
}

