/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

public class HGetExParams {
    private ExpiryType expirationType;
    private Long expirationValue;

    public static HGetExParams hGetExParams() {
        return new HGetExParams();
    }

    public HGetExParams ex(long seconds) {
        this.expirationType = ExpiryType.EX;
        this.expirationValue = seconds;
        return this;
    }

    public HGetExParams px(long milliseconds) {
        this.expirationType = ExpiryType.PX;
        this.expirationValue = milliseconds;
        return this;
    }

    public HGetExParams exAt(long unixTimeSeconds) {
        this.expirationType = ExpiryType.EXAT;
        this.expirationValue = unixTimeSeconds;
        return this;
    }

    public HGetExParams pxAt(long unixTimeMilliseconds) {
        this.expirationType = ExpiryType.PXAT;
        this.expirationValue = unixTimeMilliseconds;
        return this;
    }

    public HGetExParams persist() {
        this.expirationType = ExpiryType.PERSIST;
        this.expirationValue = null;
        return this;
    }

    public ExpiryType getExpirationType() {
        return this.expirationType;
    }

    public Long getExpirationValue() {
        return this.expirationValue;
    }

    public static enum ExpiryType {
        EX,
        PX,
        EXAT,
        PXAT,
        PERSIST;

    }
}

