/*
 * Decompiled with CFR 0.152.
 */
package glide.api.models;

import glide.api.models.GlideString;
import glide.ffi.resolvers.ScriptResolver;
import lombok.Generated;

public class Script
implements AutoCloseable {
    private final String hash;
    private boolean isDropped = false;
    private final Boolean binaryOutput;

    public <T> Script(T code, Boolean binaryOutput) {
        this.hash = ScriptResolver.storeScript(GlideString.of(code).getBytes());
        this.binaryOutput = binaryOutput;
    }

    @Override
    public void close() throws Exception {
        if (!this.isDropped) {
            ScriptResolver.dropScript(this.hash);
            this.isDropped = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Boolean getBinaryOutput() {
        return this.binaryOutput;
    }
}

