/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class SendResultFuture<T>
implements Future<Void>,
WebSocketCallback<T> {
    private boolean done;
    private Throwable exception;
    private int waiters;

    SendResultFuture() {
    }

    @Override
    public synchronized void complete(WebSocketChannel channel, T context) {
        if (this.done) {
            return;
        }
        if (this.waiters > 0) {
            this.notifyAll();
        }
        this.done = true;
    }

    @Override
    public synchronized void onError(WebSocketChannel channel, T context, Throwable throwable) {
        if (this.done) {
            return;
        }
        this.exception = throwable;
        this.done = true;
        if (this.waiters > 0) {
            this.notifyAll();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        SendResultFuture sendResultFuture = this;
        synchronized (sendResultFuture) {
            while (!this.done) {
                ++this.waiters;
                try {
                    this.wait();
                }
                finally {
                    --this.waiters;
                }
            }
        }
        return this.handleResult();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long timeoutNanos = unit.toNanos(timeout);
        long startTime = timeoutNanos <= 0L ? 0L : System.nanoTime();
        long waitTime = timeoutNanos;
        SendResultFuture sendResultFuture = this;
        synchronized (sendResultFuture) {
            if (this.done) {
                return this.handleResult();
            }
            if (waitTime <= 0L) {
                throw new TimeoutException();
            }
            ++this.waiters;
            try {
                while (true) {
                    this.wait(waitTime / 1000000L, (int)(waitTime % 1000000L));
                    if (this.done) {
                        Void void_ = this.handleResult();
                        return void_;
                    }
                    waitTime = timeoutNanos - (System.nanoTime() - startTime);
                    if (waitTime > 0L) continue;
                    if (this.done) {
                        Void void_ = this.handleResult();
                        return void_;
                    }
                    if (waitTime <= 0L) break;
                }
                throw new TimeoutException();
            }
            finally {
                --this.waiters;
            }
        }
    }

    private Void handleResult() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return null;
    }
}

