/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.spec;

import io.undertow.server.session.Session;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import java.security.AccessController;
import javax.servlet.ServletContext;

class SecurityActions {
    SecurityActions() {
    }

    static ServletRequestContext currentServletRequestContext() {
        if (System.getSecurityManager() == null) {
            return ServletRequestContext.current();
        }
        return AccessController.doPrivileged(ServletRequestContext::current);
    }

    static HttpSessionImpl forSession(Session session, ServletContext servletContext, boolean newSession) {
        if (System.getSecurityManager() == null) {
            return HttpSessionImpl.forSession(session, servletContext, newSession);
        }
        return AccessController.doPrivileged(() -> HttpSessionImpl.forSession(session, servletContext, newSession));
    }

    static void setCurrentRequestContext(ServletRequestContext servletRequestContext) {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
        } else {
            AccessController.doPrivileged(() -> {
                ServletRequestContext.setCurrentRequestContext(servletRequestContext);
                return null;
            });
        }
    }

    static void clearCurrentServletAttachments() {
        if (System.getSecurityManager() == null) {
            ServletRequestContext.clearCurrentServletAttachments();
        } else {
            AccessController.doPrivileged(() -> {
                ServletRequestContext.clearCurrentServletAttachments();
                return null;
            });
        }
    }
}

