/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.io.Serializable;
import org.xnio.Messages;

public final class Property
implements Serializable {
    private static final long serialVersionUID = -4958518978461712277L;
    private final String key;
    private final String value;

    private Property(String key, String value) {
        if (key == null) {
            throw Messages.msg.nullParameter("key");
        }
        if (value == null) {
            throw Messages.msg.nullParameter("value");
        }
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "(" + this.key + "=>" + this.value + ")";
    }

    public int hashCode() {
        return this.key.hashCode() * 7 + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Property && this.equals((Property)obj);
    }

    public boolean equals(Property other) {
        return this.key.equals(other.key) && this.value.equals(other.value);
    }

    public static Property of(String key, String value) {
        return new Property(key, value);
    }
}

