/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.WebSocketFrameHeader;
import io.undertow.websockets.core.WebSocketFrameType;

final class DefaultWebSocketFrameHeader
implements WebSocketFrameHeader {
    private final WebSocketFrameHeader.FrameType type;
    private final int rsv;
    private final boolean last;

    public DefaultWebSocketFrameHeader(WebSocketFrameType type, int rsv, boolean last) {
        this.type = DefaultWebSocketFrameHeader.type(type);
        this.rsv = rsv;
        this.last = last;
    }

    private static WebSocketFrameHeader.FrameType type(WebSocketFrameType type) {
        switch (type) {
            case BINARY: {
                return WebSocketFrameHeader.FrameType.BINARY;
            }
            case TEXT: {
                return WebSocketFrameHeader.FrameType.TEXT;
            }
            case CONTINUATION: {
                return WebSocketFrameHeader.FrameType.CONTINUATION;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public WebSocketFrameHeader.FrameType getType() {
        return this.type;
    }

    @Override
    public int getRsv() {
        return this.rsv;
    }

    @Override
    public boolean isLastFragement() {
        return this.last;
    }
}

