/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.impl;

import io.undertow.websockets.api.CloseFrameSender;
import io.undertow.websockets.api.CloseReason;
import io.undertow.websockets.api.SendCallback;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.impl.AbstractSender;
import io.undertow.websockets.impl.DelegatingSendCallback;
import io.undertow.websockets.impl.PooledFreeupSendCallback;
import io.undertow.websockets.impl.StreamSinkChannelUtils;
import io.undertow.websockets.impl.WebSocketChannelSession;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.StreamSinkChannel;

final class DefaultCloseFrameSender
extends AbstractSender
implements CloseFrameSender {
    private final SendCallback closeCallback = new SendCallback(){

        @Override
        public void onCompletion() {
            IoUtils.safeClose((Closeable)DefaultCloseFrameSender.this.session.getChannel());
        }

        @Override
        public void onError(Throwable cause) {
            IoUtils.safeClose((Closeable)DefaultCloseFrameSender.this.session.getChannel());
        }
    };

    DefaultCloseFrameSender(WebSocketChannelSession session) {
        super(session);
    }

    @Override
    protected WebSocketFrameType type() {
        return WebSocketFrameType.CLOSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendClose(CloseReason reason, SendCallback callback) {
        Pooled<ByteBuffer> pooled = this.closeFrame(reason);
        boolean free = true;
        try {
            ByteBuffer payload = pooled.getResource();
            StreamSinkChannel sink = StreamSinkChannelUtils.applyAsyncSendTimeout(this.session, this.createSink(payload.remaining()));
            callback = callback == null ? new DelegatingSendCallback(new PooledFreeupSendCallback(pooled), this.closeCallback) : new DelegatingSendCallback(callback, new PooledFreeupSendCallback(pooled), this.closeCallback);
            StreamSinkChannelUtils.send(sink, payload, callback);
            free = false;
        }
        catch (IOException e) {
            StreamSinkChannelUtils.safeNotify(callback, e);
            IoUtils.safeClose((Closeable)this.session.getChannel());
        }
        finally {
            if (free) {
                pooled.free();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendClose(CloseReason reason) throws IOException {
        this.checkBlockingAllowed();
        Pooled<ByteBuffer> pooled = this.closeFrame(reason);
        try {
            ByteBuffer payload = pooled.getResource();
            StreamSinkChannel sink = this.createSink(payload.remaining());
            StreamSinkChannelUtils.send(sink, payload);
        }
        finally {
            IoUtils.safeClose((Closeable)this.session.getChannel());
            pooled.free();
        }
    }

    private Pooled<ByteBuffer> closeFrame(CloseReason reason) {
        if (reason == null) {
            return Buffers.EMPTY_POOLED_BYTE_BUFFER;
        }
        Pooled<ByteBuffer> pooled = this.session.getChannel().getBufferPool().allocate();
        ByteBuffer buffer = pooled.getResource();
        buffer.putShort((short)reason.getStatusCode());
        String reasonText = reason.getReasonText();
        if (reasonText != null) {
            buffer.put(reasonText.getBytes(WebSocketUtils.UTF_8));
        }
        buffer.flip();
        return pooled;
    }
}

