/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core.function;

import io.undertow.websockets.core.function.ChannelFunction;
import io.undertow.websockets.core.function.ChannelFunctionFileChannel;
import io.undertow.websockets.core.function.ChannelFunctionStreamSourceChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public class ChannelFunctionStreamSinkChannel
implements StreamSinkChannel {
    private final StreamSinkChannel channel;
    private final ChannelFunction[] functions;

    public ChannelFunctionStreamSinkChannel(StreamSinkChannel channel, ChannelFunction ... functions) {
        this.channel = channel;
        this.functions = functions;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.channel.getWriteSetter();
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.channel.getCloseSetter();
    }

    @Override
    public void suspendWrites() {
        this.channel.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.channel.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.channel.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        this.channel.wakeupWrites();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.channel.shutdownWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.channel.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.channel.awaitWritable(time, timeUnit);
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.channel.getWriteThread();
    }

    @Override
    public boolean flush() throws IOException {
        return this.channel.flush();
    }

    @Override
    public XnioWorker getWorker() {
        return this.channel.getWorker();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.channel.getIoThread();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.channel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.channel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IOException {
        return this.channel.setOption(option, value);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.channel.transferFrom(new ChannelFunctionFileChannel(src, this.functions), position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.channel.transferFrom(new ChannelFunctionStreamSourceChannel(source, this.functions), count, throughBuffer);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        for (int i = offset; i < length; ++i) {
            ByteBuffer src = srcs[i];
            this.beforeWriting(src);
        }
        return this.channel.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        for (ByteBuffer src : srcs) {
            this.beforeWriting(src);
        }
        return this.channel.write(srcs);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        this.beforeWriting(src);
        return this.channel.write(src);
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private void beforeWriting(ByteBuffer buffer) throws IOException {
        for (ChannelFunction func : this.functions) {
            int pos = buffer.position();
            func.beforeWrite(buffer, pos, buffer.limit() - pos);
        }
    }
}

