/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers.security;

import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.TransportGuaranteeType;
import io.undertow.servlet.api.WebResourceCollection;
import io.undertow.servlet.handlers.security.SecurityPathMatch;
import io.undertow.servlet.handlers.security.SingleConstraintMatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SecurityPathMatches {
    private final PathSecurityInformation defaultPathSecurityInformation;
    private final Map<String, PathSecurityInformation> exactPathRoleInformation;
    private final Map<String, PathSecurityInformation> prefixPathRoleInformation;
    private final Map<String, PathSecurityInformation> extensionRoleInformation;

    private SecurityPathMatches(PathSecurityInformation defaultPathSecurityInformation, Map<String, PathSecurityInformation> exactPathRoleInformation, Map<String, PathSecurityInformation> prefixPathRoleInformation, Map<String, PathSecurityInformation> extensionRoleInformation) {
        this.defaultPathSecurityInformation = defaultPathSecurityInformation;
        this.exactPathRoleInformation = exactPathRoleInformation;
        this.prefixPathRoleInformation = prefixPathRoleInformation;
        this.extensionRoleInformation = extensionRoleInformation;
    }

    public boolean isEmpty() {
        return this.defaultPathSecurityInformation.excludedMethodRoles.isEmpty() && this.defaultPathSecurityInformation.perMethodRequiredRoles.isEmpty() && this.defaultPathSecurityInformation.defaultRequiredRoles.isEmpty() && this.exactPathRoleInformation.isEmpty() && this.prefixPathRoleInformation.isEmpty() && this.extensionRoleInformation.isEmpty();
    }

    public SecurityPathMatch getSecurityInfo(String path, String method) {
        ArrayList<SingleConstraintMatch> constraintSet = new ArrayList<SingleConstraintMatch>();
        TransportGuaranteeType type = TransportGuaranteeType.NONE;
        type = this.handleMatch(method, this.defaultPathSecurityInformation, constraintSet, type);
        PathSecurityInformation match = this.exactPathRoleInformation.get(path);
        if (match != null) {
            type = this.handleMatch(method, match, constraintSet, type);
        }
        if ((match = this.prefixPathRoleInformation.get(path)) != null) {
            type = this.handleMatch(method, match, constraintSet, type);
        }
        int qsPos = -1;
        boolean extension = false;
        for (int i = path.length() - 1; i >= 0; --i) {
            String part;
            char c = path.charAt(i);
            if (c == '?') {
                part = path.substring(0, i);
                match = this.exactPathRoleInformation.get(part);
                if (match != null) {
                    type = this.handleMatch(method, match, constraintSet, type);
                }
                qsPos = i;
                extension = false;
                continue;
            }
            if (c == '/') {
                extension = true;
                part = path.substring(0, i);
                match = this.prefixPathRoleInformation.get(part);
                if (match == null) continue;
                type = this.handleMatch(method, match, constraintSet, type);
                continue;
            }
            if (c != '.' || extension) continue;
            extension = true;
            String ext = qsPos == -1 ? path.substring(i + 1, path.length()) : path.substring(i + 1, qsPos);
            match = this.extensionRoleInformation.get(ext);
            if (match == null) continue;
            type = this.handleMatch(method, match, constraintSet, type);
        }
        return new SecurityPathMatch(type, constraintSet);
    }

    private TransportGuaranteeType handleMatch(String method, PathSecurityInformation exact, List<SingleConstraintMatch> constraintSet, TransportGuaranteeType type) {
        List<SecurityInformation> roles = exact.defaultRequiredRoles;
        for (SecurityInformation role : roles) {
            type = this.transport(type, role.transportGuaranteeType);
            constraintSet.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
        }
        List<SecurityInformation> methodInfo = exact.perMethodRequiredRoles.get(method);
        if (methodInfo != null) {
            for (SecurityInformation role : methodInfo) {
                type = this.transport(type, role.transportGuaranteeType);
                constraintSet.add(new SingleConstraintMatch(role.emptyRoleSemantic, role.roles));
            }
        }
        for (ExcludedMethodRoles excluded : exact.excludedMethodRoles) {
            if (excluded.methods.contains(method)) continue;
            type = this.transport(type, excluded.securityInformation.transportGuaranteeType);
            constraintSet.add(new SingleConstraintMatch(excluded.securityInformation.emptyRoleSemantic, excluded.securityInformation.roles));
        }
        return type;
    }

    private TransportGuaranteeType transport(TransportGuaranteeType existing, TransportGuaranteeType other) {
        if (other.ordinal() > existing.ordinal()) {
            return other;
        }
        return existing;
    }

    public static Builder builder(DeploymentInfo deploymentInfo) {
        return new Builder(deploymentInfo);
    }

    private static final class SecurityInformation {
        final Set<String> roles;
        final TransportGuaranteeType transportGuaranteeType;
        final SecurityInfo.EmptyRoleSemantic emptyRoleSemantic;

        private SecurityInformation(Set<String> roles, TransportGuaranteeType transportGuaranteeType, SecurityInfo.EmptyRoleSemantic emptyRoleSemantic) {
            this.emptyRoleSemantic = emptyRoleSemantic;
            this.roles = new HashSet<String>(roles);
            this.transportGuaranteeType = transportGuaranteeType;
        }
    }

    private static final class ExcludedMethodRoles {
        final Set<String> methods;
        final SecurityInformation securityInformation;

        public ExcludedMethodRoles(Set<String> methods, SecurityInformation securityInformation) {
            this.methods = methods;
            this.securityInformation = securityInformation;
        }
    }

    private static class PathSecurityInformation {
        final List<SecurityInformation> defaultRequiredRoles = new ArrayList<SecurityInformation>();
        final Map<String, List<SecurityInformation>> perMethodRequiredRoles = new HashMap<String, List<SecurityInformation>>();
        final List<ExcludedMethodRoles> excludedMethodRoles = new ArrayList<ExcludedMethodRoles>();

        private PathSecurityInformation() {
        }
    }

    public static class Builder {
        private final DeploymentInfo deploymentInfo;
        private final PathSecurityInformation defaultPathSecurityInformation = new PathSecurityInformation();
        private final Map<String, PathSecurityInformation> exactPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> prefixPathRoleInformation = new HashMap<String, PathSecurityInformation>();
        private final Map<String, PathSecurityInformation> extensionRoleInformation = new HashMap<String, PathSecurityInformation>();

        private Builder(DeploymentInfo deploymentInfo) {
            this.deploymentInfo = deploymentInfo;
        }

        public void addSecurityConstraint(SecurityConstraint securityConstraint) {
            Set<String> roles = this.expandRolesAllowed(securityConstraint.getRolesAllowed());
            SecurityInformation securityInformation = new SecurityInformation(roles, securityConstraint.getTransportGuaranteeType(), securityConstraint.getEmptyRoleSemantic());
            for (WebResourceCollection webResources : securityConstraint.getWebResourceCollections()) {
                if (webResources.getUrlPatterns().isEmpty()) {
                    this.setupPathSecurityInformation(this.defaultPathSecurityInformation, securityInformation, webResources);
                }
                for (String pattern : webResources.getUrlPatterns()) {
                    PathSecurityInformation info;
                    String part;
                    if (pattern.endsWith("/*") || pattern.endsWith("/")) {
                        part = pattern.substring(0, pattern.lastIndexOf(47));
                        info = this.prefixPathRoleInformation.get(part);
                        if (info == null) {
                            info = new PathSecurityInformation();
                            this.prefixPathRoleInformation.put(part, info);
                        }
                        this.setupPathSecurityInformation(info, securityInformation, webResources);
                        continue;
                    }
                    if (pattern.startsWith("*.")) {
                        part = pattern.substring(2, pattern.length());
                        info = this.extensionRoleInformation.get(part);
                        if (info == null) {
                            info = new PathSecurityInformation();
                            this.extensionRoleInformation.put(part, info);
                        }
                        this.setupPathSecurityInformation(info, securityInformation, webResources);
                        continue;
                    }
                    PathSecurityInformation info2 = this.exactPathRoleInformation.get(pattern);
                    if (info2 == null) {
                        info2 = new PathSecurityInformation();
                        this.exactPathRoleInformation.put(pattern, info2);
                    }
                    this.setupPathSecurityInformation(info2, securityInformation, webResources);
                }
            }
        }

        private Set<String> expandRolesAllowed(Set<String> rolesAllowed) {
            HashSet<String> roles = new HashSet<String>(rolesAllowed);
            if (roles.contains("*")) {
                roles.remove("*");
                roles.addAll(this.deploymentInfo.getSecurityRoles());
            }
            return roles;
        }

        private void setupPathSecurityInformation(PathSecurityInformation info, SecurityInformation securityConstraint, WebResourceCollection webResources) {
            if (webResources.getHttpMethods().isEmpty() && webResources.getHttpMethodOmissions().isEmpty()) {
                info.defaultRequiredRoles.add(securityConstraint);
            } else if (!webResources.getHttpMethods().isEmpty()) {
                for (String method : webResources.getHttpMethods()) {
                    List<SecurityInformation> securityInformations = info.perMethodRequiredRoles.get(method);
                    if (securityInformations == null) {
                        securityInformations = new ArrayList<SecurityInformation>();
                        info.perMethodRequiredRoles.put(method, securityInformations);
                    }
                    securityInformations.add(securityConstraint);
                }
            } else if (!webResources.getHttpMethodOmissions().isEmpty()) {
                info.excludedMethodRoles.add(new ExcludedMethodRoles(webResources.getHttpMethodOmissions(), securityConstraint));
            }
        }

        public SecurityPathMatches build() {
            return new SecurityPathMatches(this.defaultPathSecurityInformation, this.exactPathRoleInformation, this.prefixPathRoleInformation, this.extensionRoleInformation);
        }
    }
}

