/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public abstract class DelegatingStreamSinkChannel<T extends DelegatingStreamSinkChannel>
implements StreamSinkChannel {
    protected final StreamSinkChannel delegate;
    protected final ChannelListener.SimpleSetter<T> writeSetter = new ChannelListener.SimpleSetter();
    protected final ChannelListener.SimpleSetter<T> closeSetter = new ChannelListener.SimpleSetter();

    public DelegatingStreamSinkChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
        delegate.getWriteSetter().set(ChannelListeners.delegatingChannelListener(this, this.writeSetter));
        delegate.getCloseSetter().set(ChannelListeners.delegatingChannelListener(this, this.closeSetter));
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.delegate.transferFrom(src, position, count);
    }

    @Override
    public XnioWorker getWorker() {
        return this.delegate.getWorker();
    }

    @Override
    public boolean isWriteResumed() {
        return this.delegate.isWriteResumed();
    }

    @Override
    public boolean flush() throws IOException {
        return this.delegate.flush();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.delegate.awaitWritable(time, timeUnit);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.delegate.write(srcs, offset, length);
    }

    @Override
    public void awaitWritable() throws IOException {
        this.delegate.awaitWritable();
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.delegate.setOption(option, value);
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public ChannelListener.Setter<? extends StreamSinkChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.delegate.supportsOption(option);
    }

    @Override
    public final long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public void resumeWrites() {
        this.delegate.resumeWrites();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.delegate.shutdownWrites();
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.delegate.transferFrom(source, count, throughBuffer);
    }

    @Override
    public XnioExecutor getWriteThread() {
        return this.delegate.getWriteThread();
    }

    @Override
    public void wakeupWrites() {
        this.delegate.wakeupWrites();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.delegate.getOption(option);
    }

    @Override
    public void suspendWrites() {
        this.delegate.suspendWrites();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.delegate.getIoThread();
    }
}

