package org.nuiton.topia.persistence.support;

/*-
 * #%L
 * ToPIA Extension :: persistence
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.TopiaEntity;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

/**
 * Created by tchemit on 19/09/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public interface TopiaUsageSupport {

    Map<Class<? extends TopiaEntity>, Long> countReverseCompositions(TopiaDaoSupplier topiaDaoSupplier, TopiaEntity entity, Predicate<Class<? extends TopiaEntity>> entityTypeFilter);

    Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findReverseCompositions(TopiaDaoSupplier topiaDaoSupplier, TopiaEntity entity, Predicate<Class<? extends TopiaEntity>> entityTypeFilter);

    Map<Class<? extends TopiaEntity>, Long> countReverseAssociations(TopiaDaoSupplier topiaDaoSupplier, TopiaEntity entity, Predicate<Class<? extends TopiaEntity>> entityTypeFilter);

    Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findReverseAssociations(TopiaDaoSupplier topiaDaoSupplier, TopiaEntity entity, Predicate<Class<? extends TopiaEntity>> entityTypeFilter);

}
