package org.nuiton.topia.persistence.script;

/*-
 * #%L
 * ToPIA Extension :: persistence
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;

/**
 * Created by tchemit on 14/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class TopiaSqlScript {

    protected Supplier<SqlScriptReader> location;
    protected Set<TopiaBlobsContainer> blobsContainers;

    protected TopiaSqlScript(Supplier<SqlScriptReader> location) {
        this.location = location;
    }

    public static TopiaSqlScript of(Path location) {
        try {
            return of(location.toUri().toURL());
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TopiaSqlScript of(URI location) {
        try {
            return of(location.toURL());
        } catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static TopiaSqlScript of(byte... location) {
        return new TopiaSqlScript(() -> SqlScriptReader.of(location));
    }
    public static TopiaSqlScript of(String location) {
        return new TopiaSqlScript(() -> SqlScriptReader.of(location));
    }

    public static TopiaSqlScript of(URL location) {
        return new TopiaSqlScript(() -> SqlScriptReader.of(location));
    }

    public TopiaSqlScript addBlobsContainer(TopiaBlobsContainer blobsContainer) {
        getBlobsContainers().add(blobsContainer);
        return this;
    }

    public TopiaSqlScript addBlobsContainers(Collection<TopiaBlobsContainer> blobsContainers) {
        getBlobsContainers().addAll(blobsContainers);
        return this;
    }

    public Set<TopiaBlobsContainer> getBlobsContainers() {
        return blobsContainers == null ? blobsContainers = new LinkedHashSet<>() : blobsContainers;
    }

    public SqlScriptReader getLocation() {
        return location.get();
    }

    public void setLocation(Supplier<SqlScriptReader> location) {
        this.location = location;
    }

    public void copy(Path target) throws IOException {
        try (SqlScriptWriter scriptWriter = SqlScriptWriter.of(target)) {
            copy(scriptWriter);
        }
    }

    public void copy(OutputStream target) throws IOException {
        try (SqlScriptWriter scriptWriter = SqlScriptWriter.of(target)) {
            copy(scriptWriter);
        }
    }

    public void copy(SqlScriptWriter scriptWriter) throws IOException {
            try (SqlScriptReader scriptReader = location.get()) {
                for (String statement : scriptReader) {
                    scriptWriter.writeSql(statement);
                }
            }
    }

    public boolean withBlobs() {
        return blobsContainers != null && blobsContainers.size() > 1;
    }
}
