package org.nuiton.topia.persistence.metadata;

/*
 * #%L
 * ToPIA Extension :: persistence
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Represents an entity link to another entity.
 * <p>
 * Created by tchemit on 19/09/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public abstract class TopiaMetadataLink {

    private final TopiaMetadataEntity owner;
    private final String targetPropertyName;
    private final TopiaMetadataEntity target;

    TopiaMetadataLink(TopiaMetadataEntity owner, String targetPropertyName, TopiaMetadataEntity target) {
        this.owner = owner;
        this.targetPropertyName = targetPropertyName;
        this.target = target;
    }

    public abstract String getTableName();

    public abstract String getTargetDbName();

    public TopiaMetadataEntity getOwner() {
        return owner;
    }

    public String getTargetPropertyName() {
        return targetPropertyName;
    }

    public TopiaMetadataEntity getTarget() {
        return target;
    }
}
