package org.nuiton.topia.persistence.jdbc;

/*-
 * #%L
 * ToPIA Extension :: persistence
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

/**
 * FIXME: Merge this method with JdbcH2Helper.
 * Created by tchemit on 14/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class JdbcH2Helper2 extends JdbcH2Helper {

    public JdbcH2Helper2(JdbcConfiguration jdbcConfiguration) {
        super(jdbcConfiguration);
    }

    @Override
    public void restore(File file) {
        String options = "";
        try (InputStream in = new BufferedInputStream(new FileInputStream(file))) {
            in.mark(2);
            // read header to see if is compressed file
            int b = in.read();
            // redundant cast : int magic = ((int) in.read() << 8) | b;
            int magic = in.read() << 8 | b;
            in.reset();
            if (magic == GZIPInputStream.GZIP_MAGIC) {
                options += " COMPRESSION GZIP";
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        options += " CHARSET 'UTF8'";
        runUpdate("RUNSCRIPT FROM '" + file.getAbsolutePath() + "'" + options);
    }
}
