package org.nuiton.topia.persistence.gson;

/*-
 * #%L
 * ToPIA Extension :: persistence
 * %%
 * Copyright (C) 2018 - 2019 Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.script.TopiaBlobsContainer;
import org.nuiton.topia.persistence.script.TopiaSqlScript;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Set;

/**
 * Created by tchemit on 17/05/2018.
 *
 * @author Tony Chemit - dev@tchemit.fr
 */
public class TopiaSqlScriptAdapter implements JsonDeserializer<TopiaSqlScript>, JsonSerializer<TopiaSqlScript> {

    public static final Type TYPE = new TypeToken<Set<TopiaBlobsContainer>>() {
    }.getType();

    @Override
    public TopiaSqlScript deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        byte[] location = context.deserialize(jsonObject.get("location"), byte[].class);
        Set<TopiaBlobsContainer> blobs = context.deserialize(jsonObject.get("blobs"), TYPE);
        TopiaSqlScript result = TopiaSqlScript.of(location);
        if (blobs != null) {
            result.addBlobsContainers(blobs);
        }
        return result;
    }

    @Override
    public JsonElement serialize(TopiaSqlScript src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject element = new JsonObject();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {
            src.copy(outputStream);
            element.add("location", context.serialize(outputStream.toByteArray()));
        } catch (IOException e) {
            throw new TopiaException(e);
        }
        if (src.withBlobs()) {
            element.add("blobs", context.serialize(src.getBlobsContainers(), TYPE));
        }
        return element;
    }
}

