package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.text.actions.NormalTextEditorReset;

public class NormalTextEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1TS09TQRQ+LX3QIgpKSNwRUcAot7rG+OAVxQpGWBC7cdo7bYfc3hlmzqW3MbJw4c4/4MKtG8N/IK5M3LjlP5jwEzxz+0RaHt6kk9tzv/PNdx7f9z+QNBruS11x/ECg9J0dFoaODnwUNe6sPdve3iju8BIuc1PSQqHU0HxicYgXYMTtxA2CU8gTU67JlLNMuRZTbknWlPS530O0kIeswYbHTZVzRJgbmFwyJrfZQS6EKtCtu/qq7nfXr08Pj2J8+UscIFQkP01l37sEQbfqRB7iwkW4nt9heyznMb9C4rTwK1TQqI0tecyYdVbju7AP6TykFNNEhjD/X+2J6CKqUCEMoaRz/l/pdeFWOBoHeYjOutQ15m3R64pLEK1UlJ9CSBQ58xHGrEzHSnea4+0ihpWWimtsnEA1C+xBaW44bgll/4934yOshEL6Js/LVO+EJQgdU6dcZ21LSm+RaYvMdBKSERHCjRPQxQCpMguZ6CCz2KkHYfIkM31ZFdxzW9waZgaNllbJ6a5Sd6qxAkkJKIwwPXiL7SK+IVRzBacHr6C9JgJ+PNjX3+rHR+29S5C4qfOyeixGS9AaiLDarjWXLkDh5V4xtVCAjOEeDTDy3+zZyjdbSFJPKsaj6Vom5zkzVWJLpo8Of0y++z0E8VXIepK5q8ziX0AGqzSnqvTcUD15Gom7Uh+mc4x+QwijRaldrl8z4SMnbyTLzKOxQkoqthvwbiBTJlpkRa8TC6mRs2c3sqP7YOP459fPdw7bzYxRGbcvktltaPItpITvCZ9HNm45tK9tR5ThgSu79utnSCAzDrdXu+WDW9E5c6pRCYSbZVkKzJZme1wb5r3kDbPi23ac3TSb1Ns0hDRvp42+F22OubsfwsDe7UTNsW8PoO0xdY662OVIe+x4AeaUxxqSTA1XH7k0/6mi8F2y7uNTzDF7ZonxL/s2n7KbBgAA";
    private static final Logger log = LogManager.getLogger(NormalTextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected Object bean;
    protected NormalTextEditorHandler handler;
    protected String property;
    protected JButton reset;
    protected String resetTip;
    protected JTextField textEditor;
    protected NormalTextEditor top;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public void setBean(Object bean) { this.bean = (JavaBean) bean; }
    
    public String getText() {
        String text = textEditor.getText();
        if (text == null || text.isEmpty()) {
            text = null;
        }
        return text;
    }
    
    public void setText(String text) {
        String oldValue = getText();
        if (!Objects.equals(text, oldValue)) {
            textEditor.setText(text);
            firePropertyChange("text", oldValue, text);
        }
    }
    
    public void reset() { setText(null); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public NormalTextEditor() {
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public NormalTextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public NormalTextEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public Object getBean() {
        return bean;
    }

    public NormalTextEditorHandler getHandler() {
        return handler;
    }

    public String getProperty() {
        return property;
    }

    public JButton getReset() {
        return reset;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JTextField getTextEditor() {
        return textEditor;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(reset, BorderLayout.CENTER);
    }

    protected void addChildrenToTop() {
        add(actionsLeft, BorderLayout.WEST);
        add(textEditor);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusTraversalKeysEnabled(false);
        reset.setOpaque(false);
        reset.setFocusable(false);
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JTextField());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new NormalTextEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createBean();
        createProperty();
        createResetTip();
        createActionsLeft();
        createReset();
        createTextEditor();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToActionsLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // late initializer
        
        NormalTextEditorReset.init(this, reset, NormalTextEditorReset.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
