package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.bean.JavaBean;
import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.text.actions.BigTextEditorReset;

public class BigTextEditor extends JPanel implements BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_LABEL = "label";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_RESET_TIP = "resetTip";
    public static final String PROPERTY_TITLE = "title";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_INFO_LABEL_TOOL_TIP_TEXT = "infoLabel.toolTipText";
    public static final String BINDING_RESET_ENABLED = "reset.enabled";
    public static final String BINDING_TEXT_EDITOR_ENABLED = "textEditor.enabled";
    public static final String BINDING_TITLE_LABEL_TEXT = "titleLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVyW4bRxAtUiQlUpa8ZPXFUeJFVJZhFgQ5yIgteYEXOjYixTCiS5ozTaqFVve4u8YcQYgPPuSWH8jBV18C/4ORU4BcctU/BPAnpHqGnCElUqQTAmyJNVWvXlVXvfn9HyhbA59q0/FUJFArb4fFsWcihWKXe3fWHj2639rhPl7n1jciRG0g/RSKUNyC+SCzWwRvq0lIjRSp4ZAaPaTGNb0basXVANBqE2oW9yS325wjQn1ssG9tYyPzXI3DyPRyjWQ9Ktdfv3xxUODXfysCxCHRX6SyP3kDgLzqUhOKIkA409xhT1hDMtUhckaoDhW04GzXJLP2O7bLH8NTmG1CJWSGwBA++0/tSeASqDhEmEFN58eHqXdF0OFoPeQxeuuis0l/bwT03IRhElxBKLU4UwinHEfP8fbSu8095kKjQ25wb8grrS73KqNAmRR3esAoWYvLQ8Y5wy3HTREesi86mhu+0VI+YIojvOeyxZ7tUiLvTv7E+VezsBpmVSG8MxTi6l0znDnP97OAE76W0a66xVlAVcGZoRCHLwe4Xkgtn7vfS+44N5DYVdx0FR5GafbL/jDzrgrV1pn94vDDeeaj0Mo2eZsm4u3hIrSW68wM5y4nPUR4a8h1PUK6e+dSD2mUL40bZVodL1+dfIoLWwQckRnh/PitdYv3PXmlK3d+/Mq5NInjs5dPzYvu64P+ns0TuaVJUQOSQkPfm0HhuJ1MlyxCIRv3WLi6BVXLJc1sojfLxzPf6HkSe2JxOhloh+TdYnab0MqzB6/+ePenv2egeBNqUrPgJnP+t6GK29T1bS2DOLxyNSF3ojtH5yn6ziAstLShiXrAhEJOWlBuM0mXBBUdsscRzw3VNsEia8nMFlMjl49vZMb75f3Xfz7/9eKrfjMLVMaFaSLzhpZ/hIpQUiieyFZPkUbK1HxoeRToXG5GCRCQ+Mz1B7W3PF8l5zdHGlUgFRlcwIeCdxG+3Fe8u5TuTX3DTfMP7k5IvVKdechkxOsdJxu0c/WVlZWf48gluJJ0wP23BkckJJzApUjyZ3SXhqbwNcIsV+5O6OYW9oW9kf6oj040IDqTkpQQzra1H9lNw55wY5m8y/f68MdOiQsanJI3o5hKxCR2dB0lVwvCpf1p+j6mG5kSTtHyWip2t31N752Sk0USQKThoVfC5hRU0iEZQyWX2Skqr0i2p0kzYfFyQAu51BIqoEzfHgEuuLM2BeKR0XaeOBrv7EQ8Z7bHIHzwvxE+mmY+hJ++VMZgLBPGv9LpQMY0CgAA";
    private static final Logger log = LogManager.getLogger(BigTextEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsLeft;
    protected Object bean;
    protected JPanel columnHeader;
    protected BigTextEditorHandler handler;
    protected JLabel infoLabel;
    protected String label;
    protected String property;
    protected JButton reset;
    protected String resetTip;
    protected JTextArea textEditor;
    protected JScrollPane textScrollPane;
    protected String title;
    protected JLabel titleLabel;
    protected BigTextEditor top;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init() { handler.init(this); }
    
    @Override
    public void setBean(Object bean) { this.bean = bean; }
    
    public String getText() {
        String text = textEditor.getText();
        if (text == null || text.isEmpty()) {
            text = null;
        }
        return text;
    }
    
    public void setText(String text) {
        String oldValue = getText();
        if (!Objects.equals(text, oldValue)) {
            textEditor.setText(text);
            firePropertyChange("text", oldValue, text);
        }
    }
    
    public void setTextFromEditor() {
       firePropertyChange("text", null, getText());
    }
    
    public void setInfoLabelTip(String infoLabelTip) {
      infoLabel.setToolTipText(infoLabelTip);
    }
    
    public void reset() { setText(null); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BigTextEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor() {
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public BigTextEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public BigTextEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__textScrollPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textEditor.requestFocus();
    }

    public void doFocusGained__on__top(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        textEditor.requestFocusInWindow();
    }

    public void doKeyReleased__on__textEditor(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTextFromEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsLeft() {
        return actionsLeft;
    }

    public Object getBean() {
        return bean;
    }

    public JPanel getColumnHeader() {
        return columnHeader;
    }

    public BigTextEditorHandler getHandler() {
        return handler;
    }

    public JLabel getInfoLabel() {
        return infoLabel;
    }

    public String getLabel() {
        return label;
    }

    public String getProperty() {
        return property;
    }

    public JButton getReset() {
        return reset;
    }

    public String getResetTip() {
        return resetTip;
    }

    public JTextArea getTextEditor() {
        return textEditor;
    }

    public JScrollPane getTextScrollPane() {
        return textScrollPane;
    }

    public String getTitle() {
        return title;
    }

    public JLabel getTitleLabel() {
        return titleLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setLabel(String label) {
        String oldValue = this.label;
        this.label = label;
        firePropertyChange(PROPERTY_LABEL, oldValue, label);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setResetTip(String resetTip) {
        String oldValue = this.resetTip;
        this.resetTip = resetTip;
        firePropertyChange(PROPERTY_RESET_TIP, oldValue, resetTip);
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = title;
        firePropertyChange(PROPERTY_TITLE, oldValue, title);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsLeft() {
        actionsLeft.add(reset);
    }

    protected void addChildrenToColumnHeader() {
        columnHeader.add($JPanel0, BorderLayout.WEST);
        columnHeader.add(actionsLeft, BorderLayout.EAST);
    }

    protected void addChildrenToTextScrollPane() {
        textScrollPane.getViewport().add(textEditor);
    }

    protected void addChildrenToTop() {
        add(textScrollPane, BorderLayout.CENTER);
    }

    protected void createActionsLeft() {
        $objectMap.put("actionsLeft", actionsLeft = new JToolBar());
        
        actionsLeft.setName("actionsLeft");
        actionsLeft.setBorderPainted(false);
        actionsLeft.setOpaque(false);
        actionsLeft.setFloatable(false);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createColumnHeader() {
        $objectMap.put("columnHeader", columnHeader = new JPanel());
        
        columnHeader.setName("columnHeader");
        columnHeader.setLayout(new BorderLayout());
    }

    protected void createInfoLabel() {
        $objectMap.put("infoLabel", infoLabel = new JLabel());
        
        infoLabel.setName("infoLabel");
    }

    protected void createLabel() {
        $objectMap.put("label", label = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = null);
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setFocusTraversalKeysEnabled(false);
        reset.setOpaque(false);
        reset.setFocusable(false);
    }

    protected void createResetTip() {
        $objectMap.put("resetTip", resetTip = I18n.t("jaxx.text.action.reset.tip"));
    }

    protected void createTextEditor() {
        $objectMap.put("textEditor", textEditor = new JTextArea());
        
        textEditor.setName("textEditor");
        textEditor.setColumns(15);
        textEditor.setLineWrap(true);
        textEditor.setWrapStyleWord(true);
        textEditor.setRows(5);
        textEditor.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__textEditor"));
    }

    protected void createTextScrollPane() {
        $objectMap.put("textScrollPane", textScrollPane = new JScrollPane());
        
        textScrollPane.setName("textScrollPane");
        textScrollPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__textScrollPane"));
    }

    protected void createTitle() {
        $objectMap.put("title", title = null);
    }

    protected void createTitleLabel() {
        $objectMap.put("titleLabel", titleLabel = new JLabel());
        
        titleLabel.setName("titleLabel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        top = this;
        handler = new BigTextEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("top", top);
        createBean();
        createProperty();
        createTitle();
        createLabel();
        createResetTip();
        createTextScrollPane();
        createTextEditor();
        createColumnHeader();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout(3, 3));
        createTitleLabel();
        createInfoLabel();
        createActionsLeft();
        createReset();
        // inline creation of top
        setName("top");
        setLayout(new BorderLayout());
        top.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__top"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TEXT_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                textEditor.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TITLE_LABEL_TEXT, true ,"title") {
        
            @Override
            public void processDataBinding() {
                titleLabel.setText(SwingUtil.getStringValue(getTitle()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_INFO_LABEL_TOOL_TIP_TEXT, true ,"label") {
        
            @Override
            public void processDataBinding() {
                infoLabel.setToolTipText(SwingUtil.getStringValue(getLabel()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                reset.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToTop();
        addChildrenToTextScrollPane();
        addChildrenToColumnHeader();
        // inline complete setup of $JPanel0
        $JPanel0.add(titleLabel, BorderLayout.WEST);
        $JPanel0.add(infoLabel, BorderLayout.CENTER);
        addChildrenToActionsLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 5 property setters
        textScrollPane.setColumnHeaderView(columnHeader);
        infoLabel.setIcon(SwingUtil.getUIManagerActionIcon("info"));// late initializer
        
        BigTextEditorReset.init(this, reset, BigTextEditorReset.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
