package org.nuiton.jaxx.widgets.text;

/*-
 * #%L
 * JAXX :: Widgets Text
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import io.ultreia.java4all.i18n.I18n;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.swing.SwingUtil;

public class UrlEditor extends NormalTextEditor {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_OPEN_LINK_TIP = "openLinkTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_OPEN_LINK_ENABLED = "openLink.enabled";
    public static final String BINDING_OPEN_LINK_TOOL_TIP_TEXT = "openLink.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1US09TQRj9WmihPATFmOjCkKBQotzGNcYHrwhWMFASYjdOe4d28PbOMPNdegmBhQt3/gEXbt0Y/gNxZeLGLf/BhJ/gN7ePW6Xgo4tJMzlz5nxnzrmff0DKaLgvdcXxA4HSd3ZYGDo68FHUuLPydGtrrbTDy7jATVkLhVJD45dIQrIIg2573yA4xTwx5RpMOcuUazLl5mVNSZ/7HUSzeRgwuO9xU+UcEbIXHi4bk9toI2dDFejmXV1Vd7vr27sHpwm+8CEJECqS30tj3/sHgnjq3jwkhYtwLb/D9ljOY36FxGnhV2igYbs37zFjVlmN78IR9OUhrZgmMoSZ/7InoouoQoUwhFJtam/RJRKNMPn7DHXhVjgaB3mIThuoVMSQRhiUivt54b8p0C0wavU6dganMUMMHGJlFNI366JSJe3XLTJ0TJ1AzkpBSm+OaQvNtE/0t6gRxn5BzwVI+ixqRJHv5zS3fKd3duJ3ji1PFCGlA9pGmLg4YjYl64Rq5GPi4nzYayLg2+Mj/al+dtoKRQ+JG//TqY780wspTUNrFFbbSCMRAQov94Kp2SJkDPeoPFE5pi5XvtFEknpScTV6F8vkPGOmSmypvtOTLzdef++B5BIMeJK5S8zilyGDVU2OSc8N1eMnkbihej+to3YkhOGS1C7XL5nwkVNwU9vMM2RvWiq2G/B4I7NNtMhKXnsvJCOnLjeyrft47ezrx/d3T1pmJmiMO39zMjY09QrSwveEz6OONevTtVODyvDAlXE3urUFKOH9raw2k30rWm+fM4rye3NblgNT0GyPa8O853zfLPrWjg7TBhqtWC5Ln7gD7c3Y0Hc105J1mkndQ5JCvStQN+kDckBFXYvbmJ0+ROjjrRsnDhqN3KQQGEeYVYmLNYX7WTplCbLT04dhYIeZjNy2/7LQ0UL1h4kTCL0imuPKQ5fefbwkfJcufHSONWHXMeL7CTxMdAkwBgAA";
    private static final Logger log = LogManager.getLogger(UrlEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToolBar actionsRight;
    protected JButton openLink;
    protected String openLinkTip;
    protected UrlEditor topUrlEditor;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public UrlEditor(LayoutManager param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
    }

    public UrlEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
    }

    public UrlEditor(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
    }

    public UrlEditor() {
        
    }

    public UrlEditor(JAXXContext param0) {
        super(param0);
    }

    public UrlEditor(boolean param0) {
        super(param0);
    }

    public UrlEditor(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openLink(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        SwingUtil.openLink(getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToolBar getActionsRight() {
        return actionsRight;
    }

    public JButton getOpenLink() {
        return openLink;
    }

    public String getOpenLinkTip() {
        return openLinkTip;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setOpenLinkTip(String openLinkTip) {
        String oldValue = this.openLinkTip;
        this.openLinkTip = openLinkTip;
        firePropertyChange(PROPERTY_OPEN_LINK_TIP, oldValue, openLinkTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionsRight() {
        actionsRight.add(openLink, BorderLayout.CENTER);
    }

    protected void addChildrenToTopUrlEditor() {
        add(actionsRight, BorderLayout.EAST);
    }

    protected void createActionsRight() {
        $objectMap.put("actionsRight", actionsRight = new JToolBar());
        
        actionsRight.setName("actionsRight");
        actionsRight.setBorderPainted(false);
        actionsRight.setOpaque(false);
        actionsRight.setFloatable(false);
    }

    protected void createOpenLink() {
        $objectMap.put("openLink", openLink = new JButton());
        
        openLink.setName("openLink");
        openLink.setFocusTraversalKeysEnabled(false);
        openLink.setOpaque(false);
        openLink.setFocusable(false);
        openLink.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openLink"));
    }

    protected void createOpenLinkTip() {
        $objectMap.put("openLinkTip", openLinkTip = I18n.t("jaxx.url.action.openLink.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        topUrlEditor = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("topUrlEditor", topUrlEditor);
        createOpenLinkTip();
        createActionsRight();
        createOpenLink();
        // inline creation of topUrlEditor
        setName("topUrlEditor");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_TOOL_TIP_TEXT, true ,"openLinkTip") {
        
            @Override
            public void processDataBinding() {
                openLink.setToolTipText(getOpenLinkTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_OPEN_LINK_ENABLED, true ,"text") {
        
            @Override
            public void processDataBinding() {
                openLink.setEnabled(StringUtils.isNotEmpty(getText()));
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        addChildrenToTopUrlEditor();
        addChildrenToActionsRight();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 1 property setters
        openLink.setIcon(SwingUtil.getUIManagerActionIcon("url-open"));
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}
