package org.nuiton.jaxx.widgets.select;

/*-
 * #%L
 * JAXX :: Widgets Select
 * %%
 * Copyright (C) 2008 - 2019 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.bean.BeanScopeAware;
import org.nuiton.jaxx.runtime.bean.BeanTypeAware;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.JAXXButtonGroup;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.model.JaxxFilterableComboBoxModel;
import org.nuiton.jaxx.widgets.select.actions.BeanFilterableComboBoxDisplayDecoratorAction;
import org.nuiton.jaxx.widgets.select.actions.BeanFilterableComboBoxResetAction;
import static io.ultreia.java4all.i18n.I18n.t;

public class BeanFilterableComboBox<O> extends Table implements BeanTypeAware<O>, BeanScopeAware, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_AUTO_FOCUS = "autoFocus";
    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_DATA = "data";
    public static final String PROPERTY_EDITABLE = "editable";
    public static final String PROPERTY_ENTER_TO_SELECT = "enterToSelect";
    public static final String PROPERTY_ENTER_TO_SELECT_UNIQUE_UNIVERSE = "enterToSelectUniqueUniverse";
    public static final String PROPERTY_FILTERABLE = "filterable";
    public static final String PROPERTY_I18N_PREFIX = "i18nPrefix";
    public static final String PROPERTY_INDEX = "index";
    public static final String PROPERTY_INVALID_COMBO_EDITOR_TEXT_COLOR = "invalidComboEditorTextColor";
    public static final String PROPERTY_MAXIMUM_ROW_COUNT = "maximumRowCount";
    public static final String PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT = "notSelectedToolTipText";
    public static final String PROPERTY_POPUP_TITLE_TEXT = "popupTitleText";
    public static final String PROPERTY_PROPERTY = "property";
    public static final String PROPERTY_REVERSE_SORT = "reverseSort";
    public static final String PROPERTY_SELECTED_ITEM = "selectedItem";
    public static final String PROPERTY_SELECTED_TOOL_TIP_TEXT = "selectedToolTipText";
    public static final String PROPERTY_SHOW_DECORATOR = "showDecorator";
    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SORTABLE = "sortable";
    public static final String PROPERTY_TAB_TO_SELECT = "tabToSelect";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBOBOX_EDITABLE = "combobox.editable";
    public static final String BINDING_COMBOBOX_ENABLED = "combobox.enabled";
    public static final String BINDING_COMBOBOX_FOCUSABLE = "combobox.focusable";
    public static final String BINDING_COMBOBOX_MAXIMUM_ROW_COUNT = "combobox.maximumRowCount";
    public static final String BINDING_COMBOBOX_SELECTED_ITEM = "combobox.selectedItem";
    public static final String BINDING_SORT_DOWN_SELECTED = "sortDown.selected";
    public static final String BINDING_SORT_GROUP_SELECTED_VALUE = "sortGroup.selectedValue";
    public static final String BINDING_SORT_UP_SELECTED = "sortUp.selected";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";
    public static final String BINDING_TOOLBAR_RIGHT_VISIBLE = "toolbarRight.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XT28TRxSfhDiJE5NAaZGqqpL5FxK1WYOqSrShUBKTEuoAjQ2izaEdeyf2oPXOsjMbO7Lg0ENv/QI99NpLxXdAPVXqpVe+Q/98hL43u97Z3axxKOSwit97897vvXnzfjO//kUK0icfCr9tuQFXwrUe0X7f8gNX8S6zbt94+PBu8xFrqSqTLZ97Svgk/JuYJJO7ZN6O5VIRa7cGniqhpwp6qkSeKhui6wmXuQlHazUyJ9WBw2SHMaXI8sjFLSkr9dhyre8FfhQrF3VerD9+uPxiglV/miSk7wH8C5D2B6/gwGQ9VSOT3Fbkrdojuk8rDnXbAM7nbhsSOo6yDYdKeYd22WPylMzUyLRHfXCmyOr/Ko92p131PUVmzjdo02GXFPk4C7/H7TZT0pLMgR2z1hl1N7mjmI8LIEJTrIu+52lf04rMNsGgceAxRRYRtoWpWDqaMZrbiz0octKYrQvhwHJjOO+zfeZLVhe+QtFJoyrKjujtMMmyiuOoqLKW8CkknFHOMpsrjJuVS4iQIy/SQIlN0QpkRvEelJX5DVHXZbnv8scBg69GmwWUMs0o5yHqCNWs5wuP+epAkROmRmFXGKspLHjKIjxbxqIUbh2ztxTromzF6ArctVk/tQlbgLbN/ESq3N2nDrf1Zt+E+gm/AWs2hAM1Iwt6Je0pSwsSwGyq6FAfKO5YNS4TsBa7tM+7QXdH9DYEdCyKLaOe0cgYDIDVUSdK9qASepysBwq0X/gi8JIdAvi0DAWfGMWpYUEa0G8N7mE2qFoyJqddoepjrRY84QVegyuH5Wjn+OUr7j2f7fF+RlPQ6yAK1qY/zOMeCreZG2QDYPfXaJM5MB9SK7QQTavximlM+j74Lqcsd6jNRVgljDDshGr6AFRFz8XftbQuQsFg4uCRyuKOFelVc3pVDHErrS2dN+suoeyrtH5eQdWb1K+xPZhxb6cC4oasUx2uaGrq4yyAzU2ZhimjyQOTagsbuSmg7d9JGQ+nWdpxKUKyw9sdvcUP0/oTNpeeQw/ikaPIuxm47bbDDJJvPaCJpVFNDbRkGVoyDDGxCykGDh6Ic6MZEUltB6xCOjs3ms4wjDb8/tlT/5fevy+GHLYA4MrjViXoGgglmlMcsS2GBIbnvbJNvbVdOIb6HGkuv/hy5PXIEtADipNmctyisgPeCjMvnv92+rs/j5HJTTLnCGpvUrTfIkXVgf3vCMfue9c/1+BKvVn4nkCY0MKBZIlzDNNJ+QHrQ40uvrxGMaRnd//9/ecfLzwf1mkCEJ4/ykpTq8I3ZJq7DneZZvuIyHPZfd6TLLCFYek83iZmSg7HHtff7qESTCIvRvPsAXUC5N0BlzuGXpdXnowuEzp9rJPG/yRJDtdxoaH6003h29Ah5KNB2WW9sp6Y9roWLqvls0hhw0Np6bFhKTQ5u7JSfpIXPRygR0h6DvqDC3erJYAjixhnFYFjYjq/RRRZKALyg0mVFywzhMdFLcDwaho+SpYqg6cU41lFXQSpZCChtLAfbtfMYI86kj3BUR1tJNDB4Ex2E/MyiEjhzSFfMMht4IwY+4LBHsqH6KcH2Ehp8IcbMA97TEzj0B+DFg/77B7lro5Q0CWD2u1zyfVlcxFi1ocXR93yxT2YIyq8iob2eSiSdHQEIMU9vDImnQII5qIAYL0PIG5G99DllfLSUhl+h0oNqaRXZ7LIRaU5L2SWcaiyF0FgygFc7OsJkQ4e35BhN1M4QVfoChtvIUsDPMW3YeIdfgpso8nVu9ei4po66KyHWUZJJ52b+hwfpOuRvSkqsjYoA/bttBi8nvms7AaOU76er/60fCV/nsRXgjfSZKeiJotvBK/QaKnbxjg0U/GxDF9cX495vIW2csQjrpq5x9zQ1lYLGWdcS589nPJr9PViqwMvERY7OwLFTPFwMF3FV0e5CbQId69rh5xP4PfWWH8o/hs//+R7+PK1PdwBD/8BCNKOZykRAAA=";
    private static final Logger log = LogManager.getLogger(BeanFilterableComboBox.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean autoFocus;
    protected Object bean;
    protected Class<O> beanType;
    protected JComboBox<O> combobox;
    protected List<O> data;
    protected JToggleButton displayDecorator;
    protected Boolean editable;
    protected Boolean enterToSelect;
    protected Boolean enterToSelectUniqueUniverse;
    protected Boolean filterable;
    protected BeanFilterableComboBoxHandler<O> handler;
    protected String i18nPrefix;
    protected Integer index;
    protected JAXXButtonGroup indexes;
    protected Color invalidComboEditorTextColor;
    protected Integer maximumRowCount;
    protected String notSelectedToolTipText;
    protected JPopupMenu popup;
    protected JLabel popupLabel;
    protected JSeparator popupSeparator;
    protected JLabel popupSortLabel;
    protected String popupTitleText;
    protected String property;
    protected JButton reset;
    protected Boolean reverseSort;
    protected Object selectedItem;
    protected String selectedToolTipText;
    protected Boolean showDecorator;
    protected Boolean showReset;
    protected JRadioButtonMenuItem sortDown;
    protected JAXXButtonGroup sortGroup;
    protected JRadioButtonMenuItem sortUp;
    protected Boolean sortable;
    protected Boolean tabToSelect;
    protected JToolBar toolbarLeft;
    protected JToolBar toolbarRight;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private BeanFilterableComboBox<O> $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_EMPTY = "empty";
    
    
    public void init(JXPathDecorator<O> decorator, List<O> data) {
        handler.init(decorator, data);
    }
    
    protected void hidePopup() {
        if (popup.isVisible()) {
            popup.setVisible(false);
        }
    }
    
    public boolean isEmpty() { return handler.isEmpty(); }
    
    public void addItem(O item) { handler.addItem(item); }
    
    public void addItems(Iterable<O> items) { handler.addItems(items); }
    
    public void removeItem(O item) { handler.removeItem(item); }
    
    public void removeItems(Iterable<O> items) { handler.removeItems(items); }
    
    public void reset() { handler.reset(); }
    
    public JaxxFilterableComboBoxModel<O> getComboBoxModel() { return (JaxxFilterableComboBoxModel<O>) combobox.getModel(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBox() {
        $initialize();
    }

    public BeanFilterableComboBox(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusGained__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.focusCombo();
    }

    public void doFocusLost__on__$Table0(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        hidePopup();
    }

    public void doPopupMenuCanceled__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(PopupMenuEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getDisplayDecorator().setSelected(false);
    }

    public void doStateChanged__on__indexes(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setIndex((Integer)indexes.getSelectedValue());
    }

    public void doStateChanged__on__sortGroup(ChangeEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setReverseSort((Boolean)sortGroup.getSelectedValue());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAutoFocus() {
        return autoFocus;
    }

    public Object getBean() {
        return bean;
    }

    public Class<O> getBeanType() {
        return beanType;
    }

    public JComboBox<O> getCombobox() {
        return combobox;
    }

    public List<O> getData() {
        return data;
    }

    public JToggleButton getDisplayDecorator() {
        return displayDecorator;
    }

    public Boolean getEditable() {
        return editable;
    }

    public Boolean getEnterToSelect() {
        return enterToSelect;
    }

    public Boolean getEnterToSelectUniqueUniverse() {
        return enterToSelectUniqueUniverse;
    }

    public Boolean getFilterable() {
        return filterable;
    }

    public BeanFilterableComboBoxHandler<O> getHandler() {
        return handler;
    }

    public String getI18nPrefix() {
        return i18nPrefix;
    }

    public Integer getIndex() {
        return index;
    }

    public JAXXButtonGroup getIndexes() {
        return indexes;
    }

    public Color getInvalidComboEditorTextColor() {
        return invalidComboEditorTextColor;
    }

    public Integer getMaximumRowCount() {
        return maximumRowCount;
    }

    public String getNotSelectedToolTipText() {
        return notSelectedToolTipText;
    }

    public JPopupMenu getPopup() {
        return popup;
    }

    public JLabel getPopupLabel() {
        return popupLabel;
    }

    public JSeparator getPopupSeparator() {
        return popupSeparator;
    }

    public JLabel getPopupSortLabel() {
        return popupSortLabel;
    }

    public String getPopupTitleText() {
        return popupTitleText;
    }

    public String getProperty() {
        return property;
    }

    public JButton getReset() {
        return reset;
    }

    public Boolean getReverseSort() {
        return reverseSort;
    }

    public Object getSelectedItem() {
        return selectedItem;
    }

    public String getSelectedToolTipText() {
        return selectedToolTipText;
    }

    public Boolean getShowDecorator() {
        return showDecorator;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public JRadioButtonMenuItem getSortDown() {
        return sortDown;
    }

    public JAXXButtonGroup getSortGroup() {
        return sortGroup;
    }

    public JRadioButtonMenuItem getSortUp() {
        return sortUp;
    }

    public Boolean getSortable() {
        return sortable;
    }

    public Boolean getTabToSelect() {
        return tabToSelect;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public JToolBar getToolbarRight() {
        return toolbarRight;
    }

    public Boolean isAutoFocus() {
        return autoFocus !=null && autoFocus;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    public Boolean isEnterToSelect() {
        return enterToSelect !=null && enterToSelect;
    }

    public Boolean isEnterToSelectUniqueUniverse() {
        return enterToSelectUniqueUniverse !=null && enterToSelectUniqueUniverse;
    }

    public Boolean isFilterable() {
        return filterable !=null && filterable;
    }

    public Boolean isReverseSort() {
        return reverseSort !=null && reverseSort;
    }

    public Boolean isShowDecorator() {
        return showDecorator !=null && showDecorator;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    public Boolean isSortable() {
        return sortable !=null && sortable;
    }

    public Boolean isTabToSelect() {
        return tabToSelect !=null && tabToSelect;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAutoFocus(Boolean autoFocus) {
        Boolean oldValue = this.autoFocus;
        this.autoFocus = autoFocus;
        firePropertyChange(PROPERTY_AUTO_FOCUS, oldValue, autoFocus);
    }

    public void setBean(Object bean) {
        Object oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setBeanType(Class<O> beanType) {
        Class<O> oldValue = this.beanType;
        this.beanType = beanType;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, beanType);
    }

    public void setData(List<O> data) {
        List<O> oldValue = this.data;
        this.data = data;
        firePropertyChange(PROPERTY_DATA, oldValue, data);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public void setEnterToSelect(Boolean enterToSelect) {
        Boolean oldValue = this.enterToSelect;
        this.enterToSelect = enterToSelect;
        firePropertyChange(PROPERTY_ENTER_TO_SELECT, oldValue, enterToSelect);
    }

    public void setEnterToSelectUniqueUniverse(Boolean enterToSelectUniqueUniverse) {
        Boolean oldValue = this.enterToSelectUniqueUniverse;
        this.enterToSelectUniqueUniverse = enterToSelectUniqueUniverse;
        firePropertyChange(PROPERTY_ENTER_TO_SELECT_UNIQUE_UNIVERSE, oldValue, enterToSelectUniqueUniverse);
    }

    public void setFilterable(Boolean filterable) {
        Boolean oldValue = this.filterable;
        this.filterable = filterable;
        firePropertyChange(PROPERTY_FILTERABLE, oldValue, filterable);
    }

    public void setI18nPrefix(String i18nPrefix) {
        String oldValue = this.i18nPrefix;
        this.i18nPrefix = i18nPrefix;
        firePropertyChange(PROPERTY_I18N_PREFIX, oldValue, i18nPrefix);
    }

    public void setIndex(Integer index) {
        Integer oldValue = this.index;
        this.index = index;
        firePropertyChange(PROPERTY_INDEX, oldValue, index);
    }

    public void setInvalidComboEditorTextColor(Color invalidComboEditorTextColor) {
        Color oldValue = this.invalidComboEditorTextColor;
        this.invalidComboEditorTextColor = invalidComboEditorTextColor;
        firePropertyChange(PROPERTY_INVALID_COMBO_EDITOR_TEXT_COLOR, oldValue, invalidComboEditorTextColor);
    }

    public void setMaximumRowCount(Integer maximumRowCount) {
        Integer oldValue = this.maximumRowCount;
        this.maximumRowCount = maximumRowCount;
        firePropertyChange(PROPERTY_MAXIMUM_ROW_COUNT, oldValue, maximumRowCount);
    }

    public void setNotSelectedToolTipText(String notSelectedToolTipText) {
        String oldValue = this.notSelectedToolTipText;
        this.notSelectedToolTipText = notSelectedToolTipText;
        firePropertyChange(PROPERTY_NOT_SELECTED_TOOL_TIP_TEXT, oldValue, notSelectedToolTipText);
    }

    public void setPopupTitleText(String popupTitleText) {
        String oldValue = this.popupTitleText;
        this.popupTitleText = popupTitleText;
        firePropertyChange(PROPERTY_POPUP_TITLE_TEXT, oldValue, popupTitleText);
    }

    public void setProperty(String property) {
        String oldValue = this.property;
        this.property = property;
        firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
    }

    public void setReverseSort(Boolean reverseSort) {
        Boolean oldValue = this.reverseSort;
        this.reverseSort = reverseSort;
        firePropertyChange(PROPERTY_REVERSE_SORT, oldValue, reverseSort);
    }

    public void setSelectedItem(Object selectedItem) {
        Object oldValue = this.selectedItem;
        this.selectedItem = selectedItem;
        firePropertyChange(PROPERTY_SELECTED_ITEM, oldValue, selectedItem);
    }

    public void setSelectedToolTipText(String selectedToolTipText) {
        String oldValue = this.selectedToolTipText;
        this.selectedToolTipText = selectedToolTipText;
        firePropertyChange(PROPERTY_SELECTED_TOOL_TIP_TEXT, oldValue, selectedToolTipText);
    }

    public void setShowDecorator(Boolean showDecorator) {
        Boolean oldValue = this.showDecorator;
        this.showDecorator = showDecorator;
        firePropertyChange(PROPERTY_SHOW_DECORATOR, oldValue, showDecorator);
    }

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setSortable(Boolean sortable) {
        Boolean oldValue = this.sortable;
        this.sortable = sortable;
        firePropertyChange(PROPERTY_SORTABLE, oldValue, sortable);
    }

    public void setTabToSelect(Boolean tabToSelect) {
        Boolean oldValue = this.tabToSelect;
        this.tabToSelect = tabToSelect;
        firePropertyChange(PROPERTY_TAB_TO_SELECT, oldValue, tabToSelect);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToPopup() {
        popup.add(popupSortLabel);
        popup.add(sortUp);
        popup.add(sortDown);
        popup.add(popupSeparator);
        popup.add(popupLabel);
        popup.add($JSeparator0);
    }

    protected void addChildrenToSortDown() {
        { ButtonGroup $buttonGroup = sortGroup; sortDown.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortDown); }
    }

    protected void addChildrenToSortUp() {
        { ButtonGroup $buttonGroup = sortGroup; sortUp.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(sortUp); }
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(reset);
    }

    protected void addChildrenToToolbarRight() {
        toolbarRight.add(displayDecorator);
    }

    protected void createAutoFocus() {
        $objectMap.put("autoFocus", autoFocus = true);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createCombobox() {
        $objectMap.put("combobox", combobox = new JComboBox<O>());
        
        combobox.setName("combobox");
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createDisplayDecorator() {
        $objectMap.put("displayDecorator", displayDecorator = new JToggleButton());
        
        displayDecorator.setName("displayDecorator");
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createEnterToSelect() {
        $objectMap.put("enterToSelect", enterToSelect = true);
    }

    protected void createEnterToSelectUniqueUniverse() {
        $objectMap.put("enterToSelectUniqueUniverse", enterToSelectUniqueUniverse = true);
    }

    protected void createFilterable() {
        $objectMap.put("filterable", filterable = true);
    }

    protected void createI18nPrefix() {
        $objectMap.put("i18nPrefix", i18nPrefix = "entitycombobox.common.");
    }

    protected void createIndex() {
        $objectMap.put("index", index = 0);
    }

    protected void createIndexes() {
        $objectMap.put("indexes", indexes = new JAXXButtonGroup());
        
        indexes.setUseToolTipText(true);
        indexes.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__indexes"));
    }

    protected void createInvalidComboEditorTextColor() {
        $objectMap.put("invalidComboEditorTextColor", invalidComboEditorTextColor = null);
    }

    protected void createMaximumRowCount() {
        $objectMap.put("maximumRowCount", maximumRowCount = null);
    }

    protected void createNotSelectedToolTipText() {
        $objectMap.put("notSelectedToolTipText", notSelectedToolTipText = null);
    }

    protected void createPopup() {
        $objectMap.put("popup", popup = new JPopupMenu());
        
        popup.setName("popup");
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuCanceled", this, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener(JAXXUtil.getEventListener(PopupMenuListener.class, "popupMenuWillBecomeInvisible", this, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        $objectMap.put("popupLabel", popupLabel = new JLabel());
        
        popupLabel.setName("popupLabel");
    }

    protected void createPopupSeparator() {
        $objectMap.put("popupSeparator", popupSeparator = new JSeparator());
        
        popupSeparator.setName("popupSeparator");
    }

    protected void createPopupSortLabel() {
        $objectMap.put("popupSortLabel", popupSortLabel = new JLabel());
        
        popupSortLabel.setName("popupSortLabel");
        popupSortLabel.setText(t("bean.sort.label"));
    }

    protected void createPopupTitleText() {
        $objectMap.put("popupTitleText", popupTitleText = null);
    }

    protected void createProperty() {
        $objectMap.put("property", property = "");
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
    }

    protected void createReverseSort() {
        $objectMap.put("reverseSort", reverseSort = false);
    }

    protected void createSelectedItem() {
        $objectMap.put("selectedItem", selectedItem = null);
    }

    protected void createSelectedToolTipText() {
        $objectMap.put("selectedToolTipText", selectedToolTipText = null);
    }

    protected void createShowDecorator() {
        $objectMap.put("showDecorator", showDecorator = true);
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createSortDown() {
        $objectMap.put("sortDown", sortDown = new JRadioButtonMenuItem());
        
        sortDown.setName("sortDown");
        sortDown.setText(t("bean.sort.down"));
    }

    protected void createSortGroup() {
        $objectMap.put("sortGroup", sortGroup = new JAXXButtonGroup());
        
        sortGroup.setUseToolTipText(true);
        sortGroup.addChangeListener(JAXXUtil.getEventListener(ChangeListener.class, "stateChanged", this, "doStateChanged__on__sortGroup"));
    }

    protected void createSortUp() {
        $objectMap.put("sortUp", sortUp = new JRadioButtonMenuItem());
        
        sortUp.setName("sortUp");
        sortUp.setText(t("bean.sort.up"));
    }

    protected void createSortable() {
        $objectMap.put("sortable", sortable = true);
    }

    protected void createTabToSelect() {
        $objectMap.put("tabToSelect", tabToSelect = true);
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    protected void createToolbarRight() {
        $objectMap.put("toolbarRight", toolbarRight = new JToolBar());
        
        toolbarRight.setName("toolbarRight");
        toolbarRight.setBorderPainted(false);
        toolbarRight.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $Table0 = this;
        handler = new BeanFilterableComboBoxHandler<>();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createBeanType();
        createFilterable();
        createReverseSort();
        createShowReset();
        createShowDecorator();
        createEditable();
        createSortable();
        createAutoFocus();
        createEnterToSelectUniqueUniverse();
        createEnterToSelect();
        createTabToSelect();
        createProperty();
        createBean();
        createSelectedItem();
        createIndex();
        createInvalidComboEditorTextColor();
        createData();
        createMaximumRowCount();
        createIndexes();
        createSortGroup();
        createSelectedToolTipText();
        createNotSelectedToolTipText();
        createPopupTitleText();
        createI18nPrefix();
        createPopup();
        createPopupSortLabel();
        createSortUp();
        createSortDown();
        createPopupSeparator();
        createPopupLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createToolbarLeft();
        createReset();
        createCombobox();
        createToolbarRight();
        createDisplayDecorator();
        // inline creation of $Table0
        setName("$Table0");
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__$Table0"));
        $Table0.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__$Table0"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 10 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_GROUP_SELECTED_VALUE, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortGroup.setSelectedValue(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_UP_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortUp.setSelected(!isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SORT_DOWN_SELECTED, true ,"reverseSort") {
        
            @Override
            public void processDataBinding() {
                sortDown.setSelected(isReverseSort());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_SELECTED_ITEM, true ,"selectedItem") {
        
            @Override
            public void processDataBinding() {
                combobox.setSelectedItem(getSelectedItem());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_EDITABLE, true ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setEditable(isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_FOCUSABLE, true ,"enabled" ,"editable") {
        
            @Override
            public void processDataBinding() {
                combobox.setFocusable(isEnabled() && isEditable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                combobox.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBOBOX_MAXIMUM_ROW_COUNT, true ,"maximumRowCount") {
        
            @Override
            public void processDataBinding() {
                combobox.setMaximumRowCount( getMaximumRowCount() != null ? getMaximumRowCount() : 8 );
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_RIGHT_VISIBLE, true ,"showDecorator") {
        
            @Override
            public void processDataBinding() {
                toolbarRight.setVisible(isShowDecorator());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(toolbarLeft, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(combobox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        add(toolbarRight, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        addChildrenToPopup();
        addChildrenToSortUp();
        addChildrenToSortDown();
        addChildrenToToolbarLeft();
        addChildrenToToolbarRight();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 10 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 7 property setters
        popup.setBorder( new TitledBorder(t("beancombobox.popup.title")) );
        popupSortLabel.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort"));
        sortUp.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-up"));
        { sortUp.putClientProperty("$value", false);  Object $buttonGroup = sortUp.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        sortDown.setIcon(SwingUtil.getUIManagerActionIcon("bean-sort-down"));
        { sortDown.putClientProperty("$value", true);  Object $buttonGroup = sortDown.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        combobox.setModel(new JaxxFilterableComboBoxModel<O>());// late initializer
        
        BeanFilterableComboBoxResetAction.init(this, reset, BeanFilterableComboBoxResetAction.class);
        BeanFilterableComboBoxDisplayDecoratorAction.init(this, displayDecorator, BeanFilterableComboBoxDisplayDecoratorAction.class);
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
