/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.number;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.TableCellEditor;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.jaxx.widgets.number.NumberEditorModel;

public class NumberCellEditor<E extends Number>
extends AbstractCellEditor
implements TableCellEditor,
FocusListener,
AncestorListener {
    private static final long serialVersionUID = 1L;
    protected final NumberEditor numberEditor = new NumberEditor();

    public NumberCellEditor(Class<E> type, boolean useSign) {
        this.numberEditor.getTextField().setHorizontalAlignment(4);
        this.numberEditor.getTextField().setBorder(null);
        this.numberEditor.getTextField().addFocusListener(this);
        this.numberEditor.getTextField().addAncestorListener(this);
        this.numberEditor.setNumberType(type);
        this.numberEditor.setUseSign(useSign);
        this.numberEditor.init();
    }

    public static TableCellEditor newFloatColumnEditor() {
        return NumberCellEditor.newFloatColumnEditor(false);
    }

    public static TableCellEditor newFloatColumnEditor(boolean useSign) {
        NumberCellEditor<Float> editor = new NumberCellEditor<Float>(Float.class, useSign);
        editor.getNumberEditor().setSelectAllTextOnError(true);
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern("\\d{0,6}|\\d{1,6}\\.\\d{0,4}");
        return editor;
    }

    public static TableCellEditor newIntegerColumnEditor() {
        return NumberCellEditor.newIntegerColumnEditor(false);
    }

    public static TableCellEditor newIntegerColumnEditor(boolean useSign) {
        NumberCellEditor<Integer> editor = new NumberCellEditor<Integer>(Integer.class, useSign);
        editor.getNumberEditor().setSelectAllTextOnError(true);
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern("\\d{0,3}");
        return editor;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Number number = (Number)value;
        this.numberEditor.setNumberValue(number);
        return this.numberEditor;
    }

    public NumberEditor getNumberEditor() {
        return this.numberEditor;
    }

    public E getCellEditorValue() {
        NumberEditorModel model = this.numberEditor.getModel();
        return (E)model.getNumberValue();
    }

    @Override
    public void focusGained(FocusEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.numberEditor.getTextField().requestFocus();
            this.numberEditor.getTextField().selectAll();
        });
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        SwingUtilities.invokeLater(() -> {
            this.numberEditor.getTextField().requestFocus();
            this.numberEditor.getTextField().selectAll();
        });
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public boolean stopCellEditing() {
        boolean result = super.stopCellEditing();
        if (result) {
            this.numberEditor.setNumberValue(null);
            this.numberEditor.applyDataBinding("textField.text");
        }
        return result;
    }
}

