/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.hidor;

import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.hidor.HidorButton;

public class HidorButtonHandler
implements UIHandler<HidorButton> {
    public static final String BEFORE_OPEN = "beforeOpen";
    public static final String AFTER_OPEN = "afterOpen";
    private static final Logger log = LogManager.getLogger(HidorButtonHandler.class);
    protected HidorButton ui;

    public void setTarget(JComponent target) {
        JComponent oldValue = this.ui.target;
        this.ui.target = target;
        this.ui.firePropertyChange("target", oldValue, target);
    }

    public void setExpandIcon(Icon icon) {
        this.ui.putClientProperty("expandIcon", icon);
    }

    public void setHideIcon(Icon icon) {
        this.ui.putClientProperty("hideIcon", icon);
    }

    protected String updateToolTipText(boolean c) {
        return c ? this.ui.hideTip : this.ui.showTip;
    }

    protected String updateText(boolean c) {
        return c ? this.ui.hideText : this.ui.showText;
    }

    protected Icon updateIcon(boolean c) {
        return (Icon)this.ui.getClientProperty(c ? "hideIcon" : "showIcon");
    }

    public void beforeInit(HidorButton ui) {
        this.ui = ui;
    }

    public void afterInit(HidorButton ui) {
        Consumer beforeOpen = ui.getContextValue(Consumer.class, BEFORE_OPEN);
        Consumer afterOpen = ui.getContextValue(Consumer.class, AFTER_OPEN);
        ui.addPropertyChangeListener("targetVisible", evt -> {
            if (log.isDebugEnabled()) {
                log.debug("target visible changed <" + evt.getOldValue() + ":" + evt.getNewValue() + ">");
            }
            boolean newValue = (Boolean)evt.getNewValue();
            if (ui.target != null) {
                if (beforeOpen != null) {
                    beforeOpen.accept(ui);
                }
                ui.target.setVisible(newValue);
                if (afterOpen != null) {
                    afterOpen.accept(ui);
                }
            }
        });
    }
}

