package org.nuiton.jaxx.widgets.hidor;

/*-
 * #%L
 * JAXX :: Widgets Hidor
 * %%
 * Copyright (C) 2008 - 2020 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import static io.ultreia.java4all.i18n.I18n.t;

public class HidorButton extends JToggleButton implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HIDE_TEXT = "hideText";
    public static final String PROPERTY_HIDE_TIP = "hideTip";
    public static final String PROPERTY_SHOW_TEXT = "showText";
    public static final String PROPERTY_SHOW_TIP = "showTip";
    public static final String PROPERTY_TARGET_VISIBLE = "targetVisible";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_HIDOR_ICON = "hidor.icon";
    public static final String BINDING_HIDOR_TEXT = "hidor.text";
    public static final String BINDING_HIDOR_TOOL_TIP_TEXT = "hidor.toolTipText";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Tu24TQRS9dmI7sQkkFHRIQUkwiLAraiMeSRQFZIhEIhThhrF3ZI+13hlm7uKlSUFBxw9Q0NKg/ENEhURD639AyidwZ9bxWpGdBFzMru+ee+bcx/n+BwpGw7rUbS+KBcrI67Ik8XQcoehx7/nTg4PdZpe3cIublhYKpYb0l8tDvgGVYBQ3CF6jTkx+yuRbJn/I5G/KnpIRj8aIanUoG/wQctPhHBHuTE1uGePvjZC1RMV6eNdE1ZPu+vXpwSDHt77kARJF8otU9r1/IMiqnq1DXgQI1+td9p75IYvaJE6LqE0FLdjYZsiMecl6/B0cQqkORcU0kSHc/6/2ODpHlSiEQkcEUiPcPSu+L4I2R+O5796OPTdipM9KuewiwgIyTZjXwohmyBGWrFrPVuBtSBlyNoadIx6+zxOSvZjB0kLHUKYj+xZl/y9l8ZLLFups2MGzsIbb02ZAM/eymWftzzWgoGMKI6xMXze7Ma8Ile7KyvRdsdc44MejQ/2tfzI4XZAZErd8UdaYF2haSkvFNQqr7Vq6HTGK0H/BVK0B84aHZCRnlOr5yveGSFJPKtIpWSZvh5kOsRVKg+MfN97+noH8NpRDyYJtZvHPYB47mjomwyBRj584cVf6c3QuWpkIs6IlI4SrDwOGbLkpooDG+SihHlXP79FI0tHuyc+vn9eOT/uUI4Wrl8nMelV4A0URhSLizkpDl0y0TkUZHgcys8AkU+Tss6yGa3bTnbcmVo/DTV1NYvtYc/rtW/XSHBUkp9AK719M9RclNsv5XgUAAA==";
    private static final Logger log = LogManager.getLogger(HidorButton.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected HidorButtonHandler handler;
    protected String hideText;
    protected String hideTip;
    protected HidorButton hidor;
    protected String showText;
    protected String showTip;
    protected Boolean targetVisible;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComponent target;
    
    
    public JComponent getTarget() {
        return target;
    }
    
    public void setTarget(JComponent target) {
        JComponent oldValue = this.target;
        this.target = target;
        firePropertyChange("target", oldValue, target);
    }
    
    public void setExpandIcon(Icon icon) {
        putClientProperty("expandIcon", icon);
    }
    
    public void setHideIcon(Icon icon) {
        putClientProperty("hideIcon", icon);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HidorButton() {
        $initialize();
    }

    public HidorButton(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, Icon param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, Icon param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, Icon param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, Icon param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Icon param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Icon param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Icon param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Icon param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HidorButton(Action param0) {
        super(param0);
        $initialize();
    }

    public HidorButton(JAXXContext parentContext, Action param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__hidor(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setTargetVisible(!targetVisible);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public HidorButtonHandler getHandler() {
        return handler;
    }

    public String getHideText() {
        return hideText;
    }

    public String getHideTip() {
        return hideTip;
    }

    public String getShowText() {
        return showText;
    }

    public String getShowTip() {
        return showTip;
    }

    public Boolean getTargetVisible() {
        return targetVisible;
    }

    public Boolean isTargetVisible() {
        return targetVisible !=null && targetVisible;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHideText(String hideText) {
        String oldValue = this.hideText;
        this.hideText = hideText;
        firePropertyChange(PROPERTY_HIDE_TEXT, oldValue, hideText);
    }

    public void setHideTip(String hideTip) {
        String oldValue = this.hideTip;
        this.hideTip = hideTip;
        firePropertyChange(PROPERTY_HIDE_TIP, oldValue, hideTip);
    }

    public void setShowText(String showText) {
        String oldValue = this.showText;
        this.showText = showText;
        firePropertyChange(PROPERTY_SHOW_TEXT, oldValue, showText);
    }

    public void setShowTip(String showTip) {
        String oldValue = this.showTip;
        this.showTip = showTip;
        firePropertyChange(PROPERTY_SHOW_TIP, oldValue, showTip);
    }

    public void setTargetVisible(Boolean targetVisible) {
        Boolean oldValue = this.targetVisible;
        this.targetVisible = targetVisible;
        firePropertyChange(PROPERTY_TARGET_VISIBLE, oldValue, targetVisible);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHideText() {
        $objectMap.put("hideText", hideText = "");
    }

    protected void createHideTip() {
        $objectMap.put("hideTip", hideTip = t("hidor.hideTip"));
    }

    protected void createShowText() {
        $objectMap.put("showText", showText = "");
    }

    protected void createShowTip() {
        $objectMap.put("showTip", showTip = t("hidor.showTip"));
    }

    protected void createTargetVisible() {
        $objectMap.put("targetVisible", targetVisible = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        hidor = this;
        handler = new HidorButtonHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("hidor", hidor);
        createTargetVisible();
        createHideText();
        createShowText();
        createHideTip();
        createShowTip();
        // inline creation of hidor
        setName("hidor");
        hidor.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__hidor"));
        hidor.putClientProperty("hideIcon", SwingUtil.createActionIcon("collapse"));
        hidor.putClientProperty("showIcon", SwingUtil.createActionIcon("expand"));
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_ICON, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setIcon(handler.updateIcon(isTargetVisible()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setText(handler.updateText(isTargetVisible()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_HIDOR_TOOL_TIP_TEXT, true ,"targetVisible") {
        
            @Override
            public void processDataBinding() {
                setToolTipText(handler.updateToolTipText(isTargetVisible()));
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
