/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import com.google.auto.service.AutoService;
import io.ultreia.java4all.i18n.I18n;
import java.util.regex.Matcher;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.converter.NuitonConverter;
import org.nuiton.jaxx.widgets.gis.DmdCoordinate;

@AutoService(value={NuitonConverter.class})
public class DmdCoordinateConverter
implements NuitonConverter<DmdCoordinate> {
    protected boolean useSign;
    protected boolean forLongitude;
    protected String nullValue = "";
    protected char fillChar = (char)32;

    public void setUseSign(boolean useSign) {
        this.useSign = useSign;
    }

    public void setForLongitude(boolean forLongitude) {
        this.forLongitude = forLongitude;
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        this.nullValue = displayZeroWhenNull ? "0" : "";
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.fillChar = (char)(fillWithZero ? 48 : 32);
    }

    public <T> T convert(Class<T> aClass, Object value) {
        if (!this.isEnabled(aClass)) {
            throw new ConversionException(I18n.t((String)"jaxx.error.no.convertor.coordinateDmd", (Object[])new Object[]{value}));
        }
        Object result = null;
        if (value == null) {
            if (aClass.equals(String.class)) {
                result = String.format("%s%s\u00b0%s.%s'", this.useSign ? "-" : "", StringUtils.leftPad((String)this.nullValue, (int)(this.forLongitude ? 3 : 2), (char)' '), StringUtils.leftPad((String)this.nullValue, (int)2, (char)' '), StringUtils.leftPad((String)this.nullValue, (int)2, (char)' '));
            }
        } else if (aClass.equals(value.getClass())) {
            result = value;
        } else if (value instanceof String) {
            Matcher matcher = DmdCoordinate.COORDINATE_PATTERN.matcher((String)value);
            if (matcher.matches()) {
                Integer decimal;
                String degresStr = matcher.group(1).replaceAll("\\s", "");
                String minutesStr = matcher.group(2).replaceAll("\\s", "");
                String decimalesStr = matcher.group(3).replaceAll("\\s", "");
                Integer degre = degresStr.isEmpty() || "-".equals(degresStr) ? null : Integer.valueOf(Math.abs(Integer.valueOf(degresStr)));
                Integer minutes = minutesStr.isEmpty() ? null : Integer.valueOf(minutesStr);
                Integer n = decimal = decimalesStr.isEmpty() ? null : Integer.valueOf(decimalesStr);
                if (decimalesStr.length() == 1 && decimal != null && decimal > 0) {
                    decimal = decimal * 10;
                }
                boolean signed = degresStr.contains("-");
                result = DmdCoordinate.valueOf(signed, degre, minutes, decimal);
            }
        } else if (value instanceof DmdCoordinate) {
            DmdCoordinate coordinate = (DmdCoordinate)((Object)value);
            boolean sign = coordinate.isSign();
            String signStr = sign ? "-" : "";
            Integer degree = coordinate.getDegree();
            String degreeStr = degree == null ? this.nullValue : degree.toString();
            Integer minute = coordinate.getMinute();
            String minuteStr = minute == null ? this.nullValue : minute.toString();
            Integer decimal = coordinate.getDecimal();
            String decimalStr = decimal == null ? this.nullValue : decimal.toString();
            result = String.format("%s%s\u00b0%s.%s'", signStr, StringUtils.leftPad((String)degreeStr, (int)(this.forLongitude ? 3 : 2), (char)(this.nullValue.equals(degreeStr) ? (char)' ' : (char)this.fillChar)), StringUtils.leftPad((String)minuteStr, (int)2, (char)(this.nullValue.equals(minuteStr) ? (char)' ' : (char)this.fillChar)), StringUtils.leftPad((String)decimalStr, (int)2, (char)(this.nullValue.equals(decimalStr) ? (char)' ' : (char)this.fillChar)));
        }
        return aClass.cast(result);
    }

    protected boolean isEnabled(Class<?> aClass) {
        return String.class.isAssignableFrom(aClass) || DmdCoordinate.class.isAssignableFrom(aClass);
    }

    public Class<DmdCoordinate> getType() {
        return DmdCoordinate.class;
    }
}

