package org.nuiton.jaxx.widgets.gis.absolute;

/*-
 * #%L
 * JAXX :: Widgets Gis
 * %%
 * Copyright (C) 2008 - 2021 Code Lutin, Ultreia.io
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.SimpleJAXXObjectBinding;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.SwingUtil;
import org.nuiton.jaxx.widgets.gis.DmsCoordinate;

public class AbsoluteDmsCoordinateEditor extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SHOW_RESET = "showReset";
    public static final String PROPERTY_SHOW_RESET_TIP = "showResetTip";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_EDITOR_ENABLED = "editor.enabled";
    public static final String BINDING_RESET_BUTTON_TOOL_TIP_TEXT = "resetButton.toolTipText";
    public static final String BINDING_TOOLBAR_LEFT_ENABLED = "toolbarLeft.enabled";
    public static final String BINDING_TOOLBAR_LEFT_VISIBLE = "toolbarLeft.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTVMTQRDtBJJIgoqiHrxAlR9ACRv1oAcs5SNQQkWxDAdLLk6yQzLU7sw4M0sWKTl48OYf8ODVi8V/oDxZ5cUr/8Eqf4I9uyEbMAHUHLY2s92vX7/pfl9+QkYrmBSq7vCAGcGdDRKGjgq4YT51lmdfvFipbtCaKVFdU0waoSD+pdKQXoOC2z7XBpy1MiIVY6SiRSq2kIrzwpeCU94BNF2GvDZbHtUNSo2B8Z7JNa2LlXbkdCgD1arVlXW3Wt/f39lP0dLHNEAokX4O2771FwBJ1/1lSDPXwMXyBtkkRY/wOpJTjNexobP2bN4jWj8lPn0NO5ArQ1YShWAGpv5JngguggqlgQJ1MV09I5x6BmaOttBkbp0a7dSZdkhVCy8w1JltvZR8PS+Echknhi5EOFJG0FkDA7ohms+ptldxwbbh2NacOSE8SngSN9iOW0WeMJSExiokkRlfuJbkwv+SfGJxEtyCQU5Vosp0HblesgRCRzextrO8ip/miLKRAwZylJOqR912prK85wKDVAwMH8qMT23g5XalbCy2gZFDoYtC+cQY6q7S0Cwy6rlH6ym42Wu4cJidZJiTuUqtQUYFeGzgWu89sqvwHKPiJbjWewlsmSjw3e6O+tz8tX8w+VkkN3pSVseS4xhKJSRVhllu5+OxDwzzik+InF7DwaEeOkTkAGPHM6+0IpE9soinzCI5j4luIFomt7/39cqrH32QXoS8J4i7SGz8EorbwLtrCM8N5aOZiNxg8ww+hyxNvFmfceYHfoW9QVFHtjltjkbwpGmcEtbnmgk+fv/25N17E29D1G7seO3aVHdXfn379OHG3oF+KWR+/TSZiYaZl5Bl3GOcRt7RsoWuXlGQmgauSHa+mwsA7t1wlylsrciN6DnRTaaDATVwdpvphfjPuBXEpkxF7dm3Ikgpj+xPL9g+BKviwlI0JcaNBc+sEw8XDXKbTDMEwLHBcpUD48CC6DfreL+GRF/j+D9JHN51eUJ//QbyOC54z0s1u99DtbaPTKnY2AbWRS3QnUVbJdDLrIyo6zZaU6XD4iKyg1Hekf668u1wmJP44n1kPbIlMBjOPXBRjNEq40i4/vAP6JR95k+B2M9qsYutdse4ihi/AUp33b33BwAA";
    private static final Logger log = LogManager.getLogger(AbsoluteDmsCoordinateEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JFormattedTextField editor;
    protected AbsoluteDmsCoordinateEditor editorPanel;
    protected AbsoluteDmsCoordinateEditorHandler handler;
    protected AbsoluteDmsCoordinateEditorModel model;
    protected JButton resetButton;
    protected Boolean showReset;
    protected String showResetTip;
    protected JToolBar toolbarLeft;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public void init(boolean longitudeEditor) { handler.init(longitudeEditor); }
    public void setBean(Object bean) { model.setBean(bean); }
    public void setPropertyDegree(String property ) { model.setPropertyDegree(property); }
    public void setPropertyMinute(String property ) { model.setPropertyMinute(property); }
    public void setPropertySecond(String property ) { model.setPropertySecond(property); }
    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) { handler.setDisplayZeroWhenNull(displayZeroWhenNull); }
    public void setFillWithZero(boolean fillWithZero) { handler.setFillWithZero(fillWithZero); }
    public void setValue(DmsCoordinate value) { handler.setValue(value, true); }
    public void resetModel() { handler.resetModel(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AbsoluteDmsCoordinateEditor() {
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(boolean param0) {
        super(param0);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AbsoluteDmsCoordinateEditor(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__resetButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.resetEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JFormattedTextField getEditor() {
        return editor;
    }

    public AbsoluteDmsCoordinateEditorHandler getHandler() {
        return handler;
    }

    public AbsoluteDmsCoordinateEditorModel getModel() {
        return model;
    }

    public JButton getResetButton() {
        return resetButton;
    }

    public Boolean getShowReset() {
        return showReset;
    }

    public String getShowResetTip() {
        return showResetTip;
    }

    public JToolBar getToolbarLeft() {
        return toolbarLeft;
    }

    public Boolean isShowReset() {
        return showReset !=null && showReset;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setShowReset(Boolean showReset) {
        Boolean oldValue = this.showReset;
        this.showReset = showReset;
        firePropertyChange(PROPERTY_SHOW_RESET, oldValue, showReset);
    }

    public void setShowResetTip(String showResetTip) {
        String oldValue = this.showResetTip;
        this.showResetTip = showResetTip;
        firePropertyChange(PROPERTY_SHOW_RESET_TIP, oldValue, showResetTip);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEditorPanel() {
        add(toolbarLeft, BorderLayout.WEST);
        add(editor, BorderLayout.CENTER);
    }

    protected void addChildrenToToolbarLeft() {
        toolbarLeft.add(resetButton);
    }

    protected void createEditor() {
        $objectMap.put("editor", editor = new JFormattedTextField());
        
        editor.setName("editor");
        editor.setColumns(15);
    }

    protected void createModel() {
        $objectMap.put("model", model = new AbsoluteDmsCoordinateEditorModel());
    }

    protected void createResetButton() {
        $objectMap.put("resetButton", resetButton = new JButton());
        
        resetButton.setName("resetButton");
        resetButton.setFocusable(false);
        resetButton.setFocusPainted(false);
        resetButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__resetButton"));
    }

    protected void createShowReset() {
        $objectMap.put("showReset", showReset = false);
    }

    protected void createShowResetTip() {
        $objectMap.put("showResetTip", showResetTip = new String());
    }

    protected void createToolbarLeft() {
        $objectMap.put("toolbarLeft", toolbarLeft = new JToolBar());
        
        toolbarLeft.setName("toolbarLeft");
        toolbarLeft.setBorderPainted(false);
        toolbarLeft.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        editorPanel = this;
        handler = new AbsoluteDmsCoordinateEditorHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editorPanel", editorPanel);
        createShowReset();
        createShowResetTip();
        createModel();
        createToolbarLeft();
        createResetButton();
        createEditor();
        // inline creation of editorPanel
        setName("editorPanel");
        setLayout(new BorderLayout());
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_VISIBLE, true ,"showReset") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setVisible(isShowReset());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOOLBAR_LEFT_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                toolbarLeft.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_RESET_BUTTON_TOOL_TIP_TEXT, true ,"showResetTip") {
        
            @Override
            public void processDataBinding() {
                resetButton.setToolTipText(getShowResetTip());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_EDITOR_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                editor.setEnabled(isEnabled());
            }
        });
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditorPanel();
        addChildrenToToolbarLeft();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 3 property setters
        resetButton.setIcon(SwingUtil.getUIManagerActionIcon("coordinate-reset"));
        editor.setMinimumSize(new java.awt.Dimension(70,26));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}
