/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.validators;

import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.validators.FieldValidatorSupport;
import io.ultreia.java4all.i18n.I18n;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.jaxx.widgets.gis.CoordinateFormat;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmdCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.absolute.AbsoluteDmsCoordinateEditorModel;
import org.nuiton.jaxx.widgets.gis.absolute.CoordinatesEditor;

public class CoordinateLongitudeDtoFieldValidator
extends FieldValidatorSupport {
    private String editorName;

    public void setEditorName(String editorName) {
        this.editorName = editorName;
    }

    public void validate(Object object) throws ValidationException {
        if (StringUtils.isEmpty((CharSequence)this.editorName)) {
            throw new ValidationException("editorName is not defined");
        }
        Map map = (Map)this.getFieldValue("coordinatesEditors", object);
        if (map == null) {
            return;
        }
        CoordinatesEditor coordinatesEditor = (CoordinatesEditor)((Object)map.get(this.editorName));
        if (coordinatesEditor == null) {
            return;
        }
        Objects.requireNonNull(coordinatesEditor, "can't find editor named " + this.editorName);
        CoordinateFormat format = coordinatesEditor.getModel().getFormat();
        switch (format) {
            case dd: {
                this.validate(coordinatesEditor.getLongitudeDd());
                break;
            }
            case dms: {
                this.validate(coordinatesEditor.getLongitudeDms());
                break;
            }
            case dmd: {
                this.validate(coordinatesEditor.getLongitudeDmd());
            }
        }
    }

    public String getValidatorType() {
        return "coordinate_longitude";
    }

    private void validate(AbsoluteDdCoordinateEditor editor) {
        AbsoluteDdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 180) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.degree.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), degree);
        }
    }

    private void validate(AbsoluteDmsCoordinateEditor editor) {
        Integer second;
        Integer minute;
        AbsoluteDmsCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 180) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.degree.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), degree);
        }
        if ((minute = model.getMinute()) != null && minute > 59) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.minute.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), minute);
        }
        if ((second = model.getSecond()) != null && second > 59) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.second.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), second);
        }
    }

    private void validate(AbsoluteDmdCoordinateEditor editor) {
        Integer minute;
        AbsoluteDmdCoordinateEditorModel model = editor.getModel();
        Integer degree = model.getDegree();
        if (degree != null && degree > 180) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.degree.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), degree);
        }
        if ((minute = model.getMinute()) != null && minute > 59) {
            this.setMessageKey(I18n.n((String)"jaxx.validation.coordinate.minute.longitude.outOfBound", (Object[])new Object[0]));
            this.addFieldError(this.getFieldName(), minute);
        }
    }
}

