/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import java.util.regex.Pattern;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.jaxx.widgets.gis.CoordinateHelper;

public class DdCoordinate
extends AbstractSerializableBean {
    private static final long serialVersionUID = 1L;
    public static final String COORDINATE_STRING_PATTERN = "%s%s.%s";
    public static final Pattern COORDINATE_PATTERN = Pattern.compile("(.*)\\.(.*)");
    public static final String PROPERTY_SIGN = "sign";
    public static final String PROPERTY_DEGREE = "degree";
    public static final String PROPERTY_DECIMAL = "decimal";
    protected boolean sign;
    protected Integer degree;
    protected Integer decimal;

    public static DdCoordinate empty() {
        return new DdCoordinate();
    }

    public static DdCoordinate valueOf(DdCoordinate decimal) {
        DdCoordinate r = DdCoordinate.empty();
        if (decimal != null) {
            r.setSign(decimal.isSign());
            r.setDegree(decimal.getDegree());
            r.setDecimal(decimal.getDecimal());
        }
        return r;
    }

    public static DdCoordinate valueOf(Float decimal) {
        DdCoordinate r = new DdCoordinate();
        r.fromDecimal(decimal);
        return r;
    }

    public static DdCoordinate valueOf(boolean sign, Integer d, Integer dc) {
        DdCoordinate r = new DdCoordinate();
        r.setSign(sign);
        r.setDegree(d);
        r.setDecimal(dc);
        return r;
    }

    public boolean isSign() {
        return this.sign;
    }

    public Integer getDegree() {
        return this.degree;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public void setSign(boolean sign) {
        Boolean oldValue = this.isSign();
        this.sign = sign;
        this.firePropertyChange(PROPERTY_SIGN, oldValue, sign);
    }

    public void setDegree(Integer degree) {
        Integer oldValue = this.getDegree();
        this.degree = degree;
        this.firePropertyChange(PROPERTY_DEGREE, oldValue, degree);
    }

    public void setDecimal(Integer decimal) {
        Integer oldValue = this.getDecimal();
        this.decimal = decimal;
        this.firePropertyChange(PROPERTY_DECIMAL, oldValue, decimal);
    }

    public boolean isNull() {
        return this.degree == null && this.decimal == null;
    }

    public boolean isDegreeNull() {
        return this.degree == null || this.degree == 0;
    }

    public boolean isDecimalNull() {
        return this.decimal == null || this.decimal == 0;
    }

    public void fromDecimal(Float decimalValue) {
        Integer d = null;
        Integer dc = null;
        boolean si = false;
        if (decimalValue != null) {
            si = decimalValue.floatValue() < 0.0f;
            float absDecimal = Math.abs(decimalValue.floatValue());
            d = (int)(Math.round((double)absDecimal + 0.5) - 1L);
            dc = Math.round(1000.0f * (absDecimal - (float)d.intValue()));
        }
        this.degree = d;
        this.decimal = dc;
        this.sign = si;
        if (this.decimal != null) {
            this.removeTrailingZero();
        }
    }

    public Float toDecimal() {
        if (this.isNull()) {
            return null;
        }
        Integer d = this.getNotNullDegree();
        Integer dc = this.getNotNullDecimal();
        Float result = Float.valueOf(d.intValue());
        result = Float.valueOf(result.floatValue() + (float)dc.intValue() / 1000.0f);
        if (this.sign) {
            result = Float.valueOf(result.floatValue() * -1.0f);
        }
        result = CoordinateHelper.roundToFourDecimals(result);
        return result;
    }

    public void addTrailingZero() {
        if (this.degree == null) {
            this.degree = 0;
        }
        if (this.decimal == null) {
            this.decimal = 0;
        }
    }

    public void removeTrailingZero() {
        if (this.degree != null && this.degree == 0) {
            this.degree = null;
        }
        if (this.decimal != null && this.decimal == 0) {
            this.decimal = null;
        }
    }

    public Integer getSignedDegree() {
        Integer result = null;
        if (!this.isDegreeNull()) {
            result = this.degree;
            if (this.isSign()) {
                result = result * -1;
            }
        }
        return result;
    }

    public int getNotNullDegree() {
        return this.isDegreeNull() ? 0 : this.degree;
    }

    public int getNotNullDecimal() {
        return this.isDecimalNull() ? 0 : this.decimal;
    }

    public boolean isLatitudeDegreeValid() {
        return this.isDegreeValid(false);
    }

    public boolean isLongitudeDegreeValid() {
        return this.isDegreeValid(true);
    }

    public boolean isDecimalValid() {
        return this.isDecimalNull() || 0 <= this.decimal && this.decimal < 1000;
    }

    public String toString() {
        return "DdCoordinateComponent{sign=" + this.sign + ", degree=" + this.degree + ", decimal=" + this.decimal + "}";
    }

    public void reset() {
        this.decimal = null;
        this.degree = null;
    }

    protected boolean isDegreeValid(boolean longitude) {
        boolean result = true;
        if (!this.isDegreeNull()) {
            int bound;
            int n = bound = longitude ? 180 : 90;
            result = bound == this.degree ? this.isDecimalNull() : 0 <= this.degree && this.degree < bound;
        }
        return result;
    }
}

