/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis.signed;

import io.ultreia.java4all.lang.Setters;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Objects;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.spi.UIHandler;
import org.nuiton.jaxx.widgets.gis.DdCoordinate;
import org.nuiton.jaxx.widgets.gis.DdCoordinateConverter;
import org.nuiton.jaxx.widgets.gis.MaskFormatterFromConverter;
import org.nuiton.jaxx.widgets.gis.signed.SignedDdCoordinateEditor;
import org.nuiton.jaxx.widgets.gis.signed.SignedDdCoordinateEditorModel;

public class SignedDdCoordinateEditorHandler
implements UIHandler<SignedDdCoordinateEditor> {
    private static final Log log = LogFactory.getLog(SignedDdCoordinateEditorHandler.class);
    private SignedDdCoordinateEditor ui;
    protected Method signMutator;
    protected Method degreMutator;
    protected Method decimalMutator;
    protected boolean valueIsAdjusting;
    protected boolean valueModelIsAdjusting;
    protected DdCoordinateConverter signedConverter;
    protected DdCoordinateConverter unsignedConverter;
    protected DefaultFormatterFactory signedFormatterFactory;
    protected DefaultFormatterFactory unsignedFormatterFactory;

    public void beforeInit(SignedDdCoordinateEditor ui) {
        this.ui = ui;
        this.signedConverter = new DdCoordinateConverter();
        this.signedConverter.setUseSign(true);
        this.unsignedConverter = new DdCoordinateConverter();
    }

    public void afterInit(SignedDdCoordinateEditor ui) {
    }

    public void init(boolean longitudeEditor) {
        MaskFormatterFromConverter<DdCoordinate> maskFormatter;
        SignedDdCoordinateEditorModel model = this.ui.getModel();
        Objects.requireNonNull(model.getBean(), "could not find bean in " + this.ui);
        Objects.requireNonNull(model.getPropertySign(), "could not find propertySign in " + this.ui);
        Objects.requireNonNull(model.getPropertyDegree(), "could not find propertyDegree in " + this.ui);
        Objects.requireNonNull(model.getPropertyDecimal(), "could not find propertyDecimal in " + this.ui);
        Object bean = model.getBean();
        this.signMutator = Setters.getMutator((Object)bean, (String)model.getPropertySign());
        Objects.requireNonNull(this.signMutator, "could not find mutator for " + model.getPropertySign());
        this.degreMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDegree());
        Objects.requireNonNull(this.degreMutator, "could not find mutator for " + model.getPropertyDegree());
        this.decimalMutator = Setters.getMutator((Object)bean, (String)model.getPropertyDecimal());
        Objects.requireNonNull(this.decimalMutator, "could not find mutator for " + model.getPropertyDecimal());
        this.signedConverter.setForLongitude(longitudeEditor);
        this.unsignedConverter.setForLongitude(longitudeEditor);
        String pattern = this.getMaskFormatterPattern(longitudeEditor, false);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DdCoordinate.class, pattern, (Converter)this.unsignedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.unsignedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        pattern = this.getMaskFormatterPattern(longitudeEditor, true);
        try {
            maskFormatter = MaskFormatterFromConverter.newFormatter(DdCoordinate.class, pattern, (Converter)this.signedConverter);
            maskFormatter.setValidCharacters(" 01234567890");
            maskFormatter.setCommitsOnValidEdit(true);
            this.signedFormatterFactory = new DefaultFormatterFactory(maskFormatter);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        JFormattedTextField editor = this.ui.getEditor();
        editor.setFormatterFactory(model.isSign() ? this.signedFormatterFactory : this.unsignedFormatterFactory);
        editor.setFocusLostBehavior(0);
        editor.addPropertyChangeListener("value", evt -> {
            DdCoordinate newValue = (DdCoordinate)((Object)((Object)evt.getNewValue()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Value has changed: " + (Object)((Object)newValue)));
            }
            model.setValue(newValue);
        });
        model.addPropertyChangeListener("sign", new ModelPropertyChangeListener(model, this.signMutator));
        model.addPropertyChangeListener("degree", new ModelPropertyChangeListener(model, this.degreMutator));
        model.addPropertyChangeListener("decimal", new ModelPropertyChangeListener(model, this.decimalMutator));
    }

    public void setDisplayZeroWhenNull(boolean displayZeroWhenNull) {
        block5: {
            this.signedConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            this.unsignedConverter.setDisplayZeroWhenNull(displayZeroWhenNull);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setDisplayZeroWhenNull: " + displayZeroWhenNull));
            }
            SignedDdCoordinateEditorModel model = this.ui.getModel();
            JFormattedTextField editor = this.ui.getEditor();
            JFormattedTextField.AbstractFormatter formatter = editor.getFormatter();
            if (formatter != null) {
                try {
                    String newStringValue = formatter.valueToString((Object)model);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("updating string value: " + newStringValue));
                    }
                    editor.setText(newStringValue);
                }
                catch (ParseException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Could not parse new string value", (Throwable)e);
                }
            }
        }
    }

    public void setFillWithZero(boolean fillWithZero) {
        this.signedConverter.setFillWithZero(fillWithZero);
        this.unsignedConverter.setFillWithZero(fillWithZero);
    }

    public void setValue(DdCoordinate value, boolean pushToModel) {
        if (this.valueModelIsAdjusting) {
            return;
        }
        this.valueIsAdjusting = !pushToModel;
        try {
            this.ui.getEditor().setValue((Object)value);
        }
        finally {
            this.valueIsAdjusting = false;
        }
    }

    public void resetEditor() {
        this.setValue(null, true);
        this.ui.getEditor().setFormatterFactory(this.unsignedFormatterFactory);
    }

    public void onKeyReleased(KeyEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        char keyChar = e.getKeyChar();
        int caretPosition = source.getCaretPosition();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Key pressed: " + keyChar + " (caret position: " + caretPosition + ")"));
        }
        if (keyChar == '-') {
            DefaultFormatterFactory newFactory;
            DdCoordinate value = (DdCoordinate)((Object)source.getValue());
            boolean useSign = this.ui.getModel().isSign();
            if (useSign) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to unsigned");
                }
                newFactory = this.unsignedFormatterFactory;
                --caretPosition;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Switch to signed");
                }
                newFactory = this.signedFormatterFactory;
                ++caretPosition;
            }
            DdCoordinate newValue = DdCoordinate.valueOf(value);
            newValue.setSign(!useSign);
            source.setFormatterFactory(newFactory);
            source.setValue((Object)newValue);
            e.consume();
            source.setCaretPosition(caretPosition);
        }
    }

    protected String getMaskFormatterPattern(boolean longitudeEditor, boolean useSign) {
        String pattern = "**.***";
        if (longitudeEditor) {
            pattern = "*" + pattern;
        }
        if (useSign) {
            pattern = "-" + pattern;
        }
        return pattern;
    }

    private class ModelPropertyChangeListener
    implements PropertyChangeListener {
        private final SignedDdCoordinateEditorModel model;
        private final Method mutator;

        private ModelPropertyChangeListener(SignedDdCoordinateEditorModel model, Method mutator) {
            this.model = model;
            this.mutator = mutator;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!SignedDdCoordinateEditorHandler.this.valueIsAdjusting) {
                Object newValue = evt.getNewValue();
                try {
                    SignedDdCoordinateEditorHandler.this.valueModelIsAdjusting = true;
                    try {
                        this.mutator.invoke(this.model.getBean(), newValue);
                    }
                    finally {
                        SignedDdCoordinateEditorHandler.this.valueModelIsAdjusting = false;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

