/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.gis;

import java.text.ParseException;
import javax.swing.text.MaskFormatter;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MaskFormatterFromConverter<O>
extends MaskFormatter {
    private static final Log log = LogFactory.getLog(MaskFormatterFromConverter.class);
    private static final long serialVersionUID = 1L;
    private final Converter converter;
    private final Class<O> type;

    public static <O> MaskFormatterFromConverter<O> newFormatter(Class<O> type, String pattern, Converter converter) throws ParseException {
        return new MaskFormatterFromConverter<O>(type, pattern, converter);
    }

    protected MaskFormatterFromConverter(Class<O> type, String pattern, Converter converter) throws ParseException {
        super(pattern);
        this.type = type;
        this.converter = converter;
    }

    @Override
    public String valueToString(Object value) {
        String result = (String)this.converter.convert(String.class, value);
        if (log.isInfoEnabled()) {
            log.info((Object)(value + " --> " + result));
        }
        return result;
    }

    @Override
    public Object stringToValue(String value) {
        Object result = this.converter.convert(this.type, (Object)value);
        if (log.isInfoEnabled()) {
            log.info((Object)(value + " --> " + result));
        }
        return result;
    }

    protected Converter getConverter() {
        return this.converter;
    }

    protected Class<O> getType() {
        return this.type;
    }
}

