/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.file;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JaxxFileChooser {
    private static final Logger log = LogManager.getLogger(JaxxFileChooser.class);
    public static final File DEFAULT_CURRENT_DIRECTORY_FILE;
    protected static File currentDirectory;

    public static ToLoadFile forLoadingFile() {
        return new FileChooserBuilderImpl(ChooseMode.LOAD_FILE);
    }

    public static ToLoadDirectory forLoadingDirectory() {
        return new FileChooserBuilderImpl(ChooseMode.LOAD_DIRECTORY);
    }

    public static ToSave forSaving() {
        return new FileChooserBuilderImpl(ChooseMode.SAVE);
    }

    public static void setCurrentDirectory(File dir) {
        currentDirectory = dir;
    }

    public static File getCurrentDirectory() {
        return currentDirectory;
    }

    public static boolean isCurrentDirectoryDefault() {
        return currentDirectory.equals(DEFAULT_CURRENT_DIRECTORY_FILE);
    }

    protected JaxxFileChooser() {
    }

    static {
        currentDirectory = DEFAULT_CURRENT_DIRECTORY_FILE = new File(".");
    }

    static class FileChooserBuilderImpl
    implements ToLoadFile,
    ToLoadDirectory,
    ToSave {
        private final ChooseMode chooseMode;
        protected String title;
        protected File startDirectory;
        protected String approvalText;
        protected Component parent;
        protected List<FileFilter> fileFilters;
        protected boolean showFiles;
        protected boolean showDirectories;
        protected boolean multiSelectionEnabled;
        protected boolean fileHidingEnabled;
        protected boolean useAcceptAllFileFilter;
        protected boolean keepCurrentDirectory = true;
        protected String filename;

        FileChooserBuilderImpl(ChooseMode chooseMode) {
            this.chooseMode = chooseMode;
        }

        @Override
        public FileChooserBuilderImpl setTitle(String title) {
            this.title = title;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setApprovalText(String approvalText) {
            this.approvalText = approvalText;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setStartDirectory(File startDirectory) {
            this.startDirectory = startDirectory;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setParent(Component parent) {
            this.parent = parent;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setPatternOrDescriptionFilters(String pattern, String description, String ... patternOrDescriptionFilters) {
            ArrayList<String> r = new ArrayList<String>();
            r.add(pattern);
            r.add(description);
            r.addAll(Arrays.asList(patternOrDescriptionFilters));
            this.setPatternOrDescriptionFilters(r);
            return this;
        }

        @Override
        public FileChooserBuilderImpl setPatternOrDescriptionFilters(List<String> patternOrDescriptionFilters) {
            ArrayList<PatternChooserFilter> r = new ArrayList<PatternChooserFilter>();
            if (patternOrDescriptionFilters.size() % 2 != 0) {
                throw new IllegalArgumentException("Arguments must be (pattern, description) couple");
            }
            int nbFilters = patternOrDescriptionFilters.size() / 2;
            for (int i = 0; i < nbFilters; ++i) {
                String pattern = patternOrDescriptionFilters.get(i * 2);
                String description = patternOrDescriptionFilters.get(i * 2 + 1);
                r.add(new PatternChooserFilter(pattern, description));
            }
            return this.setFileFilters(r);
        }

        @Override
        public FileChooserBuilderImpl setFileFilters(FileFilter fileFilter, FileFilter ... fileFilters) {
            ArrayList<FileFilter> r = new ArrayList<FileFilter>();
            r.add(fileFilter);
            r.addAll(Arrays.asList(fileFilters));
            return this.setFileFilters(r);
        }

        @Override
        public FileChooserBuilderImpl setFileFilters(List<FileFilter> fileFilters) {
            this.fileFilters = fileFilters;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setShowFiles(boolean showFiles) {
            this.showFiles = showFiles;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setShowDirectories(boolean showDirectories) {
            this.showDirectories = showDirectories;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setMultiSelectionEnabled(boolean multiSelectionEnabled) {
            this.multiSelectionEnabled = multiSelectionEnabled;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setFileHidingEnabled(boolean fileHidingEnabled) {
            this.fileHidingEnabled = fileHidingEnabled;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setUseAcceptAllFileFilter(boolean useAcceptAllFileFilter) {
            this.useAcceptAllFileFilter = useAcceptAllFileFilter;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setFilename(String filename) {
            this.filename = filename;
            return this;
        }

        @Override
        public FileChooserBuilderImpl setKeepCurrentDirectory(boolean keepCurrentDirectory) {
            this.keepCurrentDirectory = keepCurrentDirectory;
            return this;
        }

        @Override
        public File choose() {
            File result = null;
            switch (this.chooseMode) {
                case LOAD_FILE: {
                    result = this.chooseToLoadFile();
                    break;
                }
                case LOAD_DIRECTORY: {
                    result = this.chooseToLoadDirectory();
                    break;
                }
                case SAVE: {
                    result = this.chooseToSave();
                }
            }
            return result;
        }

        protected File chooseToLoadFile() {
            block11: {
                try {
                    File theFile;
                    File directory = this.startDirectory == null ? JaxxFileChooser.getCurrentDirectory() : this.startDirectory;
                    JFileChooser chooser = new JFileChooser(directory);
                    chooser.setDialogType(2);
                    if (CollectionUtils.isNotEmpty(this.fileFilters)) {
                        for (FileFilter filter : this.fileFilters) {
                            chooser.addChoosableFileFilter(filter);
                        }
                        chooser.setFileFilter(this.fileFilters.get(0));
                    }
                    chooser.setAcceptAllFileFilterUsed(this.useAcceptAllFileFilter);
                    chooser.setMultiSelectionEnabled(this.multiSelectionEnabled);
                    chooser.setFileHidingEnabled(this.fileHidingEnabled);
                    if (this.showFiles) {
                        if (this.showDirectories) {
                            chooser.setFileSelectionMode(2);
                        } else {
                            chooser.setFileSelectionMode(0);
                        }
                    } else if (this.showDirectories) {
                        chooser.setFileSelectionMode(1);
                    }
                    chooser.setDialogTitle(this.title);
                    int returnVal = chooser.showDialog(this.parent, this.approvalText);
                    if (returnVal == 0 && (theFile = chooser.getSelectedFile()) != null) {
                        if (this.keepCurrentDirectory) {
                            JaxxFileChooser.setCurrentDirectory(theFile);
                        }
                        return theFile.getAbsoluteFile();
                    }
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block11;
                    log.warn("Could not choose file to load", (Throwable)eee);
                }
            }
            return null;
        }

        protected File chooseToLoadDirectory() {
            block6: {
                try {
                    File directory = this.startDirectory == null ? JaxxFileChooser.getCurrentDirectory() : this.startDirectory;
                    JFileChooser chooser = new JFileChooser(directory);
                    chooser.setDialogType(2);
                    chooser.setFileSelectionMode(1);
                    chooser.setDialogTitle(this.title);
                    int returnVal = chooser.showDialog(this.parent, this.approvalText);
                    if (returnVal == 0) {
                        File theFile = chooser.getSelectedFile();
                        if (theFile != null) {
                            if (this.keepCurrentDirectory) {
                                JaxxFileChooser.setCurrentDirectory(theFile);
                            }
                            if (theFile.isDirectory()) {
                                return theFile;
                            }
                        }
                        break block6;
                    }
                    return null;
                }
                catch (Exception eee) {
                    log.warn("Could not choose directory to load", (Throwable)eee);
                }
            }
            return null;
        }

        protected File chooseToSave() {
            File directory = this.startDirectory == null ? JaxxFileChooser.getCurrentDirectory() : this.startDirectory;
            File selectedFile = new File(directory, this.filename);
            JFileChooser chooser = new JFileChooser(selectedFile);
            chooser.setDialogType(1);
            chooser.setSelectedFile(selectedFile);
            if (CollectionUtils.isNotEmpty(this.fileFilters)) {
                for (FileFilter filter : this.fileFilters) {
                    chooser.addChoosableFileFilter(filter);
                }
                chooser.setFileFilter(this.fileFilters.get(0));
            }
            chooser.setFileSelectionMode(0);
            chooser.setDialogTitle(this.title);
            File result = null;
            int returnVal = chooser.showDialog(this.parent, this.approvalText);
            if (returnVal == 0 && (result = chooser.getSelectedFile()) != null) {
                if (this.keepCurrentDirectory) {
                    JaxxFileChooser.setCurrentDirectory(result);
                }
                result = result.getAbsoluteFile();
            }
            return result;
        }

        public static class PatternChooserFilter
        extends FileFilter {
            protected final String pattern;
            protected final String description;

            public PatternChooserFilter(String pattern, String description) {
                this.pattern = StringUtils.lowerCase((String)pattern);
                this.description = description;
            }

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getAbsolutePath().toLowerCase().matches(this.pattern);
            }

            @Override
            public String getDescription() {
                return this.description;
            }
        }
    }

    private static enum ChooseMode {
        LOAD_FILE,
        LOAD_DIRECTORY,
        SAVE;

    }

    public static interface ToSave {
        public ToSave setTitle(String var1);

        public ToSave setApprovalText(String var1);

        public ToSave setParent(Component var1);

        public ToSave setPatternOrDescriptionFilters(List<String> var1);

        public ToSave setPatternOrDescriptionFilters(String var1, String var2, String ... var3);

        public ToSave setFileFilters(FileFilter var1, FileFilter ... var2);

        public ToSave setFileFilters(List<FileFilter> var1);

        public ToSave setFileHidingEnabled(boolean var1);

        public ToSave setUseAcceptAllFileFilter(boolean var1);

        public ToSave setFilename(String var1);

        public ToSave setStartDirectory(File var1);

        public ToSave setKeepCurrentDirectory(boolean var1);

        public File choose();
    }

    public static interface ToLoadDirectory {
        public ToLoadDirectory setTitle(String var1);

        public ToLoadDirectory setApprovalText(String var1);

        public ToLoadDirectory setParent(Component var1);

        public ToLoadDirectory setStartDirectory(File var1);

        public ToLoadDirectory setKeepCurrentDirectory(boolean var1);

        public File choose();
    }

    public static interface ToLoadFile {
        public ToLoadFile setTitle(String var1);

        public ToLoadFile setApprovalText(String var1);

        public ToLoadFile setParent(Component var1);

        public ToLoadFile setPatternOrDescriptionFilters(List<String> var1);

        public ToLoadFile setPatternOrDescriptionFilters(String var1, String var2, String ... var3);

        public ToLoadFile setFileFilters(FileFilter var1, FileFilter ... var2);

        public ToLoadFile setFileFilters(List<FileFilter> var1);

        public ToLoadFile setShowFiles(boolean var1);

        public ToLoadFile setShowDirectories(boolean var1);

        public ToLoadFile setMultiSelectionEnabled(boolean var1);

        public ToLoadFile setFileHidingEnabled(boolean var1);

        public ToLoadFile setUseAcceptAllFileFilter(boolean var1);

        public ToLoadFile setStartDirectory(File var1);

        public ToLoadFile setKeepCurrentDirectory(boolean var1);

        public File choose();
    }
}

